/*
 * Decompiled with CFR 0.152.
 */
package de.simplicit.vjdbc.servlet.jakarta;

import de.simplicit.vjdbc.command.Command;
import de.simplicit.vjdbc.serial.CallingContext;
import de.simplicit.vjdbc.serial.UIDEx;
import de.simplicit.vjdbc.servlet.AbstractServletCommandSinkClient;
import de.simplicit.vjdbc.servlet.RequestEnhancer;
import de.simplicit.vjdbc.servlet.jakarta.ConnectRequestEntity;
import de.simplicit.vjdbc.servlet.jakarta.ProcessRequestEntity;
import de.simplicit.vjdbc.servlet.jakarta.RequestModifierJakartaHttpClient;
import de.simplicit.vjdbc.util.SQLExceptionHelper;
import de.simplicit.vjdbc.util.StreamCloser;
import java.io.BufferedInputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpClientError;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;

public class ServletCommandSinkJakartaHttpClient
extends AbstractServletCommandSinkClient {
    private String _urlExternalForm;
    private HttpClient _httpClient;
    private MultiThreadedHttpConnectionManager _multiThreadedHttpConnectionManager;

    public ServletCommandSinkJakartaHttpClient(String url, RequestEnhancer requestEnhancer) throws SQLException {
        super(url, requestEnhancer);
        this._urlExternalForm = this._url.toExternalForm();
        this._multiThreadedHttpConnectionManager = new MultiThreadedHttpConnectionManager();
        this._httpClient = new HttpClient((HttpConnectionManager)this._multiThreadedHttpConnectionManager);
        this._httpClient.getParams().setBooleanParameter("http.connection.stalecheck", false);
    }

    public void close() {
        super.close();
        this._multiThreadedHttpConnectionManager.shutdown();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public UIDEx connect(String database, Properties props, Properties clientInfo, CallingContext ctx) throws SQLException {
        UIDEx uIDEx;
        PostMethod post = null;
        OutputStream oos = null;
        ObjectInputStream ois = null;
        try {
            post = new PostMethod(this._urlExternalForm);
            post.setDoAuthentication(false);
            post.setFollowRedirects(false);
            post.setRequestHeader("Content-type", "binary/x-java-serialized");
            post.setRequestHeader("vjdbc-method", "connect");
            if (this._requestEnhancer != null) {
                this._requestEnhancer.enhanceConnectRequest(new RequestModifierJakartaHttpClient(post));
            }
            post.setRequestEntity((RequestEntity)new ConnectRequestEntity(database, props, clientInfo, ctx));
            this._httpClient.executeMethod((HttpMethod)post);
            if (post.getStatusCode() != 200) {
                throw SQLExceptionHelper.wrap((Throwable)new HttpClientError(post.getStatusLine().toString()));
            }
            ois = new ObjectInputStream(new BufferedInputStream(post.getResponseBodyAsStream()));
            Object result = ois.readObject();
            if (result instanceof SQLException) {
                throw (SQLException)result;
            }
            uIDEx = (UIDEx)result;
        }
        catch (SQLException e) {
            try {
                throw e;
                catch (Exception e2) {
                    throw SQLExceptionHelper.wrap(e2);
                }
            }
            catch (Throwable throwable) {
                StreamCloser.close(oos);
                StreamCloser.close(ois);
                if (post != null) {
                    post.releaseConnection();
                }
                throw throwable;
            }
        }
        StreamCloser.close(oos);
        StreamCloser.close(ois);
        if (post != null) {
            post.releaseConnection();
        }
        return uIDEx;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object process(Long connuid, Long uid, Command cmd, CallingContext ctx) throws SQLException {
        Object object;
        PostMethod post = null;
        OutputStream oos = null;
        ObjectInputStream ois = null;
        try {
            post = new PostMethod(this._urlExternalForm);
            post.setDoAuthentication(false);
            post.setFollowRedirects(false);
            post.setContentChunked(false);
            post.setRequestHeader("vjdbc-method", "process");
            if (this._requestEnhancer != null) {
                this._requestEnhancer.enhanceProcessRequest(new RequestModifierJakartaHttpClient(post));
            }
            post.setRequestEntity((RequestEntity)new ProcessRequestEntity(connuid, uid, cmd, ctx));
            this._httpClient.executeMethod((HttpMethod)post);
            if (post.getStatusCode() != 200) {
                throw SQLExceptionHelper.wrap((Throwable)new HttpClientError(post.getStatusLine().toString()));
            }
            ois = new ObjectInputStream(new BufferedInputStream(post.getResponseBodyAsStream()));
            Object result = ois.readObject();
            if (result instanceof SQLException) {
                throw (SQLException)result;
            }
            object = result;
        }
        catch (SQLException e) {
            try {
                throw e;
                catch (Exception e2) {
                    throw SQLExceptionHelper.wrap(e2);
                }
            }
            catch (Throwable throwable) {
                StreamCloser.close(oos);
                StreamCloser.close(ois);
                if (post != null) {
                    post.releaseConnection();
                }
                throw throwable;
            }
        }
        StreamCloser.close(oos);
        StreamCloser.close(ois);
        if (post != null) {
            post.releaseConnection();
        }
        return object;
    }
}

