/*
 * Decompiled with CFR 0.152.
 */
package de.simplicit.vjdbc.serial;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SerialResultSetMetaData
implements ResultSetMetaData,
Externalizable {
    static final long serialVersionUID = 9034215340975782405L;
    private int _columnCount;
    private String[] _catalogName;
    private String[] _schemaName;
    private String[] _tableName;
    private String[] _columnClassName;
    private String[] _columnLabel;
    private String[] _columnName;
    private String[] _columnTypeName;
    private Integer[] _columnType;
    private Integer[] _columnDisplaySize;
    private Integer[] _precision;
    private Integer[] _scale;
    private Integer[] _nullable;
    private Boolean[] _autoIncrement;
    private Boolean[] _caseSensitive;
    private Boolean[] _currency;
    private Boolean[] _readOnly;
    private Boolean[] _searchable;
    private Boolean[] _signed;
    private Boolean[] _writable;
    private Boolean[] _definitivelyWritable;

    public SerialResultSetMetaData() {
    }

    public SerialResultSetMetaData(ResultSetMetaData rsmd) throws SQLException {
        this._columnCount = rsmd.getColumnCount();
        this.allocateArrays();
        this.fillArrays(rsmd);
    }

    public String[] readStringArr(ObjectInput in) throws IOException {
        int numElems = in.readShort();
        if (numElems != -1) {
            String[] ret = new String[numElems];
            for (int i = 0; i < numElems; ++i) {
                byte notNull = in.readByte();
                ret[i] = 1 == notNull ? in.readUTF() : null;
            }
            return ret;
        }
        return null;
    }

    public void writeStringArr(String[] arr, ObjectOutput out) throws IOException {
        if (arr != null) {
            out.writeShort(arr.length);
            for (int i = 0; i < arr.length; ++i) {
                if (arr[i] != null) {
                    out.writeByte(1);
                    out.writeUTF(arr[i]);
                    continue;
                }
                out.writeByte(0);
            }
        } else {
            out.writeShort(-1);
        }
    }

    public Integer[] readIntArr(ObjectInput in) throws IOException {
        int numElems = in.readShort();
        if (numElems != -1) {
            Integer[] ret = new Integer[numElems];
            for (int i = 0; i < numElems; ++i) {
                ret[i] = new Integer(in.readInt());
            }
            return ret;
        }
        return null;
    }

    public void writeIntArr(Integer[] arr, ObjectOutput out) throws IOException {
        if (arr != null) {
            out.writeShort(arr.length);
            for (int i = 0; i < arr.length; ++i) {
                out.writeInt(arr[i]);
            }
        } else {
            out.writeShort(-1);
        }
    }

    public Boolean[] readBooleanArr(ObjectInput in) throws IOException {
        int numElems = in.readShort();
        if (numElems != -1) {
            Boolean[] ret = new Boolean[numElems];
            for (int i = 0; i < numElems; ++i) {
                ret[i] = new Boolean(in.readBoolean());
            }
            return ret;
        }
        return null;
    }

    public void writeBooleanArr(Boolean[] arr, ObjectOutput out) throws IOException {
        if (arr != null) {
            out.writeShort(arr.length);
            for (int i = 0; i < arr.length; ++i) {
                out.writeBoolean(arr[i]);
            }
        } else {
            out.writeShort(-1);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this._columnCount = in.readInt();
        this._catalogName = this.readStringArr(in);
        this._schemaName = this.readStringArr(in);
        this._tableName = this.readStringArr(in);
        this._columnClassName = this.readStringArr(in);
        this._columnLabel = this.readStringArr(in);
        this._columnName = this.readStringArr(in);
        this._columnTypeName = this.readStringArr(in);
        this._columnType = this.readIntArr(in);
        this._columnDisplaySize = this.readIntArr(in);
        this._precision = this.readIntArr(in);
        this._scale = this.readIntArr(in);
        this._nullable = this.readIntArr(in);
        this._autoIncrement = this.readBooleanArr(in);
        this._caseSensitive = this.readBooleanArr(in);
        this._currency = this.readBooleanArr(in);
        this._readOnly = this.readBooleanArr(in);
        this._searchable = this.readBooleanArr(in);
        this._signed = this.readBooleanArr(in);
        this._writable = this.readBooleanArr(in);
        this._definitivelyWritable = this.readBooleanArr(in);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this._columnCount);
        this.writeStringArr(this._catalogName, out);
        this.writeStringArr(this._schemaName, out);
        this.writeStringArr(this._tableName, out);
        this.writeStringArr(this._columnClassName, out);
        this.writeStringArr(this._columnLabel, out);
        this.writeStringArr(this._columnName, out);
        this.writeStringArr(this._columnTypeName, out);
        this.writeIntArr(this._columnType, out);
        this.writeIntArr(this._columnDisplaySize, out);
        this.writeIntArr(this._precision, out);
        this.writeIntArr(this._scale, out);
        this.writeIntArr(this._nullable, out);
        this.writeBooleanArr(this._autoIncrement, out);
        this.writeBooleanArr(this._caseSensitive, out);
        this.writeBooleanArr(this._currency, out);
        this.writeBooleanArr(this._readOnly, out);
        this.writeBooleanArr(this._searchable, out);
        this.writeBooleanArr(this._signed, out);
        this.writeBooleanArr(this._writable, out);
        this.writeBooleanArr(this._definitivelyWritable, out);
    }

    private void allocateArrays() {
        this._catalogName = new String[this._columnCount];
        this._schemaName = new String[this._columnCount];
        this._tableName = new String[this._columnCount];
        this._columnClassName = new String[this._columnCount];
        this._columnLabel = new String[this._columnCount];
        this._columnName = new String[this._columnCount];
        this._columnTypeName = new String[this._columnCount];
        this._columnDisplaySize = new Integer[this._columnCount];
        this._columnType = new Integer[this._columnCount];
        this._precision = new Integer[this._columnCount];
        this._scale = new Integer[this._columnCount];
        this._nullable = new Integer[this._columnCount];
        this._autoIncrement = new Boolean[this._columnCount];
        this._caseSensitive = new Boolean[this._columnCount];
        this._currency = new Boolean[this._columnCount];
        this._readOnly = new Boolean[this._columnCount];
        this._searchable = new Boolean[this._columnCount];
        this._signed = new Boolean[this._columnCount];
        this._writable = new Boolean[this._columnCount];
        this._definitivelyWritable = new Boolean[this._columnCount];
    }

    private void fillArrays(ResultSetMetaData rsmd) {
        for (int i = 0; i < this._columnCount; ++i) {
            int col = i + 1;
            try {
                this._catalogName[i] = rsmd.getCatalogName(col);
            }
            catch (Exception e) {
                this._catalogName[i] = null;
            }
            try {
                this._schemaName[i] = rsmd.getSchemaName(col);
            }
            catch (Exception e1) {
                this._schemaName[i] = null;
            }
            try {
                this._tableName[i] = rsmd.getTableName(col);
            }
            catch (Exception e2) {
                this._tableName[i] = null;
            }
            try {
                this._columnLabel[i] = rsmd.getColumnLabel(col);
            }
            catch (Exception e3) {
                this._columnLabel[i] = null;
            }
            try {
                this._columnName[i] = rsmd.getColumnName(col);
            }
            catch (Exception e4) {
                this._columnName[i] = null;
            }
            try {
                this._columnClassName[i] = rsmd.getColumnClassName(col);
            }
            catch (Exception e5) {
                this._columnClassName[i] = null;
            }
            try {
                this._columnTypeName[i] = rsmd.getColumnTypeName(col);
            }
            catch (Exception e6) {
                this._columnTypeName[i] = null;
            }
            try {
                this._columnDisplaySize[i] = new Integer(rsmd.getColumnDisplaySize(col));
            }
            catch (Exception e7) {
                this._columnDisplaySize[i] = null;
            }
            try {
                this._columnType[i] = new Integer(rsmd.getColumnType(col));
            }
            catch (Exception e8) {
                this._columnType[i] = null;
            }
            try {
                this._precision[i] = new Integer(rsmd.getPrecision(col));
            }
            catch (Exception e9) {
                this._precision[i] = null;
            }
            try {
                this._scale[i] = new Integer(rsmd.getScale(col));
            }
            catch (Exception e10) {
                this._scale[i] = null;
            }
            try {
                this._nullable[i] = new Integer(rsmd.isNullable(col));
            }
            catch (Exception e11) {
                this._nullable[i] = null;
            }
            try {
                this._autoIncrement[i] = rsmd.isAutoIncrement(col) ? Boolean.TRUE : Boolean.FALSE;
            }
            catch (Exception e12) {
                this._autoIncrement[i] = null;
            }
            try {
                this._caseSensitive[i] = rsmd.isCaseSensitive(col) ? Boolean.TRUE : Boolean.FALSE;
            }
            catch (Exception e13) {
                this._caseSensitive[i] = null;
            }
            try {
                this._currency[i] = rsmd.isCurrency(col) ? Boolean.TRUE : Boolean.FALSE;
            }
            catch (Exception e14) {
                this._currency[i] = null;
            }
            try {
                this._readOnly[i] = rsmd.isReadOnly(col) ? Boolean.TRUE : Boolean.FALSE;
            }
            catch (Exception e15) {
                this._readOnly[i] = null;
            }
            try {
                this._searchable[i] = rsmd.isSearchable(col) ? Boolean.TRUE : Boolean.FALSE;
            }
            catch (Exception e16) {
                this._searchable[i] = null;
            }
            try {
                this._signed[i] = rsmd.isSigned(col) ? Boolean.TRUE : Boolean.FALSE;
            }
            catch (Exception e17) {
                this._signed[i] = null;
            }
            try {
                this._writable[i] = rsmd.isWritable(col) ? Boolean.TRUE : Boolean.FALSE;
            }
            catch (Exception e18) {
                this._writable[i] = null;
            }
            try {
                this._definitivelyWritable[i] = rsmd.isDefinitelyWritable(col) ? Boolean.TRUE : Boolean.FALSE;
                continue;
            }
            catch (Exception e18) {
                this._definitivelyWritable[i] = null;
            }
        }
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this._columnCount;
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        this.checkColumnIndex(column);
        this.throwIfNull(this._autoIncrement[column - 1]);
        return this._autoIncrement[column - 1];
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        this.checkColumnIndex(column);
        this.throwIfNull(this._caseSensitive[column - 1]);
        return this._caseSensitive[column - 1];
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        this.checkColumnIndex(column);
        this.throwIfNull(this._searchable[column - 1]);
        return this._searchable[column - 1];
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        this.checkColumnIndex(column);
        this.throwIfNull(this._currency[column - 1]);
        return this._currency[column - 1];
    }

    @Override
    public int isNullable(int column) throws SQLException {
        this.checkColumnIndex(column);
        this.throwIfNull(this._nullable[column - 1]);
        return this._nullable[column - 1];
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        this.checkColumnIndex(column);
        this.throwIfNull(this._signed[column - 1]);
        return this._signed[column - 1];
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        this.checkColumnIndex(column);
        this.throwIfNull(this._columnDisplaySize[column - 1]);
        return this._columnDisplaySize[column - 1];
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        this.checkColumnIndex(column);
        this.throwIfNull(this._columnLabel[column - 1]);
        return this._columnLabel[column - 1];
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        this.checkColumnIndex(column);
        this.throwIfNull(this._columnName[column - 1]);
        return this._columnName[column - 1];
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        this.checkColumnIndex(column);
        this.throwIfNull(this._schemaName[column - 1]);
        return this._schemaName[column - 1];
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        this.checkColumnIndex(column);
        this.throwIfNull(this._precision[column - 1]);
        return this._precision[column - 1];
    }

    @Override
    public int getScale(int column) throws SQLException {
        this.checkColumnIndex(column);
        this.throwIfNull(this._scale[column - 1]);
        return this._scale[column - 1];
    }

    @Override
    public String getTableName(int column) throws SQLException {
        this.checkColumnIndex(column);
        this.throwIfNull(this._tableName[column - 1]);
        return this._tableName[column - 1];
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        this.checkColumnIndex(column);
        this.throwIfNull(this._catalogName[column - 1]);
        return this._catalogName[column - 1];
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        this.checkColumnIndex(column);
        this.throwIfNull(this._columnType[column - 1]);
        return this._columnType[column - 1];
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        this.checkColumnIndex(column);
        this.throwIfNull(this._columnTypeName[column - 1]);
        return this._columnTypeName[column - 1];
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        this.checkColumnIndex(column);
        this.throwIfNull(this._readOnly[column - 1]);
        return this._readOnly[column - 1];
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        this.checkColumnIndex(column);
        this.throwIfNull(this._writable[column - 1]);
        return this._writable[column - 1];
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        this.checkColumnIndex(column);
        this.throwIfNull(this._definitivelyWritable[column - 1]);
        return this._definitivelyWritable[column - 1];
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        this.checkColumnIndex(column);
        this.throwIfNull(this._columnClassName[column - 1]);
        return this._columnClassName[column - 1];
    }

    public void setColumnCount(int columnCount) throws SQLException {
        if (columnCount < 0) {
            throw new SQLException("invalid number of columns " + columnCount);
        }
        this._columnCount = columnCount;
        this.allocateArrays();
    }

    public void setAutoIncrement(int columnIndex, boolean property) throws SQLException {
        this.checkColumnIndex(columnIndex);
        this._autoIncrement[columnIndex - 1] = new Boolean(property);
    }

    public void setCaseSensitive(int columnIndex, boolean property) throws SQLException {
        this.checkColumnIndex(columnIndex);
        this._caseSensitive[columnIndex - 1] = new Boolean(property);
    }

    public void setCatalogName(int columnIndex, String catalogName) throws SQLException {
        this.checkColumnIndex(columnIndex);
        this._catalogName[columnIndex - 1] = catalogName;
    }

    public void setColumnDisplaySize(int columnIndex, int size) throws SQLException {
        this.checkColumnIndex(columnIndex);
        this._columnDisplaySize[columnIndex - 1] = new Integer(size);
    }

    public void setColumnLabel(int columnIndex, String label) throws SQLException {
        this.checkColumnIndex(columnIndex);
        this._columnLabel[columnIndex - 1] = label;
    }

    public void setColumnName(int columnIndex, String columnName) throws SQLException {
        this.checkColumnIndex(columnIndex);
        this._columnName[columnIndex - 1] = columnName;
    }

    public void setColumnType(int columnIndex, int SQLType2) throws SQLException {
        this.checkColumnIndex(columnIndex);
        this._columnType[columnIndex - 1] = new Integer(SQLType2);
    }

    public void setColumnTypeName(int columnIndex, String typeName) throws SQLException {
        this.checkColumnIndex(columnIndex);
        this._columnTypeName[columnIndex - 1] = typeName;
    }

    public void setCurrency(int columnIndex, boolean property) throws SQLException {
        this.checkColumnIndex(columnIndex);
        this._currency[columnIndex - 1] = new Boolean(property);
    }

    public void setNullable(int columnIndex, int property) throws SQLException {
        this.checkColumnIndex(columnIndex);
        this._nullable[columnIndex - 1] = new Integer(property);
    }

    public void setPrecision(int columnIndex, int precision) throws SQLException {
        this.checkColumnIndex(columnIndex);
        this._precision[columnIndex - 1] = new Integer(precision);
    }

    public void setScale(int columnIndex, int scale) throws SQLException {
        this.checkColumnIndex(columnIndex);
        this._scale[columnIndex - 1] = new Integer(scale);
    }

    public void setSchemaName(int columnIndex, String schemaName) throws SQLException {
        this.checkColumnIndex(columnIndex);
        this._schemaName[columnIndex - 1] = schemaName;
    }

    public void setSearchable(int columnIndex, boolean property) throws SQLException {
        this.checkColumnIndex(columnIndex);
        this._searchable[columnIndex - 1] = new Boolean(property);
    }

    public void setSigned(int columnIndex, boolean property) throws SQLException {
        this.checkColumnIndex(columnIndex);
        this._signed[columnIndex - 1] = new Boolean(property);
    }

    public void setTableName(int columnIndex, String tableName) throws SQLException {
        this.checkColumnIndex(columnIndex);
        this._tableName[columnIndex - 1] = tableName;
    }

    public void setReadOnly(int columnIndex, boolean readOnly) throws SQLException {
        this.checkColumnIndex(columnIndex);
        this._readOnly[columnIndex - 1] = new Boolean(readOnly);
    }

    public void setWritable(int columnIndex, boolean writable) throws SQLException {
        this.checkColumnIndex(columnIndex);
        this._writable[columnIndex - 1] = new Boolean(writable);
    }

    public void setDefinitelyWritable(int columnIndex, boolean writable) throws SQLException {
        this.checkColumnIndex(columnIndex);
        this._definitivelyWritable[columnIndex - 1] = new Boolean(writable);
    }

    public void setColumnClassName(int columnIndex, String columnClassName) throws SQLException {
        this.checkColumnIndex(columnIndex);
        this._columnClassName[columnIndex - 1] = columnClassName;
    }

    private void throwIfNull(Object obj) throws SQLException {
        if (obj == null) {
            throw new SQLException("Method not supported");
        }
    }

    private void checkColumnIndex(int columnIndex) throws SQLException {
        if (columnIndex < 1 || columnIndex > this._columnCount) {
            throw new SQLException("invalid column index " + columnIndex);
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isAssignableFrom(SerialResultSetMetaData.class);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return (T)this;
    }
}

