/*
 * Decompiled with CFR 0.152.
 */
package de.simplicit.vjdbc.serial;

import de.simplicit.vjdbc.util.SQLExceptionHelper;
import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;

public class SerialClob
implements Clob,
Externalizable {
    private static final long serialVersionUID = 3904682695287452212L;
    protected char[] _data;

    public SerialClob() {
    }

    public SerialClob(Clob other) throws SQLException {
        try {
            int len;
            StringWriter sw = new StringWriter();
            Reader rd = other.getCharacterStream();
            char[] buff = new char[1024];
            while ((len = rd.read(buff)) > 0) {
                sw.write(buff, 0, len);
            }
            this._data = sw.toString().toCharArray();
            other.free();
        }
        catch (IOException e) {
            throw new SQLException("Can't retrieve contents of Clob", e.toString());
        }
    }

    public SerialClob(Reader rd) throws SQLException {
        try {
            this.init(rd);
        }
        catch (IOException e) {
            throw new SQLException("Can't retrieve contents of Clob", e.toString());
        }
    }

    public SerialClob(Reader rd, long length) throws SQLException {
        try {
            this.init(rd, length);
        }
        catch (IOException e) {
            throw new SQLException("Can't retrieve contents of Clob", e.toString());
        }
    }

    public void init(Reader rd) throws IOException {
        int len;
        StringWriter sw = new StringWriter();
        char[] buff = new char[1024];
        while ((len = rd.read(buff)) > 0) {
            sw.write(buff, 0, len);
        }
        this._data = sw.toString().toCharArray();
    }

    public void init(Reader rd, long length) throws IOException {
        int len;
        StringWriter sw = new StringWriter();
        char[] buff = new char[1024];
        for (long toRead = length; toRead > 0L && (len = rd.read(buff, 0, (int)(toRead > 1024L ? 1024L : toRead))) > 0; toRead -= (long)len) {
            sw.write(buff, 0, len);
        }
        this._data = sw.toString().toCharArray();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this._data);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this._data = (char[])in.readObject();
    }

    public long length() throws SQLException {
        return this._data.length;
    }

    public String getSubString(long pos, int length) throws SQLException {
        if (pos <= Integer.MAX_VALUE) {
            return new String(this._data, (int)pos - 1, length);
        }
        CharArrayWriter writer = new CharArrayWriter(length);
        for (long i = 0L; i < (long)length; ++i) {
            writer.write(this._data[(int)(pos + i)]);
        }
        return writer.toString();
    }

    public Reader getCharacterStream() throws SQLException {
        return new StringReader(new String(this._data));
    }

    public InputStream getAsciiStream() throws SQLException {
        try {
            return new ByteArrayInputStream(new String(this._data).getBytes("US-ASCII"));
        }
        catch (UnsupportedEncodingException e) {
            throw SQLExceptionHelper.wrap(e);
        }
    }

    public long position(String searchstr, long start) throws SQLException {
        throw new UnsupportedOperationException("SerialClob.position");
    }

    public long position(Clob searchstr, long start) throws SQLException {
        throw new UnsupportedOperationException("SerialClob.position");
    }

    public int setString(long pos, String str) throws SQLException {
        throw new UnsupportedOperationException("SerialClob.setString");
    }

    public int setString(long pos, String str, int offset, int len) throws SQLException {
        throw new UnsupportedOperationException("SerialClob.setString");
    }

    public OutputStream setAsciiStream(long pos) throws SQLException {
        throw new UnsupportedOperationException("SerialClob.setAsciiStream");
    }

    public Writer setCharacterStream(long pos) throws SQLException {
        throw new UnsupportedOperationException("SerialClob.setCharacterStream");
    }

    public void truncate(long len) throws SQLException {
        throw new UnsupportedOperationException("SerialClob.truncate");
    }

    public Reader getCharacterStream(long pos, long length) throws SQLException {
        if (pos <= Integer.MAX_VALUE && length <= Integer.MAX_VALUE) {
            return new CharArrayReader(this._data, (int)pos, (int)length);
        }
        CharArrayWriter writer = new CharArrayWriter((int)length);
        for (long i = 0L; i < length; ++i) {
            writer.write(this._data[(int)(pos + i)]);
        }
        return new CharArrayReader(writer.toCharArray());
    }

    public void free() throws SQLException {
        this._data = null;
    }
}

