/*
 * Decompiled with CFR 0.152.
 */
package de.simplicit.vjdbc.serial;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;

public class SerialBlob
implements Blob,
Externalizable {
    private static final long serialVersionUID = 3258134639489857079L;
    private byte[] _data;

    public SerialBlob() {
    }

    public SerialBlob(Blob other) throws SQLException {
        try {
            int len;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            InputStream is = other.getBinaryStream();
            byte[] buff = new byte[1024];
            while ((len = is.read(buff)) > 0) {
                baos.write(buff, 0, len);
            }
            this._data = baos.toByteArray();
            other.free();
        }
        catch (IOException e) {
            throw new SQLException("Can't retrieve contents of Blob", e.toString());
        }
    }

    public SerialBlob(InputStream is) throws SQLException {
        try {
            this.init(is);
        }
        catch (IOException e) {
            throw new SQLException("Can't retrieve contents of Clob", e.toString());
        }
    }

    public SerialBlob(InputStream is, long length) throws SQLException {
        try {
            this.init(is, length);
        }
        catch (IOException e) {
            throw new SQLException("Can't retrieve contents of Clob", e.toString());
        }
    }

    public void init(InputStream is) throws IOException {
        int len;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buff = new byte[1024];
        while ((len = is.read(buff)) > 0) {
            baos.write(buff, 0, len);
        }
        this._data = baos.toByteArray();
    }

    public void init(InputStream is, long length) throws IOException {
        int len;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buff = new byte[1024];
        for (long toRead = length; toRead > 0L && (len = is.read(buff, 0, (int)(toRead > 1024L ? 1024L : toRead))) > 0; toRead -= (long)len) {
            baos.write(buff, 0, len);
        }
        this._data = baos.toByteArray();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this._data);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this._data = (byte[])in.readObject();
    }

    public long length() throws SQLException {
        return this._data.length;
    }

    public byte[] getBytes(long pos, int length) throws SQLException {
        if (pos <= Integer.MAX_VALUE) {
            byte[] result = new byte[length];
            System.arraycopy(this._data, (int)pos - 1, result, 0, length);
            return result;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        for (long i = 0L; i < (long)length; ++i) {
            baos.write(this._data[(int)(pos + i)]);
        }
        return baos.toByteArray();
    }

    public InputStream getBinaryStream() throws SQLException {
        return new ByteArrayInputStream(this._data);
    }

    public long position(byte[] pattern, long start) throws SQLException {
        throw new UnsupportedOperationException("Blob.position");
    }

    public long position(Blob pattern, long start) throws SQLException {
        throw new UnsupportedOperationException("Blob.position");
    }

    public int setBytes(long pos, byte[] bytes) throws SQLException {
        throw new UnsupportedOperationException("Blob.setBytes");
    }

    public int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
        throw new UnsupportedOperationException("Blob.setBytes");
    }

    public OutputStream setBinaryStream(long pos) throws SQLException {
        throw new UnsupportedOperationException("Blob.setBinaryStream");
    }

    public void truncate(long len) throws SQLException {
        throw new UnsupportedOperationException("Blob.truncate");
    }

    public InputStream getBinaryStream(long pos, long length) throws SQLException {
        if (pos <= Integer.MAX_VALUE && length <= Integer.MAX_VALUE) {
            return new ByteArrayInputStream(this._data, (int)pos, (int)length);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        for (long i = 0L; i < length; ++i) {
            baos.write(this._data[(int)(i + pos)]);
        }
        return new ByteArrayInputStream(baos.toByteArray());
    }

    public void free() throws SQLException {
        this._data = null;
    }
}

