/*
 * Decompiled with CFR 0.152.
 */
package de.simplicit.vjdbc.serial;

import de.simplicit.vjdbc.serial.FlattenedColumnValues;
import de.simplicit.vjdbc.serial.SerialArray;
import de.simplicit.vjdbc.serial.SerialBlob;
import de.simplicit.vjdbc.serial.SerialClob;
import de.simplicit.vjdbc.serial.SerialJavaObject;
import de.simplicit.vjdbc.serial.SerialNClob;
import de.simplicit.vjdbc.serial.SerialRowId;
import de.simplicit.vjdbc.serial.SerialSQLXML;
import de.simplicit.vjdbc.serial.SerialStruct;
import de.simplicit.vjdbc.util.JavaVersionInfo;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Struct;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RowPacket
implements Externalizable {
    private static final int ORACLE_ROW_ID = -8;
    private static final int DEFAULT_ARRAY_SIZE = 100;
    static final long serialVersionUID = 6366194574502000718L;
    private static Log _logger = LogFactory.getLog(RowPacket.class);
    private int _rowCount = 0;
    private boolean _forwardOnly = false;
    private boolean _lastPart = false;
    private transient FlattenedColumnValues[] _flattenedColumnsValues = null;
    private transient ArrayList _rows = null;
    private transient int[] _columnTypes = null;
    private transient int _offset = 0;
    private transient int _maxrows = 0;

    public RowPacket() {
    }

    public RowPacket(int packetsize, boolean forwardOnly) {
        this._maxrows = packetsize;
        this._forwardOnly = forwardOnly;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeBoolean(this._forwardOnly);
        out.writeBoolean(this._lastPart);
        out.writeInt(this._rowCount);
        if (this._rowCount > 0) {
            out.writeObject(this._flattenedColumnsValues);
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this._forwardOnly = in.readBoolean();
        this._lastPart = in.readBoolean();
        this._rowCount = in.readInt();
        if (this._rowCount > 0) {
            FlattenedColumnValues[] flattenedColumns = (FlattenedColumnValues[])in.readObject();
            this._rows = new ArrayList(this._rowCount);
            for (int i = 0; i < this._rowCount; ++i) {
                Object[] row = new Object[flattenedColumns.length];
                for (int j = 0; j < flattenedColumns.length; ++j) {
                    row[j] = flattenedColumns[j].getValue(i);
                }
                this._rows.add(row);
            }
        } else {
            this._rows = new ArrayList();
        }
    }

    public Object[] get(int index) throws SQLException {
        int adjustedIndex = index - this._offset;
        if (adjustedIndex < 0) {
            throw new SQLException("Index " + index + " is below the possible index");
        }
        if (adjustedIndex >= this._rows.size()) {
            throw new SQLException("Index " + index + " is above the possible index");
        }
        return (Object[])this._rows.get(adjustedIndex);
    }

    public int size() {
        return this._offset + this._rowCount;
    }

    public boolean isLastPart() {
        return this._lastPart;
    }

    public boolean populate(ResultSet rs) throws SQLException {
        ResultSetMetaData metaData = rs.getMetaData();
        int columnCount = metaData.getColumnCount();
        this._rowCount = 0;
        while (rs.next()) {
            if (this._rowCount == 0) {
                this.prepareFlattenedColumns(metaData, columnCount);
            }
            for (int i = 1; i <= columnCount; ++i) {
                boolean foundMatch = true;
                int internalIndex = i - 1;
                switch (this._columnTypes[internalIndex]) {
                    case 0: {
                        this._flattenedColumnsValues[internalIndex].setObject(this._rowCount, null);
                        break;
                    }
                    case -1: 
                    case 1: 
                    case 12: {
                        this._flattenedColumnsValues[internalIndex].setObject(this._rowCount, rs.getString(i));
                        break;
                    }
                    case -16: 
                    case -15: 
                    case -9: {
                        this._flattenedColumnsValues[internalIndex].setObject(this._rowCount, rs.getNString(i));
                        break;
                    }
                    case 2: 
                    case 3: {
                        this._flattenedColumnsValues[internalIndex].setObject(this._rowCount, rs.getBigDecimal(i));
                        break;
                    }
                    case -7: 
                    case 1111: {
                        this._flattenedColumnsValues[internalIndex].setBoolean(this._rowCount, rs.getBoolean(i));
                        break;
                    }
                    case -6: {
                        this._flattenedColumnsValues[internalIndex].setByte(this._rowCount, rs.getByte(i));
                        break;
                    }
                    case 5: {
                        this._flattenedColumnsValues[internalIndex].setShort(this._rowCount, rs.getShort(i));
                        break;
                    }
                    case 4: {
                        this._flattenedColumnsValues[internalIndex].setInt(this._rowCount, rs.getInt(i));
                        break;
                    }
                    case -5: {
                        this._flattenedColumnsValues[internalIndex].setLong(this._rowCount, rs.getLong(i));
                        break;
                    }
                    case 7: {
                        this._flattenedColumnsValues[internalIndex].setFloat(this._rowCount, rs.getFloat(i));
                        break;
                    }
                    case 6: 
                    case 8: {
                        this._flattenedColumnsValues[internalIndex].setDouble(this._rowCount, rs.getDouble(i));
                        break;
                    }
                    case 91: {
                        this._flattenedColumnsValues[internalIndex].setObject(this._rowCount, rs.getDate(i));
                        break;
                    }
                    case 92: {
                        this._flattenedColumnsValues[internalIndex].setObject(this._rowCount, rs.getTime(i));
                        break;
                    }
                    case 93: {
                        this._flattenedColumnsValues[internalIndex].setObject(this._rowCount, rs.getTimestamp(i));
                        break;
                    }
                    case -4: 
                    case -3: 
                    case -2: {
                        this._flattenedColumnsValues[internalIndex].setObject(this._rowCount, rs.getBytes(i));
                        break;
                    }
                    case 2000: {
                        this._flattenedColumnsValues[internalIndex].setObject(this._rowCount, new SerialJavaObject(rs.getObject(i)));
                        break;
                    }
                    case 2005: {
                        this._flattenedColumnsValues[internalIndex].setObject(this._rowCount, new SerialClob(rs.getClob(i)));
                        break;
                    }
                    case 2011: {
                        this._flattenedColumnsValues[internalIndex].setObject(this._rowCount, new SerialNClob(rs.getNClob(i)));
                        break;
                    }
                    case 2004: {
                        this._flattenedColumnsValues[internalIndex].setObject(this._rowCount, new SerialBlob(rs.getBlob(i)));
                        break;
                    }
                    case 2003: {
                        this._flattenedColumnsValues[internalIndex].setObject(this._rowCount, new SerialArray(rs.getArray(i)));
                        break;
                    }
                    case 2002: {
                        this._flattenedColumnsValues[internalIndex].setObject(this._rowCount, new SerialStruct((Struct)rs.getObject(i)));
                        break;
                    }
                    case -8: {
                        this._flattenedColumnsValues[internalIndex].setObject(this._rowCount, new SerialRowId(rs.getRowId(i)));
                        break;
                    }
                    case 2009: {
                        this._flattenedColumnsValues[internalIndex].setObject(this._rowCount, new SerialSQLXML(rs.getSQLXML(i)));
                        break;
                    }
                    default: {
                        if (JavaVersionInfo.use14Api) {
                            if (this._columnTypes[internalIndex] == 16) {
                                this._flattenedColumnsValues[internalIndex].setBoolean(this._rowCount, rs.getBoolean(i));
                                break;
                            }
                            foundMatch = false;
                            break;
                        }
                        foundMatch = false;
                    }
                }
                if (foundMatch) {
                    if (!rs.wasNull()) continue;
                    this._flattenedColumnsValues[internalIndex].setIsNull(this._rowCount);
                    continue;
                }
                throw new SQLException("Unsupported JDBC-Type: " + this._columnTypes[internalIndex] + " hmmm...");
            }
            ++this._rowCount;
            if (this._maxrows <= 0 || this._rowCount != this._maxrows) continue;
        }
        this._lastPart = this._maxrows == 0 || this._rowCount < this._maxrows;
        return this._lastPart;
    }

    private void prepareFlattenedColumns(ResultSetMetaData metaData, int columnCount) throws SQLException {
        this._columnTypes = new int[columnCount];
        this._flattenedColumnsValues = new FlattenedColumnValues[columnCount];
        for (int i = 1; i <= columnCount; ++i) {
            int n = metaData.getColumnType(i);
            this._columnTypes[i - 1] = n;
            int columnType = n;
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)("Column-Type " + i + ": " + metaData.getColumnType(i)));
            }
            Class<Object> componentType = null;
            switch (columnType) {
                case -7: 
                case 1111: {
                    componentType = Boolean.TYPE;
                    break;
                }
                case -6: {
                    componentType = Byte.TYPE;
                    break;
                }
                case 5: {
                    componentType = Short.TYPE;
                    break;
                }
                case 4: {
                    componentType = Integer.TYPE;
                    break;
                }
                case -5: {
                    componentType = Long.TYPE;
                    break;
                }
                case 7: {
                    componentType = Float.TYPE;
                    break;
                }
                case 6: 
                case 8: {
                    componentType = Double.TYPE;
                    break;
                }
                default: {
                    if (JavaVersionInfo.use14Api) {
                        if (columnType == 16) {
                            componentType = Boolean.TYPE;
                            break;
                        }
                        componentType = Object.class;
                        break;
                    }
                    componentType = Object.class;
                }
            }
            this._flattenedColumnsValues[i - 1] = new FlattenedColumnValues(componentType, this._maxrows == 0 ? 100 : this._maxrows);
        }
    }

    public void merge(RowPacket rsp) {
        if (this._forwardOnly) {
            this._offset += this._rowCount;
            this._rowCount = rsp._rowCount;
            this._rows = rsp._rows;
        } else {
            this._rows.addAll(rsp._rows);
            this._rowCount = this._rows.size();
        }
    }
}

