/*
 * Decompiled with CFR 0.152.
 */
package de.simplicit.vjdbc.serial;

import de.simplicit.vjdbc.serial.ArrayAccess;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Map;

class ArrayAccessors {
    private static Map _arrayAccessors = new HashMap();
    private static ArrayAccess _objectArrayFiller = new ArrayAccessObject();

    ArrayAccessors() {
    }

    static ArrayAccess getArrayAccessorForPrimitiveType(Class primitiveType) {
        return (ArrayAccess)_arrayAccessors.get(primitiveType);
    }

    static ArrayAccess getObjectArrayAccessor() {
        return _objectArrayFiller;
    }

    static {
        _arrayAccessors.put(Boolean.TYPE, new ArrayAccessBoolean());
        _arrayAccessors.put(Byte.TYPE, new ArrayAccessByte());
        _arrayAccessors.put(Character.TYPE, new ArrayAccessCharacter());
        _arrayAccessors.put(Short.TYPE, new ArrayAccessShort());
        _arrayAccessors.put(Integer.TYPE, new ArrayAccessInteger());
        _arrayAccessors.put(Long.TYPE, new ArrayAccessLong());
        _arrayAccessors.put(Float.TYPE, new ArrayAccessFloat());
        _arrayAccessors.put(Double.TYPE, new ArrayAccessDouble());
    }

    private static class ArrayAccessObject
    implements ArrayAccess {
        private ArrayAccessObject() {
        }

        public Object getValue(Object array, int index, boolean[] nullFlags) {
            return Array.get(array, index);
        }
    }

    private static class ArrayAccessDouble
    implements ArrayAccess {
        private ArrayAccessDouble() {
        }

        public Object getValue(Object array, int index, boolean[] nullFlags) {
            if (nullFlags[index]) {
                return null;
            }
            return new Double(Array.getDouble(array, index));
        }
    }

    private static class ArrayAccessFloat
    implements ArrayAccess {
        private ArrayAccessFloat() {
        }

        public Object getValue(Object array, int index, boolean[] nullFlags) {
            if (nullFlags[index]) {
                return null;
            }
            return new Float(Array.getFloat(array, index));
        }
    }

    private static class ArrayAccessLong
    implements ArrayAccess {
        private ArrayAccessLong() {
        }

        public Object getValue(Object array, int index, boolean[] nullFlags) {
            if (nullFlags[index]) {
                return null;
            }
            return new Long(Array.getLong(array, index));
        }
    }

    private static class ArrayAccessInteger
    implements ArrayAccess {
        private ArrayAccessInteger() {
        }

        public Object getValue(Object array, int index, boolean[] nullFlags) {
            if (nullFlags[index]) {
                return null;
            }
            return new Integer(Array.getInt(array, index));
        }
    }

    private static class ArrayAccessShort
    implements ArrayAccess {
        private ArrayAccessShort() {
        }

        public Object getValue(Object array, int index, boolean[] nullFlags) {
            if (nullFlags[index]) {
                return null;
            }
            return new Short(Array.getShort(array, index));
        }
    }

    private static class ArrayAccessCharacter
    implements ArrayAccess {
        private ArrayAccessCharacter() {
        }

        public Object getValue(Object array, int index, boolean[] nullFlags) {
            if (nullFlags[index]) {
                return null;
            }
            return new Character(Array.getChar(array, index));
        }
    }

    private static class ArrayAccessByte
    implements ArrayAccess {
        private ArrayAccessByte() {
        }

        public Object getValue(Object array, int index, boolean[] nullFlags) {
            if (nullFlags[index]) {
                return null;
            }
            return new Byte(Array.getByte(array, index));
        }
    }

    private static class ArrayAccessBoolean
    implements ArrayAccess {
        private ArrayAccessBoolean() {
        }

        public Object getValue(Object array, int index, boolean[] nullFlags) {
            if (nullFlags[index]) {
                return null;
            }
            return Array.getBoolean(array, index);
        }
    }
}

