/*
 * Decompiled with CFR 0.152.
 */
package de.simplicit.vjdbc.command;

import de.simplicit.vjdbc.command.Command;
import de.simplicit.vjdbc.command.ConnectionContext;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.sql.SQLException;
import java.sql.Statement;

public class StatementUpdateExtendedCommand
implements Command {
    private static final long serialVersionUID = 3690198762949851445L;
    private String _sql;
    private int _autoGeneratedKeys;
    private int[] _columnIndexes;
    private String[] _columnNames;

    public StatementUpdateExtendedCommand() {
    }

    public StatementUpdateExtendedCommand(String sql, int autoGeneratedKeys) {
        this._sql = sql;
        this._autoGeneratedKeys = autoGeneratedKeys;
    }

    public StatementUpdateExtendedCommand(String sql, int[] columnIndexes) {
        this._sql = sql;
        this._columnIndexes = columnIndexes;
    }

    public StatementUpdateExtendedCommand(String sql, String[] columnNames) {
        this._sql = sql;
        this._columnNames = columnNames;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this._sql);
        out.writeInt(this._autoGeneratedKeys);
        out.writeObject(this._columnIndexes);
        out.writeObject(this._columnNames);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this._sql = in.readUTF();
        this._autoGeneratedKeys = in.readInt();
        this._columnIndexes = (int[])in.readObject();
        this._columnNames = (String[])in.readObject();
    }

    public Object execute(Object target, ConnectionContext ctx) throws SQLException {
        String sql = ctx.resolveOrCheckQuery(this._sql);
        if (this._columnIndexes != null) {
            return new Integer(((Statement)target).executeUpdate(sql, this._columnIndexes));
        }
        if (this._columnNames != null) {
            return new Integer(((Statement)target).executeUpdate(sql, this._columnNames));
        }
        return new Integer(((Statement)target).executeUpdate(sql, this._autoGeneratedKeys));
    }

    public String toString() {
        return "StatementUpdateExtendedCommand: " + this._sql;
    }
}

