/*
 * Decompiled with CFR 0.152.
 */
package de.simplicit.vjdbc.command;

import de.simplicit.vjdbc.command.Command;
import de.simplicit.vjdbc.command.ConnectionContext;
import de.simplicit.vjdbc.command.ResultSetProducerCommand;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.sql.SQLException;
import java.sql.Statement;

public class StatementQueryCommand
implements Command,
ResultSetProducerCommand {
    static final long serialVersionUID = -8463588846424302034L;
    private int _resultSetType;
    private String _sql;

    public StatementQueryCommand() {
    }

    public StatementQueryCommand(String sql, int resultSetType) {
        this._sql = sql;
        this._resultSetType = resultSetType;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this._resultSetType);
        out.writeUTF(this._sql);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this._resultSetType = in.readInt();
        this._sql = in.readUTF();
    }

    public int getResultSetType() {
        return this._resultSetType;
    }

    public Object execute(Object target, ConnectionContext ctx) throws SQLException {
        return ((Statement)target).executeQuery(ctx.resolveOrCheckQuery(this._sql));
    }

    public String toString() {
        return "StatementQueryCommand: " + this._sql;
    }
}

