/*
 * Decompiled with CFR 0.152.
 */
package de.simplicit.vjdbc.command;

import de.simplicit.vjdbc.command.Command;
import de.simplicit.vjdbc.command.ConnectionContext;
import de.simplicit.vjdbc.command.ResultSetProducerCommand;
import de.simplicit.vjdbc.parameters.PreparedStatementParameter;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class PreparedStatementQueryCommand
implements Command,
ResultSetProducerCommand {
    static final long serialVersionUID = -7028150330288724130L;
    protected PreparedStatementParameter[] _params;
    protected int _resultSetType;

    public PreparedStatementQueryCommand() {
    }

    public PreparedStatementQueryCommand(PreparedStatementParameter[] params, int resultSetType) {
        this._params = params;
        this._resultSetType = resultSetType;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this._resultSetType);
        out.writeObject(this._params);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this._resultSetType = in.readInt();
        this._params = (PreparedStatementParameter[])in.readObject();
    }

    public int getResultSetType() {
        return this._resultSetType;
    }

    public Object execute(Object target, ConnectionContext ctx) throws SQLException {
        PreparedStatement pstmt = (PreparedStatement)target;
        for (int i = 0; i < this._params.length; ++i) {
            this._params[i].setParameter(pstmt, i + 1);
        }
        return pstmt.executeQuery();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("PreparedStatementQueryCommand");
        if (this._params != null && this._params.length > 0) {
            sb.append(" with parameters\n");
            int n = this._params.length;
            for (int i = 0; i < n; ++i) {
                sb.append("\t[").append(i + 1).append("] = ").append(this._params[i]);
                if (i >= n - 1) continue;
                sb.append("\n");
            }
        }
        return sb.toString();
    }
}

