/*
 * Decompiled with CFR 0.152.
 */
package de.simplicit.vjdbc.command;

import de.simplicit.vjdbc.command.Command;
import de.simplicit.vjdbc.command.ConnectionContext;
import de.simplicit.vjdbc.serial.SerializableTransport;
import de.simplicit.vjdbc.util.SQLExceptionHelper;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.sql.CallableStatement;
import java.sql.SQLException;

public class CallableStatementSetObjectCommand
implements Command {
    static final long serialVersionUID = -9132697894345849726L;
    private int _index;
    private String _paramName;
    private Integer _targetSqlType;
    private Integer _scale;
    private SerializableTransport _transport;

    public CallableStatementSetObjectCommand() {
    }

    public CallableStatementSetObjectCommand(int index, Integer targetSqlType, Integer scale) {
        this._index = index;
        this._targetSqlType = targetSqlType;
        this._scale = scale;
        this._transport = null;
    }

    public CallableStatementSetObjectCommand(String paramName, Integer targetSqlType, Integer scale) {
        this._paramName = paramName;
        this._targetSqlType = targetSqlType;
        this._scale = scale;
        this._transport = null;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this._index);
        out.writeObject(this._paramName);
        out.writeObject(this._targetSqlType);
        out.writeObject(this._scale);
        out.writeObject(this._transport);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this._index = in.readInt();
        this._paramName = (String)in.readObject();
        this._targetSqlType = (Integer)in.readObject();
        this._scale = (Integer)in.readObject();
        this._transport = (SerializableTransport)in.readObject();
    }

    public void setObject(Object obj) throws SQLException {
        if (!(obj instanceof Serializable)) {
            throw new SQLException("Object of type " + obj.getClass().getName() + " is not serializable");
        }
        this._transport = new SerializableTransport(obj);
    }

    public Object execute(Object target, ConnectionContext ctx) throws SQLException {
        Object obj;
        CallableStatement cstmt = (CallableStatement)target;
        try {
            obj = this._transport.getTransportee();
        }
        catch (Exception e) {
            throw SQLExceptionHelper.wrap(e);
        }
        if (this._paramName != null) {
            if (this._targetSqlType != null) {
                if (this._scale != null) {
                    cstmt.setObject(this._paramName, obj, (int)this._targetSqlType, (int)this._scale);
                } else {
                    cstmt.setObject(this._paramName, obj, (int)this._targetSqlType);
                }
            } else {
                cstmt.setObject(this._paramName, obj);
            }
        } else if (this._targetSqlType != null) {
            if (this._scale != null) {
                cstmt.setObject(this._index, obj, (int)this._targetSqlType, (int)this._scale);
            } else {
                cstmt.setObject(this._index, obj, (int)this._targetSqlType);
            }
        } else {
            cstmt.setObject(this._index, obj);
        }
        return null;
    }

    public String toString() {
        return "CallableStatementSetObjectCommand";
    }
}

