/*
 * Decompiled with CFR 0.152.
 */
package de.simplicit.vjdbc.command;

import de.simplicit.vjdbc.command.Command;
import de.simplicit.vjdbc.command.ConnectionContext;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.sql.CallableStatement;
import java.sql.NClob;
import java.sql.SQLException;

public class CallableStatementSetNClobCommand
implements Command {
    static final long serialVersionUID = 4264932633701227941L;
    private int _index;
    private String _parameterName;
    private NClob clob;

    public CallableStatementSetNClobCommand() {
    }

    public CallableStatementSetNClobCommand(int index, NClob clob) throws IOException {
        this._index = index;
        this.clob = clob;
    }

    public CallableStatementSetNClobCommand(String paramName, NClob clob) throws IOException {
        this._parameterName = paramName;
        this.clob = clob;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this._index);
        out.writeUTF(this._parameterName);
        out.writeObject(this.clob);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this._index = in.readInt();
        this._parameterName = in.readUTF();
        this.clob = (NClob)in.readObject();
    }

    public Object execute(Object target, ConnectionContext ctx) throws SQLException {
        CallableStatement cstmt = (CallableStatement)target;
        if (this._parameterName != null) {
            cstmt.setNClob(this._parameterName, this.clob);
        } else {
            cstmt.setNClob(this._index, this.clob);
        }
        return null;
    }

    public String toString() {
        return "CallableStatementSetNClobCommand";
    }
}

