/*
 * Decompiled with CFR 0.152.
 */
package de.simplicit.vjdbc.command;

import de.simplicit.vjdbc.command.Command;
import de.simplicit.vjdbc.command.ConnectionContext;
import de.simplicit.vjdbc.serial.StreamSerializer;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Reader;
import java.sql.CallableStatement;
import java.sql.SQLException;

public class CallableStatementSetCharacterStreamCommand
implements Command {
    static final long serialVersionUID = 8952810867158345906L;
    private int _index;
    private int _length;
    private String _parameterName;
    private char[] _charArray;

    public CallableStatementSetCharacterStreamCommand() {
    }

    public CallableStatementSetCharacterStreamCommand(int index, Reader reader) throws IOException {
        this._index = index;
        this._charArray = StreamSerializer.toCharArray(reader);
        this._length = this._charArray.length;
    }

    public CallableStatementSetCharacterStreamCommand(String paramName, Reader reader) throws IOException {
        this._parameterName = paramName;
        this._charArray = StreamSerializer.toCharArray(reader);
        this._length = this._charArray.length;
    }

    public CallableStatementSetCharacterStreamCommand(int index, Reader reader, int len) throws IOException {
        this._index = index;
        this._length = len;
        this._charArray = StreamSerializer.toCharArray(reader, len);
    }

    public CallableStatementSetCharacterStreamCommand(String paramName, Reader reader, int len) throws IOException {
        this._parameterName = paramName;
        this._length = len;
        this._charArray = StreamSerializer.toCharArray(reader, len);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this._index);
        out.writeInt(this._length);
        out.writeObject(this._parameterName);
        out.writeObject(this._charArray);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this._index = in.readInt();
        this._length = in.readInt();
        this._parameterName = (String)in.readObject();
        this._charArray = (char[])in.readObject();
    }

    public Object execute(Object target, ConnectionContext ctx) throws SQLException {
        CallableStatement cstmt = (CallableStatement)target;
        Reader reader = StreamSerializer.toReader(this._charArray);
        if (this._parameterName != null) {
            cstmt.setCharacterStream(this._parameterName, reader, this._length);
        } else {
            cstmt.setCharacterStream(this._index, reader, this._length);
        }
        return null;
    }

    public String toString() {
        return "CallableStatementSetCharacterStreamCommand";
    }
}

