/*
 * Decompiled with CFR 0.152.
 */
package de.simplicit.vjdbc.command;

import de.simplicit.vjdbc.command.Command;
import de.simplicit.vjdbc.command.ConnectionContext;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.SQLException;

public class CallableStatementSetBlobCommand
implements Command {
    static final long serialVersionUID = 4264932633701227941L;
    private int _index;
    private String _parameterName;
    private Blob clob;

    public CallableStatementSetBlobCommand() {
    }

    public CallableStatementSetBlobCommand(int index, Blob clob) throws IOException {
        this._index = index;
        this.clob = clob;
    }

    public CallableStatementSetBlobCommand(String paramName, Blob clob) throws IOException {
        this._parameterName = paramName;
        this.clob = clob;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this._index);
        out.writeUTF(this._parameterName);
        out.writeObject(this.clob);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this._index = in.readInt();
        this._parameterName = in.readUTF();
        this.clob = (Blob)in.readObject();
    }

    public Object execute(Object target, ConnectionContext ctx) throws SQLException {
        CallableStatement cstmt = (CallableStatement)target;
        if (this._parameterName != null) {
            cstmt.setBlob(this._parameterName, this.clob);
        } else {
            cstmt.setBlob(this._index, this.clob);
        }
        return null;
    }

    public String toString() {
        return "CallableStatementSetBlobCommand";
    }
}

