/*
 * Decompiled with CFR 0.152.
 */
package de.simplicit.vjdbc;

import de.simplicit.vjdbc.VirtualBase;
import de.simplicit.vjdbc.command.CommandPool;
import de.simplicit.vjdbc.command.DecoratedCommandSink;
import de.simplicit.vjdbc.command.DestroyCommand;
import de.simplicit.vjdbc.command.StatementCancelCommand;
import de.simplicit.vjdbc.command.StatementExecuteBatchCommand;
import de.simplicit.vjdbc.command.StatementExecuteCommand;
import de.simplicit.vjdbc.command.StatementExecuteExtendedCommand;
import de.simplicit.vjdbc.command.StatementGetGeneratedKeysCommand;
import de.simplicit.vjdbc.command.StatementGetResultSetCommand;
import de.simplicit.vjdbc.command.StatementQueryCommand;
import de.simplicit.vjdbc.command.StatementUpdateCommand;
import de.simplicit.vjdbc.command.StatementUpdateExtendedCommand;
import de.simplicit.vjdbc.serial.SerializableTransport;
import de.simplicit.vjdbc.serial.StreamingResultSet;
import de.simplicit.vjdbc.serial.UIDEx;
import de.simplicit.vjdbc.util.SQLExceptionHelper;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VirtualStatement
extends VirtualBase
implements Statement {
    protected Connection _connection;
    protected List _batchCollector = new ArrayList();
    protected int _maxRows = -1;
    protected int _queryTimeout = -1;
    protected StreamingResultSet _currentResultSet;
    protected int _resultSetType;
    protected boolean _isClosed = false;
    protected boolean _isCloseOnCompletion = false;

    public VirtualStatement(UIDEx reg, Connection connection, DecoratedCommandSink theSink, int resultSetType) {
        super(reg, theSink);
        this._connection = connection;
        this._resultSetType = resultSetType;
        if (reg.getValue1() != Integer.MIN_VALUE) {
            this._queryTimeout = reg.getValue1();
        }
        if (reg.getValue2() != Integer.MIN_VALUE) {
            this._maxRows = reg.getValue2();
        }
        reg.resetValues();
    }

    @Override
    protected void finalize() throws Throwable {
        if (!this._isClosed) {
            this.close();
        }
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        try {
            SerializableTransport st = (SerializableTransport)this._sink.process(this._objectUid, new StatementQueryCommand(sql, this._resultSetType), true);
            StreamingResultSet srs = (StreamingResultSet)st.getTransportee();
            srs.setStatement(this);
            srs.setCommandSink(this._sink);
            this._currentResultSet = srs;
            return srs;
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw SQLExceptionHelper.wrap(e);
        }
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        return this._sink.processWithIntResult(this._objectUid, new StatementUpdateCommand(sql));
    }

    @Override
    public void close() throws SQLException {
        this._sink.process(this._objectUid, new DestroyCommand(this._objectUid, 6));
        this._isClosed = true;
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return this._sink.processWithIntResult(this._objectUid, CommandPool.getReflectiveCommand(6, "getMaxFieldSize"));
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        this._sink.process(this._objectUid, CommandPool.getReflectiveCommand(6, "setMaxFieldSize", new Object[]{new Integer(max)}, 2));
    }

    @Override
    public int getMaxRows() throws SQLException {
        if (this._maxRows < 0) {
            int result;
            this._maxRows = result = this._sink.processWithIntResult(this._objectUid, CommandPool.getReflectiveCommand(6, "getMaxRows"));
        }
        return this._maxRows;
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this._sink.process(this._objectUid, CommandPool.getReflectiveCommand(6, "setMaxRows", new Object[]{new Integer(max)}, 2));
        this._maxRows = max;
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this._sink.process(this._objectUid, CommandPool.getReflectiveCommand(6, "setEscapeProcessing", new Object[]{enable ? Boolean.TRUE : Boolean.FALSE}, 1));
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        if (this._queryTimeout < 0) {
            int result;
            this._queryTimeout = result = this._sink.processWithIntResult(this._objectUid, CommandPool.getReflectiveCommand(6, "getQueryTimeout"));
        }
        return this._queryTimeout;
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this._sink.process(this._objectUid, CommandPool.getReflectiveCommand(6, "setQueryTimeout", new Object[]{new Integer(seconds)}, 2));
        this._queryTimeout = seconds;
    }

    @Override
    public void cancel() throws SQLException {
        this._sink.process(this._objectUid, new StatementCancelCommand());
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return (SQLWarning)this._sink.process(this._objectUid, CommandPool.getReflectiveCommand(6, "getWarnings"));
    }

    @Override
    public void clearWarnings() throws SQLException {
        this._sink.process(this._objectUid, CommandPool.getReflectiveCommand(6, "clearWarnings"));
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        this._sink.process(this._objectUid, CommandPool.getReflectiveCommand(6, "setCursorName", new Object[]{name}, 3));
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        this._currentResultSet = null;
        return this._sink.processWithBooleanResult(this._objectUid, new StatementExecuteCommand(sql));
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        if (this._currentResultSet == null) {
            try {
                SerializableTransport st = (SerializableTransport)this._sink.process(this._objectUid, new StatementGetResultSetCommand(), true);
                this._currentResultSet = (StreamingResultSet)st.getTransportee();
                this._currentResultSet.setStatement(this);
                this._currentResultSet.setCommandSink(this._sink);
            }
            catch (Exception e) {
                throw SQLExceptionHelper.wrap(e);
            }
        }
        return this._currentResultSet;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return this._sink.processWithIntResult(this._objectUid, CommandPool.getReflectiveCommand(6, "getUpdateCount"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getMoreResults() throws SQLException {
        try {
            boolean bl = this._sink.processWithBooleanResult(this._objectUid, CommandPool.getReflectiveCommand(6, "getMoreResults"));
            return bl;
        }
        finally {
            this._currentResultSet = null;
        }
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this._sink.process(this._objectUid, CommandPool.getReflectiveCommand(6, "setFetchDirection", new Object[]{new Integer(direction)}, 2));
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return this._sink.processWithIntResult(this._objectUid, CommandPool.getReflectiveCommand(6, "getFetchDirection"));
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this._sink.process(this._objectUid, CommandPool.getReflectiveCommand(6, "setFetchSize", new Object[]{new Integer(rows)}, 2));
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this._sink.processWithIntResult(this._objectUid, CommandPool.getReflectiveCommand(6, "getFetchSize"));
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return this._sink.processWithIntResult(this._objectUid, CommandPool.getReflectiveCommand(6, "getResultSetConcurrency"));
    }

    @Override
    public int getResultSetType() throws SQLException {
        return this._sink.processWithIntResult(this._objectUid, CommandPool.getReflectiveCommand(6, "getResultSetType"));
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this._batchCollector.add(sql);
    }

    @Override
    public void clearBatch() throws SQLException {
        this._batchCollector.clear();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        String[] sql = this._batchCollector.toArray(new String[this._batchCollector.size()]);
        int[] result = (int[])this._sink.process(this._objectUid, new StatementExecuteBatchCommand(sql));
        this._batchCollector.clear();
        return result;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this._connection;
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        return this._sink.processWithBooleanResult(this._objectUid, CommandPool.getReflectiveCommand(6, "getMoreResults", new Object[]{new Integer(current)}, 2));
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        try {
            SerializableTransport st = (SerializableTransport)this._sink.process(this._objectUid, new StatementGetGeneratedKeysCommand(), true);
            StreamingResultSet srs = (StreamingResultSet)st.getTransportee();
            srs.setStatement(this);
            srs.setCommandSink(this._sink);
            return srs;
        }
        catch (Exception e) {
            throw SQLExceptionHelper.wrap(e);
        }
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        return this._sink.processWithIntResult(this._objectUid, new StatementUpdateExtendedCommand(sql, autoGeneratedKeys));
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return this._sink.processWithIntResult(this._objectUid, new StatementUpdateExtendedCommand(sql, columnIndexes));
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        return this._sink.processWithIntResult(this._objectUid, new StatementUpdateExtendedCommand(sql, columnNames));
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        return this._sink.processWithBooleanResult(this._objectUid, new StatementExecuteExtendedCommand(sql, autoGeneratedKeys));
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        return this._sink.processWithBooleanResult(this._objectUid, new StatementExecuteExtendedCommand(sql, columnIndexes));
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        return this._sink.processWithBooleanResult(this._objectUid, new StatementExecuteExtendedCommand(sql, columnNames));
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return this._sink.processWithIntResult(this._objectUid, CommandPool.getReflectiveCommand(6, "getResultSetHoldability"));
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this._isClosed;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        this._sink.process(this._objectUid, CommandPool.getReflectiveCommand(6, "setPoolable", new Object[]{poolable ? Boolean.TRUE : Boolean.FALSE}, 1));
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return this._sink.processWithBooleanResult(this._objectUid, CommandPool.getReflectiveCommand(6, "isPoolable"));
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isAssignableFrom(VirtualStatement.class);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return (T)this;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        this._isCloseOnCompletion = true;
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return this._isCloseOnCompletion;
    }
}

