/*
 * Decompiled with CFR 0.152.
 */
package de.simplicit.vjdbc;

import de.simplicit.vjdbc.VirtualStatement;
import de.simplicit.vjdbc.command.CommandPool;
import de.simplicit.vjdbc.command.DecoratedCommandSink;
import de.simplicit.vjdbc.command.PreparedStatementExecuteBatchCommand;
import de.simplicit.vjdbc.command.PreparedStatementExecuteCommand;
import de.simplicit.vjdbc.command.PreparedStatementQueryCommand;
import de.simplicit.vjdbc.command.PreparedStatementUpdateCommand;
import de.simplicit.vjdbc.parameters.ArrayParameter;
import de.simplicit.vjdbc.parameters.BigDecimalParameter;
import de.simplicit.vjdbc.parameters.BlobParameter;
import de.simplicit.vjdbc.parameters.BooleanParameter;
import de.simplicit.vjdbc.parameters.ByteArrayParameter;
import de.simplicit.vjdbc.parameters.ByteParameter;
import de.simplicit.vjdbc.parameters.ByteStreamParameter;
import de.simplicit.vjdbc.parameters.CharStreamParameter;
import de.simplicit.vjdbc.parameters.ClobParameter;
import de.simplicit.vjdbc.parameters.DateParameter;
import de.simplicit.vjdbc.parameters.DoubleParameter;
import de.simplicit.vjdbc.parameters.FloatParameter;
import de.simplicit.vjdbc.parameters.IntegerParameter;
import de.simplicit.vjdbc.parameters.LongParameter;
import de.simplicit.vjdbc.parameters.NullParameter;
import de.simplicit.vjdbc.parameters.ObjectParameter;
import de.simplicit.vjdbc.parameters.PreparedStatementParameter;
import de.simplicit.vjdbc.parameters.RefParameter;
import de.simplicit.vjdbc.parameters.RowIdParameter;
import de.simplicit.vjdbc.parameters.SQLXMLParameter;
import de.simplicit.vjdbc.parameters.ShortParameter;
import de.simplicit.vjdbc.parameters.StringParameter;
import de.simplicit.vjdbc.parameters.TimeParameter;
import de.simplicit.vjdbc.parameters.TimestampParameter;
import de.simplicit.vjdbc.parameters.URLParameter;
import de.simplicit.vjdbc.serial.SerialBlob;
import de.simplicit.vjdbc.serial.SerialClob;
import de.simplicit.vjdbc.serial.SerialNClob;
import de.simplicit.vjdbc.serial.SerialResultSetMetaData;
import de.simplicit.vjdbc.serial.SerialSQLXML;
import de.simplicit.vjdbc.serial.SerializableTransport;
import de.simplicit.vjdbc.serial.StreamingResultSet;
import de.simplicit.vjdbc.serial.UIDEx;
import de.simplicit.vjdbc.util.SQLExceptionHelper;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;

public class VirtualPreparedStatement
extends VirtualStatement
implements PreparedStatement {
    private static PreparedStatementParameter[] _emptyParameters = new PreparedStatementParameter[0];
    protected PreparedStatementParameter[] _paramList = new PreparedStatementParameter[10];
    protected int _maxIndex = 0;

    public VirtualPreparedStatement(UIDEx reg, Connection connection, String sql, DecoratedCommandSink sink, int resultSetType) {
        super(reg, connection, sink, resultSetType);
    }

    public ResultSet executeQuery() throws SQLException {
        StreamingResultSet result = null;
        try {
            this.reduceParam();
            SerializableTransport st = (SerializableTransport)this._sink.process(this._objectUid, new PreparedStatementQueryCommand(this._paramList, this._resultSetType), true);
            result = (StreamingResultSet)st.getTransportee();
            result.setStatement(this);
            result.setCommandSink(this._sink);
        }
        catch (Exception e) {
            throw SQLExceptionHelper.wrap(e);
        }
        return result;
    }

    public int executeUpdate() throws SQLException {
        this.reduceParam();
        return this._sink.processWithIntResult(this._objectUid, new PreparedStatementUpdateCommand(this._paramList));
    }

    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.setParam(parameterIndex, new NullParameter(sqlType, null));
    }

    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.setParam(parameterIndex, new BooleanParameter(x));
    }

    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.setParam(parameterIndex, new ByteParameter(x));
    }

    public void setShort(int parameterIndex, short x) throws SQLException {
        this.setParam(parameterIndex, new ShortParameter(x));
    }

    public void setInt(int parameterIndex, int x) throws SQLException {
        this.setParam(parameterIndex, new IntegerParameter(x));
    }

    public void setLong(int parameterIndex, long x) throws SQLException {
        this.setParam(parameterIndex, new LongParameter(x));
    }

    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.setParam(parameterIndex, new FloatParameter(x));
    }

    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.setParam(parameterIndex, new DoubleParameter(x));
    }

    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.setParam(parameterIndex, new BigDecimalParameter(x));
    }

    public void setString(int parameterIndex, String x) throws SQLException {
        this.setParam(parameterIndex, new StringParameter(x));
    }

    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.setParam(parameterIndex, new ByteArrayParameter(x));
    }

    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.setParam(parameterIndex, new DateParameter(x, null));
    }

    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.setParam(parameterIndex, new TimeParameter(x, null));
    }

    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.setParam(parameterIndex, new TimestampParameter(x, null));
    }

    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.setParam(parameterIndex, new ByteStreamParameter(1, x, length));
    }

    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.setParam(parameterIndex, new ByteStreamParameter(2, x, length));
    }

    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.setParam(parameterIndex, new ByteStreamParameter(3, x, length));
    }

    public void clearParameters() throws SQLException {
        for (int i = 0; i < this._paramList.length; ++i) {
            this._paramList[i] = null;
        }
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType, int scale) throws SQLException {
        this.setParam(parameterIndex, new ObjectParameter(x, new Integer(targetSqlType), new Integer(scale)));
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.setParam(parameterIndex, new ObjectParameter(x, new Integer(targetSqlType), null));
    }

    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.setParam(parameterIndex, new ObjectParameter(x, null, null));
    }

    public boolean execute() throws SQLException {
        this.reduceParam();
        return this._sink.processWithBooleanResult(this._objectUid, new PreparedStatementExecuteCommand(this._paramList));
    }

    public void addBatch() throws SQLException {
        this.reduceParam();
        PreparedStatementParameter[] paramListClone = new PreparedStatementParameter[this._paramList.length];
        System.arraycopy(this._paramList, 0, paramListClone, 0, this._paramList.length);
        this._batchCollector.add(paramListClone);
        this.clearParameters();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] executeBatch() throws SQLException {
        try {
            int[] nArray = (int[])this._sink.process(this._objectUid, new PreparedStatementExecuteBatchCommand(this._batchCollector));
            return nArray;
        }
        finally {
            this._batchCollector.clear();
        }
    }

    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this.setParam(parameterIndex, new CharStreamParameter(reader, length));
    }

    public void setRef(int i, Ref x) throws SQLException {
        this.setParam(i, new RefParameter(x));
    }

    public void setBlob(int i, Blob x) throws SQLException {
        this.setParam(i, new BlobParameter(x));
    }

    public void setClob(int i, Clob x) throws SQLException {
        this.setParam(i, new ClobParameter(x));
    }

    public void setArray(int i, Array x) throws SQLException {
        this.setParam(i, new ArrayParameter(x));
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        try {
            SerializableTransport st = (SerializableTransport)this._sink.process(this._objectUid, CommandPool.getReflectiveCommand(4, "getMetaData"));
            return (SerialResultSetMetaData)st.getTransportee();
        }
        catch (Exception e) {
            throw SQLExceptionHelper.wrap(e);
        }
    }

    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        this.setParam(parameterIndex, new DateParameter(x, cal));
    }

    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        this.setParam(parameterIndex, new TimeParameter(x, cal));
    }

    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.setParam(parameterIndex, new TimestampParameter(x, cal));
    }

    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.setParam(parameterIndex, new NullParameter(sqlType, typeName));
    }

    public void setURL(int parameterIndex, URL x) throws SQLException {
        this.setParam(parameterIndex, new URLParameter(x));
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        throw new UnsupportedOperationException("getParameterMetaData");
    }

    protected void setParam(int index, PreparedStatementParameter parm) {
        if (this._paramList.length < index) {
            List<PreparedStatementParameter> tmp = Arrays.asList(this._paramList);
            PreparedStatementParameter[] newArray = new PreparedStatementParameter[index * 2];
            this._paramList = tmp.toArray(newArray);
        }
        if (this._maxIndex < index) {
            this._maxIndex = index;
        }
        this._paramList[index - 1] = parm;
    }

    protected void reduceParam() {
        if (this._maxIndex > 0) {
            PreparedStatementParameter[] tmpArray = new PreparedStatementParameter[this._maxIndex];
            System.arraycopy(this._paramList, 0, tmpArray, 0, this._maxIndex);
            this._paramList = tmpArray;
        } else {
            this._paramList = _emptyParameters;
        }
    }

    public void setRowId(int parameterIndex, RowId rowId) throws SQLException {
        this.setParam(parameterIndex, new RowIdParameter(rowId));
    }

    public void setNString(int parameterIndex, String value) throws SQLException {
        this.setParam(parameterIndex, new StringParameter(value));
    }

    public void setNCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this.setParam(parameterIndex, new CharStreamParameter(reader, length));
    }

    public void setNClob(int i, NClob x) throws SQLException {
        this.setParam(i, new ClobParameter(x));
    }

    public void setClob(int i, Reader reader, long length) throws SQLException {
        this.setParam(i, new ClobParameter(new SerialClob(reader, length)));
    }

    public void setBlob(int i, InputStream inputStream, long length) throws SQLException {
        this.setParam(i, new BlobParameter(new SerialBlob(inputStream, length)));
    }

    public void setNClob(int i, Reader reader, long length) throws SQLException {
        this.setParam(i, new ClobParameter(new SerialNClob(reader, length)));
    }

    public void setSQLXML(int i, SQLXML xmlObject) throws SQLException {
        this.setParam(i, new SQLXMLParameter(new SerialSQLXML(xmlObject)));
    }

    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        this.setAsciiStream(parameterIndex, x, -1);
    }

    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.setParam(parameterIndex, new ByteStreamParameter(1, x, length));
    }

    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        this.setBinaryStream(parameterIndex, x, -1);
    }

    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.setParam(parameterIndex, new ByteStreamParameter(3, x, length));
    }

    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        this.setParam(parameterIndex, new CharStreamParameter(reader));
    }

    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        this.setParam(parameterIndex, new CharStreamParameter(reader, length));
    }

    public void setNCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        this.setParam(parameterIndex, new CharStreamParameter(reader));
    }

    public void setNCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        this.setParam(parameterIndex, new CharStreamParameter(reader, length));
    }

    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        this.setParam(parameterIndex, new ClobParameter(new SerialClob(reader)));
    }

    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        this.setParam(parameterIndex, new BlobParameter(new SerialBlob(inputStream)));
    }

    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        this.setParam(parameterIndex, new ClobParameter(new SerialNClob(reader)));
    }
}

