package datamaxoneil.printer.configuration;

/**
 * This class handles the data from an {VR?} query as well as
 * accessors to read the data values.
 * <p>
 * This class supports the following possible parameters:
 * <table border=1>
 *    <tr><th>Parameter</th><th>Description</th></tr>
 *    <tr><td>B</td><td>Boot Version</td></tr>
 *    <tr><td>C</td><td>Comm Controller Version</td></tr>
 *    <tr><td>D</td><td>Download Version</td></tr>
 *    <tr><td>F</td><td>Firmware Version</td></tr>
 *    <tr><td>H</td><td>Hardware Controller Version</td></tr>
 *    <tr><td>S1-SCR</td><td>SCR Version</td></tr>
 *    <tr><td>T</td><td>Build Timestamp</td></tr>
 * </table>
 * @author Datamax-O'Neil
 * @version 2.0.1 (05 Sept 2013)
 */
public class VersionInformation extends PrinterState {

	/**
	 * The default constructor will initialize the class with default values.
	 * <p>
	 * Initially all of the _IsValid parameters will be false because no data has been processed.  To 'populate' the values, the object must invoke <see cref="PrinterState.Update(ONeil.Connection.ConnectionBase, int)">Update</see> with the query response string.
	 */
	public VersionInformation() {

		// Set Query Values
		m_QueryDescription = "Version Information";
		m_Query = "{VR?}";
		m_QueryResponseHeader = "{VR!";

		// Add names
		addName("B", "Boot Version");
		addName("C", "Comm Controller Version");
		addName("D", "Download Version");
		addName("F", "Firmware Version");
		addName("H", "Hardware Controller Version");
		addName("S1-SCR", "SCR Version");
		addName("T", "Build Timestamp");

		return;
	}
	/**
	 * Indicates if getBootVersion() parameter is present.
	 * <p>
	 * This function is useful to determine if the given parameter is supported on the current printer.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned by the parameter getBootVersion() may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see VersionInformation#getBootVersion()
	 * @return If the parameter is present and valid true, false otherwise.
	 */
	public boolean getBootVersion_IsPresent() {
		return containsData("B") && isString("B");
	}

	/**
	 * Boot Version
	 * <p>
	 * The return value for this parameter is only valid if getBootVersion_IsPresent() returns true.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see VersionInformation#getBootVersion_IsPresent()
	 * @return The current value for the parameter.
	 */
	public String getBootVersion() {
		return parse_string("B");
	}

	/**
	 * Indicates if getCommControllerVersion() parameter is present.
	 * <p>
	 * This function is useful to determine if the given parameter is supported on the current printer.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned by the parameter getCommControllerVersion() may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see VersionInformation#getCommControllerVersion()
	 * @return If the parameter is present and valid true, false otherwise.
	 */
	public boolean getCommControllerVersion_IsPresent() {
		return containsData("C") && isString("C");
	}

	/**
	 * Comm Controller Version
	 * <p>
	 * The return value for this parameter is only valid if getCommControllerVersion_IsPresent() returns true.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see VersionInformation#getCommControllerVersion_IsPresent()
	 * @return The current value for the parameter.
	 */
	public String getCommControllerVersion() {
		return parse_string("C");
	}

	/**
	 * Indicates if getDownloadVersion() parameter is present.
	 * <p>
	 * This function is useful to determine if the given parameter is supported on the current printer.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned by the parameter getDownloadVersion() may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see VersionInformation#getDownloadVersion()
	 * @return If the parameter is present and valid true, false otherwise.
	 */
	public boolean getDownloadVersion_IsPresent() {
		return containsData("D") && isString("D");
	}

	/**
	 * Download Version
	 * <p>
	 * The return value for this parameter is only valid if getDownloadVersion_IsPresent() returns true.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see VersionInformation#getDownloadVersion_IsPresent()
	 * @return The current value for the parameter.
	 */
	public String getDownloadVersion() {
		return parse_string("D");
	}

	/**
	 * Indicates if getFirmwareVersion() parameter is present.
	 * <p>
	 * This function is useful to determine if the given parameter is supported on the current printer.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned by the parameter getFirmwareVersion() may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see VersionInformation#getFirmwareVersion()
	 * @return If the parameter is present and valid true, false otherwise.
	 */
	public boolean getFirmwareVersion_IsPresent() {
		return containsData("F") && isString("F");
	}

	/**
	 * Firmware Version
	 * <p>
	 * The return value for this parameter is only valid if getFirmwareVersion_IsPresent() returns true.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see VersionInformation#getFirmwareVersion_IsPresent()
	 * @return The current value for the parameter.
	 */
	public String getFirmwareVersion() {
		return parse_string("F");
	}

	/**
	 * Indicates if getHardwareControllerVersion() parameter is present.
	 * <p>
	 * This function is useful to determine if the given parameter is supported on the current printer.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned by the parameter getHardwareControllerVersion() may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see VersionInformation#getHardwareControllerVersion()
	 * @return If the parameter is present and valid true, false otherwise.
	 */
	public boolean getHardwareControllerVersion_IsPresent() {
		return containsData("H") && isString("H");
	}

	/**
	 * Hardware Controller Version
	 * <p>
	 * The return value for this parameter is only valid if getHardwareControllerVersion_IsPresent() returns true.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see VersionInformation#getHardwareControllerVersion_IsPresent()
	 * @return The current value for the parameter.
	 */
	public String getHardwareControllerVersion() {
		return parse_string("H");
	}

	/**
	 * Indicates if getSCRVersion() parameter is present.
	 * <p>
	 * This function is useful to determine if the given parameter is supported on the current printer.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned by the parameter getSCRVersion() may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see VersionInformation#getSCRVersion()
	 * @return If the parameter is present and valid true, false otherwise.
	 */
	public boolean getSCRVersion_IsPresent() {
		return containsData("S1-SCR") && isString("S1-SCR");
	}

	/**
	 * SCR Version
	 * <p>
	 * The return value for this parameter is only valid if getSCRVersion_IsPresent() returns true.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see VersionInformation#getSCRVersion_IsPresent()
	 * @return The current value for the parameter.
	 */
	public String getSCRVersion() {
		return parse_string("S1-SCR");
	}

	/**
	 * Indicates if getBuildTimestamp() parameter is present.
	 * <p>
	 * This function is useful to determine if the given parameter is supported on the current printer.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned by the parameter getBuildTimestamp() may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see VersionInformation#getBuildTimestamp()
	 * @return If the parameter is present and valid true, false otherwise.
	 */
	public boolean getBuildTimestamp_IsPresent() {
		return containsData("T") && isString("T");
	}

	/**
	 * Build Timestamp
	 * <p>
	 * The return value for this parameter is only valid if getBuildTimestamp_IsPresent() returns true.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see VersionInformation#getBuildTimestamp_IsPresent()
	 * @return The current value for the parameter.
	 */
	public String getBuildTimestamp() {
		return parse_string("T");
	}

}
