package datamaxoneil.printer.configuration;

/**
 * This class handles the data from an {CU?} query as well as
 * accessors to read the data values.
 * <p>
 * This class supports the following possible parameters:
 * <table border=1>
 *    <tr><th>Parameter</th><th>Description</th></tr>
 *    <tr><td>F</td><td>Path and File</td></tr>
 *    <tr><td>I</td><td>Server IP Address</td></tr>
 *    <tr><td>P</td><td>Server Port</td></tr>
 *    <tr><td>T</td><td>Data Type</td></tr>
 *    <tr><td>V</td><td>Description string form the latest upgrade package.</td></tr>
 * </table>
 * @author Datamax-O'Neil
 * @version 2.0.1 (05 Sept 2013)
 */
public class UpgradeData extends PrinterState {

	/**
	 * The default constructor will initialize the class with default values.
	 * <p>
	 * Initially all of the _IsValid parameters will be false because no data has been processed.  To 'populate' the values, the object must invoke <see cref="PrinterState.Update(ONeil.Connection.ConnectionBase, int)">Update</see> with the query response string.
	 */
	public UpgradeData() {

		// Set Query Values
		m_QueryDescription = "Upgrade Data";
		m_Query = "{CU?}";
		m_QueryResponseHeader = "{CU!";

		// Add names
		addName("F", "Path and File");
		addName("I", "Server IP Address");
		addName("P", "Server Port");
		addName("T", "Data Type");
		addName("V", "Upgrade Package Version");

		return;
	}
	/**
	 * Indicates if getPathAndFile() parameter is present.
	 * <p>
	 * This function is useful to determine if the given parameter is supported on the current printer.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned by the parameter getPathAndFile() may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see UpgradeData#getPathAndFile()
	 * @return If the parameter is present and valid true, false otherwise.
	 */
	public boolean getPathAndFile_IsPresent() {
		return containsData("F") && isString("F");
	}

	/**
	 * Path and File
	 * <p>
	 * The return value for this parameter is only valid if getPathAndFile_IsPresent() returns true.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see UpgradeData#getPathAndFile_IsPresent()
	 * @return The current value for the parameter.
	 */
	public String getPathAndFile() {
		return parse_string("F");
	}

	/**
	 * Indicates if getServerIPAddress() parameter is present.
	 * <p>
	 * This function is useful to determine if the given parameter is supported on the current printer.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned by the parameter getServerIPAddress() may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see UpgradeData#getServerIPAddress()
	 * @return If the parameter is present and valid true, false otherwise.
	 */
	public boolean getServerIPAddress_IsPresent() {
		return containsData("I") && isString("I");
	}

	/**
	 * Server IP Address
	 * <p>
	 * The return value for this parameter is only valid if getServerIPAddress_IsPresent() returns true.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see UpgradeData#getServerIPAddress_IsPresent()
	 * @return The current value for the parameter.
	 */
	public String getServerIPAddress() {
		return parse_string("I");
	}

	/**
	 * Indicates if getServerPort() parameter is present.
	 * <p>
	 * This function is useful to determine if the given parameter is supported on the current printer.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned by the parameter getServerPort() may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see UpgradeData#getServerPort()
	 * @return If the parameter is present and valid true, false otherwise.
	 */
	public boolean getServerPort_IsPresent() {
		return containsData("P") && isInteger("P");
	}

	/**
	 * Server Port
	 * <p>
	 * The return value for this parameter is only valid if getServerPort_IsPresent() returns true.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see UpgradeData#getServerPort_IsPresent()
	 * @return The current value for the parameter.
	 */
	public long getServerPort() {
		return parse_long("P");
	}

	/**
	 * Indicates if getDataType() parameter is present.
	 * <p>
	 * This function is useful to determine if the given parameter is supported on the current printer.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned by the parameter getDataType() may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see UpgradeData#getDataType()
	 * @return If the parameter is present and valid true, false otherwise.
	 */
	public boolean getDataType_IsPresent() {
		return containsData("T") && isInteger("T");
	}

	/**
	 * Data Type
	 * <p>
	 * The return value for this parameter is only valid if getDataType_IsPresent() returns true.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see UpgradeData#getDataType_IsPresent()
	 * @return The current value for the parameter.
	 */
	public long getDataType() {
		return parse_long("T");
	}

	/**
	 * Indicates if getVersion() parameter is present.
	 * <p>
	 * This function is useful to determine if the given parameter is supported on the current printer.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned by the parameter getVersion() may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see UpgradeData#getVersion()
	 * @return If the parameter is present and valid true, false otherwise.
	 */
	public boolean getVersion_IsPresent() {
		return containsData("V") && isString("V");
	}

	/**
	 * Description string form the latest upgrade package.
	 * <p>
	 * The return value for this parameter is only valid if getVersion_IsPresent() returns true.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see UpgradeData#getVersion_IsPresent()
	 * @return The current value for the parameter.
	 */
	public String getVersion() {
		return parse_string("V");
	}

}
