package datamaxoneil.printer.configuration;

/**
 * This class handles the data from an {SC?} query as well as
 * accessors to read the data values.
 * <p>
 * This class supports the following possible parameters:
 * <table border=1>
 *    <tr><th>Parameter</th><th>Description</th></tr>
 *    <tr><td>C</td><td>Command Format</td></tr>
 *    <tr><td>EN</td><td>Enabled</td></tr>
 *    <tr><td>MT</td><td>Memory Type</td></tr>
 *    <tr><td>R</td><td>Response Format</td></tr>
 *    <tr><td>SP</td><td>Smart Card Protocol</td></tr>
 *    <tr><td>ST</td><td>Smart Card Type</td></tr>
 * </table>
 * @author Datamax-O'Neil
 * @version 2.0.1 (05 Sept 2013)
 */
public class SmartCardConfiguration extends PrinterState {

	/**
	 * The default constructor will initialize the class with default values.
	 * <p>
	 * Initially all of the _IsValid parameters will be false because no data has been processed.  To 'populate' the values, the object must invoke <see cref="PrinterState.Update(ONeil.Connection.ConnectionBase, int)">Update</see> with the query response string.
	 */
	public SmartCardConfiguration() {

		// Set Query Values
		m_QueryDescription = "Smart Card Configuration";
		m_Query = "{SC?}";
		m_QueryResponseHeader = "{SC!";

		// Add names
		addName("C", "Command Format");
		addName("EN", "Enabled");
		addName("MT", "Memory Type");
		addName("R", "Response Format");
		addName("SP", "Protocol");
		addName("ST", "Type");

		return;
	}
	/**
	 * Indicates if getCommandFormat() parameter is present.
	 * <p>
	 * This function is useful to determine if the given parameter is supported on the current printer.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned by the parameter getCommandFormat() may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see SmartCardConfiguration#getCommandFormat()
	 * @return If the parameter is present and valid true, false otherwise.
	 */
	public boolean getCommandFormat_IsPresent() {
		return containsData("C") && isString("C");
	}

	/**
	 * Command Format
	 * <p>
	 * The return value for this parameter is only valid if getCommandFormat_IsPresent() returns true.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see SmartCardConfiguration#getCommandFormat_IsPresent()
	 * @return The current value for the parameter.
	 */
	public String getCommandFormat() {
		return parse_string("C");
	}

	/**
	 * Indicates if getEnabled() parameter is present.
	 * <p>
	 * This function is useful to determine if the given parameter is supported on the current printer.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned by the parameter getEnabled() may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see SmartCardConfiguration#getEnabled()
	 * @return If the parameter is present and valid true, false otherwise.
	 */
	public boolean getEnabled_IsPresent() {
		return containsData("EN") && isString("EN");
	}

	/**
	 * Enabled
	 * <p>
	 * The return value for this parameter is only valid if getEnabled_IsPresent() returns true.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see SmartCardConfiguration#getEnabled_IsPresent()
	 * @return The current value for the parameter.
	 */
	public boolean getEnabled() {
		return parse_boolean("EN", "ON", "OFF");
	}

	/**
	 * Indicates if getMemoryType() parameter is present.
	 * <p>
	 * This function is useful to determine if the given parameter is supported on the current printer.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned by the parameter getMemoryType() may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see SmartCardConfiguration#getMemoryType()
	 * @return If the parameter is present and valid true, false otherwise.
	 */
	public boolean getMemoryType_IsPresent() {
		return containsData("MT") && isString("MT");
	}

	/**
	 * Memory Type
	 * <p>
	 * The return value for this parameter is only valid if getMemoryType_IsPresent() returns true.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see SmartCardConfiguration#getMemoryType_IsPresent()
	 * @return The current value for the parameter.
	 */
	public String getMemoryType() {
		return parse_string("MT");
	}

	/**
	 * Indicates if getResponseFormat() parameter is present.
	 * <p>
	 * This function is useful to determine if the given parameter is supported on the current printer.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned by the parameter getResponseFormat() may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see SmartCardConfiguration#getResponseFormat()
	 * @return If the parameter is present and valid true, false otherwise.
	 */
	public boolean getResponseFormat_IsPresent() {
		return containsData("R") && isString("R");
	}

	/**
	 * Response Format
	 * <p>
	 * The return value for this parameter is only valid if getResponseFormat_IsPresent() returns true.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see SmartCardConfiguration#getResponseFormat_IsPresent()
	 * @return The current value for the parameter.
	 */
	public String getResponseFormat() {
		return parse_string("R");
	}

	/**
	 * Indicates if getProtocol() parameter is present.
	 * <p>
	 * This function is useful to determine if the given parameter is supported on the current printer.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned by the parameter getProtocol() may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see SmartCardConfiguration#getProtocol()
	 * @return If the parameter is present and valid true, false otherwise.
	 */
	public boolean getProtocol_IsPresent() {
		return containsData("SP") && isString("SP");
	}

	/**
	 * Smart Card Protocol
	 * <p>
	 * The return value for this parameter is only valid if getProtocol_IsPresent() returns true.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see SmartCardConfiguration#getProtocol_IsPresent()
	 * @return The current value for the parameter.
	 */
	public String getProtocol() {
		return parse_string("SP");
	}

	/**
	 * Indicates if getType() parameter is present.
	 * <p>
	 * This function is useful to determine if the given parameter is supported on the current printer.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned by the parameter getType() may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see SmartCardConfiguration#getType()
	 * @return If the parameter is present and valid true, false otherwise.
	 */
	public boolean getType_IsPresent() {
		return containsData("ST") && isString("ST");
	}

	/**
	 * Smart Card Type
	 * <p>
	 * The return value for this parameter is only valid if getType_IsPresent() returns true.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see SmartCardConfiguration#getType_IsPresent()
	 * @return The current value for the parameter.
	 */
	public String getType() {
		return parse_string("ST");
	}

}
