package datamaxoneil.printer.configuration;

/**
 * This class handles the data from an {PH?} query as well as
 * accessors to read the data values.
 * <p>
 * This class supports the following possible parameters:
 * <table border=1>
 *    <tr><th>Parameter</th><th>Description</th></tr>
 *    <tr><td>DD</td><td>DPI</td></tr>
 *    <tr><td>M</td><td>Printhead Model</td></tr>
 *    <tr><td>PINS</td><td>Printhead Pins</td></tr>
 *    <tr><td>PT</td><td>Print Time</td></tr>
 *    <tr><td>T</td><td>Printhead Temperature</td></tr>
 *    <tr><td>TD</td><td>Printhead Width</td></tr>
 *    <tr><td>W</td><td>Page Width</td></tr>
 * </table>
 * @author Datamax-O'Neil
 * @version 2.0.1 (05 Sept 2013)
 */
public class PrintheadStatus extends PrinterState {

	/**
	 * The default constructor will initialize the class with default values.
	 * <p>
	 * Initially all of the _IsValid parameters will be false because no data has been processed.  To 'populate' the values, the object must invoke <see cref="PrinterState.Update(ONeil.Connection.ConnectionBase, int)">Update</see> with the query response string.
	 */
	public PrintheadStatus() {

		// Set Query Values
		m_QueryDescription = "Printhead Status";
		m_Query = "{PH?}";
		m_QueryResponseHeader = "{PH!";

		// Add names
		addName("DD", "DPI");
		addName("M", "Printhead Model");
		addName("PINS", "Printhead Pins");
		addName("PT", "Print Time");
		addName("T", "Printhead Temperature");
		addName("TD", "Printhead Width");
		addName("W", "Page Width");

		return;
	}
	/**
	 * Indicates if getDPI() parameter is present.
	 * <p>
	 * This function is useful to determine if the given parameter is supported on the current printer.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned by the parameter getDPI() may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see PrintheadStatus#getDPI()
	 * @return If the parameter is present and valid true, false otherwise.
	 */
	public boolean getDPI_IsPresent() {
		return containsData("DD") && isInteger("DD");
	}

	/**
	 * DPI
	 * <p>
	 * The return value for this parameter is only valid if getDPI_IsPresent() returns true.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see PrintheadStatus#getDPI_IsPresent()
	 * @return The current value for the parameter.
	 */
	public long getDPI() {
		return parse_long("DD");
	}

	/**
	 * Indicates if getPrintheadModel() parameter is present.
	 * <p>
	 * This function is useful to determine if the given parameter is supported on the current printer.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned by the parameter getPrintheadModel() may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see PrintheadStatus#getPrintheadModel()
	 * @return If the parameter is present and valid true, false otherwise.
	 */
	public boolean getPrintheadModel_IsPresent() {
		return containsData("M") && isString("M");
	}

	/**
	 * Printhead Model
	 * <p>
	 * The return value for this parameter is only valid if getPrintheadModel_IsPresent() returns true.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see PrintheadStatus#getPrintheadModel_IsPresent()
	 * @return The current value for the parameter.
	 */
	public String getPrintheadModel() {
		return parse_string("M");
	}

	/**
	 * Indicates if getPrintheadPins() parameter is present.
	 * <p>
	 * This function is useful to determine if the given parameter is supported on the current printer.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned by the parameter getPrintheadPins() may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see PrintheadStatus#getPrintheadPins()
	 * @return If the parameter is present and valid true, false otherwise.
	 */
	public boolean getPrintheadPins_IsPresent() {
		return containsData("PINS") && isInteger("PINS");
	}

	/**
	 * Printhead Pins
	 * <p>
	 * The return value for this parameter is only valid if getPrintheadPins_IsPresent() returns true.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see PrintheadStatus#getPrintheadPins_IsPresent()
	 * @return The current value for the parameter.
	 */
	public long getPrintheadPins() {
		return parse_long("PINS");
	}

	/**
	 * Indicates if getPrintTime() parameter is present.
	 * <p>
	 * This function is useful to determine if the given parameter is supported on the current printer.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned by the parameter getPrintTime() may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see PrintheadStatus#getPrintTime()
	 * @return If the parameter is present and valid true, false otherwise.
	 */
	public boolean getPrintTime_IsPresent() {
		return containsData("PT") && isInteger("PT");
	}

	/**
	 * Print Time
	 * <p>
	 * The return value for this parameter is only valid if getPrintTime_IsPresent() returns true.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see PrintheadStatus#getPrintTime_IsPresent()
	 * @return The current value for the parameter.
	 */
	public long getPrintTime() {
		return parse_long("PT");
	}

	/**
	 * Indicates if getPrintheadTemperature() parameter is present.
	 * <p>
	 * This function is useful to determine if the given parameter is supported on the current printer.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned by the parameter getPrintheadTemperature() may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see PrintheadStatus#getPrintheadTemperature()
	 * @return If the parameter is present and valid true, false otherwise.
	 */
	public boolean getPrintheadTemperature_IsPresent() {
		return containsData("T") && isDouble("T");
	}

	/**
	 * Printhead Temperature
	 * <p>
	 * The return value for this parameter is only valid if getPrintheadTemperature_IsPresent() returns true.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see PrintheadStatus#getPrintheadTemperature_IsPresent()
	 * @return The current value for the parameter.
	 */
	public double getPrintheadTemperature() {
		return parse_double("T");
	}

	/**
	 * Indicates if getPrintheadWidth() parameter is present.
	 * <p>
	 * This function is useful to determine if the given parameter is supported on the current printer.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned by the parameter getPrintheadWidth() may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see PrintheadStatus#getPrintheadWidth()
	 * @return If the parameter is present and valid true, false otherwise.
	 */
	public boolean getPrintheadWidth_IsPresent() {
		return containsData("TD") && isInteger("TD");
	}

	/**
	 * Printhead Width
	 * <p>
	 * The return value for this parameter is only valid if getPrintheadWidth_IsPresent() returns true.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see PrintheadStatus#getPrintheadWidth_IsPresent()
	 * @return The current value for the parameter.
	 */
	public long getPrintheadWidth() {
		return parse_long("TD");
	}

	/**
	 * Indicates if getPageWidth() parameter is present.
	 * <p>
	 * This function is useful to determine if the given parameter is supported on the current printer.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned by the parameter getPageWidth() may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see PrintheadStatus#getPageWidth()
	 * @return If the parameter is present and valid true, false otherwise.
	 */
	public boolean getPageWidth_IsPresent() {
		return containsData("W") && isInteger("W");
	}

	/**
	 * Page Width
	 * <p>
	 * The return value for this parameter is only valid if getPageWidth_IsPresent() returns true.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see PrintheadStatus#getPageWidth_IsPresent()
	 * @return The current value for the parameter.
	 */
	public long getPageWidth() {
		return parse_long("W");
	}

}
