package datamaxoneil.printer.configuration;

/**
 * This class handles the data from an {PO?} query as well as
 * accessors to read the data values.
 * <p>
 * This class supports the following possible parameters:
 * <table border=1>
 *    <tr><th>Parameter</th><th>Description</th></tr>
 *    <tr><td>B</td><td>SCR Device</td></tr>
 *    <tr><td>C</td><td>CF Device</td></tr>
 *    <tr><td>D</td><td>Printer Description</td></tr>
 *    <tr><td>F</td><td>Text Fixture String</td></tr>
 *    <tr><td>I</td><td>SPI Device</td></tr>
 *    <tr><td>M</td><td>Manufacturing Date</td></tr>
 *    <tr><td>N</td><td>Serial Number</td></tr>
 *    <tr><td>P</td><td>Part Number</td></tr>
 *    <tr><td>R</td><td>Certification Flag Status</td></tr>
 *    <tr><td>S</td><td>SDIO Device</td></tr>
 *    <tr><td>T</td><td>Printer Type</td></tr>
 * </table>
 * @author Datamax-O'Neil
 * @version 2.0.1 (05 Sept 2013)
 */
public class PrinterOptions extends PrinterState {

	/**
	 * The default constructor will initialize the class with default values.
	 * <p>
	 * Initially all of the _IsValid parameters will be false because no data has been processed.  To 'populate' the values, the object must invoke <see cref="PrinterState.Update(ONeil.Connection.ConnectionBase, int)">Update</see> with the query response string.
	 */
	public PrinterOptions() {

		// Set Query Values
		m_QueryDescription = "Printer Options";
		m_Query = "{PO?}";
		m_QueryResponseHeader = "{PO!";

		// Add names
		addName("B", "SCR Device");
		addName("C", "CF Device");
		addName("D", "Printer Description");
		addName("F", "Text Fixture String");
		addName("I", "SPI Device");
		addName("M", "Manufacturing Date");
		addName("N", "Serial Number");
		addName("P", "Part Number");
		addName("R", "Certification Flag Status");
		addName("S", "SDIO Device");
		addName("T", "Printer Type");

		return;
	}
	/**
	 * Indicates if getSCRDevice() parameter is present.
	 * <p>
	 * This function is useful to determine if the given parameter is supported on the current printer.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned by the parameter getSCRDevice() may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see PrinterOptions#getSCRDevice()
	 * @return If the parameter is present and valid true, false otherwise.
	 */
	public boolean getSCRDevice_IsPresent() {
		return containsData("B") && isInteger("B");
	}

	/**
	 * SCR Device
	 * <p>
	 * The return value for this parameter is only valid if getSCRDevice_IsPresent() returns true.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see PrinterOptions#getSCRDevice_IsPresent()
	 * @return The current value for the parameter.
	 */
	public long getSCRDevice() {
		return parse_long("B");
	}

	/**
	 * Indicates if getCFDevice() parameter is present.
	 * <p>
	 * This function is useful to determine if the given parameter is supported on the current printer.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned by the parameter getCFDevice() may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see PrinterOptions#getCFDevice()
	 * @return If the parameter is present and valid true, false otherwise.
	 */
	public boolean getCFDevice_IsPresent() {
		return containsData("C") && isInteger("C");
	}

	/**
	 * CF Device
	 * <p>
	 * The return value for this parameter is only valid if getCFDevice_IsPresent() returns true.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see PrinterOptions#getCFDevice_IsPresent()
	 * @return The current value for the parameter.
	 */
	public long getCFDevice() {
		return parse_long("C");
	}

	/**
	 * Indicates if getPrinterDescription() parameter is present.
	 * <p>
	 * This function is useful to determine if the given parameter is supported on the current printer.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned by the parameter getPrinterDescription() may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see PrinterOptions#getPrinterDescription()
	 * @return If the parameter is present and valid true, false otherwise.
	 */
	public boolean getPrinterDescription_IsPresent() {
		return containsData("D") && isString("D");
	}

	/**
	 * Printer Description
	 * <p>
	 * The return value for this parameter is only valid if getPrinterDescription_IsPresent() returns true.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see PrinterOptions#getPrinterDescription_IsPresent()
	 * @return The current value for the parameter.
	 */
	public String getPrinterDescription() {
		return parse_string("D");
	}

	/**
	 * Indicates if getTextFixtureString() parameter is present.
	 * <p>
	 * This function is useful to determine if the given parameter is supported on the current printer.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned by the parameter getTextFixtureString() may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see PrinterOptions#getTextFixtureString()
	 * @return If the parameter is present and valid true, false otherwise.
	 */
	public boolean getTextFixtureString_IsPresent() {
		return containsData("F") && isString("F");
	}

	/**
	 * Text Fixture String
	 * <p>
	 * The return value for this parameter is only valid if getTextFixtureString_IsPresent() returns true.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see PrinterOptions#getTextFixtureString_IsPresent()
	 * @return The current value for the parameter.
	 */
	public String getTextFixtureString() {
		return parse_string("F");
	}

	/**
	 * Indicates if getSPIDevice() parameter is present.
	 * <p>
	 * This function is useful to determine if the given parameter is supported on the current printer.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned by the parameter getSPIDevice() may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see PrinterOptions#getSPIDevice()
	 * @return If the parameter is present and valid true, false otherwise.
	 */
	public boolean getSPIDevice_IsPresent() {
		return containsData("I") && isInteger("I");
	}

	/**
	 * SPI Device
	 * <p>
	 * The return value for this parameter is only valid if getSPIDevice_IsPresent() returns true.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see PrinterOptions#getSPIDevice_IsPresent()
	 * @return The current value for the parameter.
	 */
	public long getSPIDevice() {
		return parse_long("I");
	}

	/**
	 * Indicates if getManufacturingDate() parameter is present.
	 * <p>
	 * This function is useful to determine if the given parameter is supported on the current printer.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned by the parameter getManufacturingDate() may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see PrinterOptions#getManufacturingDate()
	 * @return If the parameter is present and valid true, false otherwise.
	 */
	public boolean getManufacturingDate_IsPresent() {
		return containsData("M") && isString("M");
	}

	/**
	 * Manufacturing Date
	 * <p>
	 * The return value for this parameter is only valid if getManufacturingDate_IsPresent() returns true.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see PrinterOptions#getManufacturingDate_IsPresent()
	 * @return The current value for the parameter.
	 */
	public String getManufacturingDate() {
		return parse_string("M");
	}

	/**
	 * Indicates if getSerialNumber() parameter is present.
	 * <p>
	 * This function is useful to determine if the given parameter is supported on the current printer.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned by the parameter getSerialNumber() may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see PrinterOptions#getSerialNumber()
	 * @return If the parameter is present and valid true, false otherwise.
	 */
	public boolean getSerialNumber_IsPresent() {
		return containsData("N") && isString("N");
	}

	/**
	 * Serial Number
	 * <p>
	 * The return value for this parameter is only valid if getSerialNumber_IsPresent() returns true.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see PrinterOptions#getSerialNumber_IsPresent()
	 * @return The current value for the parameter.
	 */
	public String getSerialNumber() {
		return parse_string("N");
	}

	/**
	 * Indicates if getPartNumber() parameter is present.
	 * <p>
	 * This function is useful to determine if the given parameter is supported on the current printer.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned by the parameter getPartNumber() may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see PrinterOptions#getPartNumber()
	 * @return If the parameter is present and valid true, false otherwise.
	 */
	public boolean getPartNumber_IsPresent() {
		return containsData("P") && isString("P");
	}

	/**
	 * Part Number
	 * <p>
	 * The return value for this parameter is only valid if getPartNumber_IsPresent() returns true.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see PrinterOptions#getPartNumber_IsPresent()
	 * @return The current value for the parameter.
	 */
	public String getPartNumber() {
		return parse_string("P");
	}

	/**
	 * Indicates if getCertificationFlagStatus() parameter is present.
	 * <p>
	 * This function is useful to determine if the given parameter is supported on the current printer.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned by the parameter getCertificationFlagStatus() may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see PrinterOptions#getCertificationFlagStatus()
	 * @return If the parameter is present and valid true, false otherwise.
	 */
	public boolean getCertificationFlagStatus_IsPresent() {
		return containsData("R") && isString("R");
	}

	/**
	 * Certification Flag Status
	 * <p>
	 * The return value for this parameter is only valid if getCertificationFlagStatus_IsPresent() returns true.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see PrinterOptions#getCertificationFlagStatus_IsPresent()
	 * @return The current value for the parameter.
	 */
	public boolean getCertificationFlagStatus() {
		return parse_boolean("R", "1", "0");
	}

	/**
	 * Indicates if getSDIODevice() parameter is present.
	 * <p>
	 * This function is useful to determine if the given parameter is supported on the current printer.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned by the parameter getSDIODevice() may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see PrinterOptions#getSDIODevice()
	 * @return If the parameter is present and valid true, false otherwise.
	 */
	public boolean getSDIODevice_IsPresent() {
		return containsData("S") && isInteger("S");
	}

	/**
	 * SDIO Device
	 * <p>
	 * The return value for this parameter is only valid if getSDIODevice_IsPresent() returns true.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see PrinterOptions#getSDIODevice_IsPresent()
	 * @return The current value for the parameter.
	 */
	public long getSDIODevice() {
		return parse_long("S");
	}

	/**
	 * Indicates if getPrinterType() parameter is present.
	 * <p>
	 * This function is useful to determine if the given parameter is supported on the current printer.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned by the parameter getPrinterType() may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see PrinterOptions#getPrinterType()
	 * @return If the parameter is present and valid true, false otherwise.
	 */
	public boolean getPrinterType_IsPresent() {
		return containsData("T") && isInteger("T");
	}

	/**
	 * Printer Type
	 * <p>
	 * The return value for this parameter is only valid if getPrinterType_IsPresent() returns true.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see PrinterOptions#getPrinterType_IsPresent()
	 * @return The current value for the parameter.
	 */
	public long getPrinterType() {
		return parse_long("T");
	}

}
