package datamaxoneil.printer.configuration;

/**
 * This class handles the data from an {MY?} query as well as
 * accessors to read the data values.
 * <p>
 * This class supports the following possible parameters:
 * <table border=1>
 *    <tr><th>Parameter</th><th>Description</th></tr>
 *    <tr><td>DR</td><td>Download Memory Remaining</td></tr>
 *    <tr><td>DT</td><td>Download Memory Total</td></tr>
 *    <tr><td>EM</td><td>Size of the EEPROM in KB</td></tr>
 *    <tr><td>FM</td><td>Flash Type</td></tr>
 *    <tr><td>FR</td><td>Download Format Memory Remaining</td></tr>
 *    <tr><td>FS</td><td>Flash Memory Size</td></tr>
 *    <tr><td>FT</td><td>Download Format Memory Total</td></tr>
 *    <tr><td>RS</td><td>RAM Size</td></tr>
 * </table>
 * @author Datamax-O'Neil
 * @version 2.0.1 (05 Sept 2013)
 */
public class MemoryStatus extends PrinterState {

	/**
	 * The default constructor will initialize the class with default values.
	 * <p>
	 * Initially all of the _IsValid parameters will be false because no data has been processed.  To 'populate' the values, the object must invoke <see cref="PrinterState.Update(ONeil.Connection.ConnectionBase, int)">Update</see> with the query response string.
	 */
	public MemoryStatus() {

		// Set Query Values
		m_QueryDescription = "Memory Size and Status";
		m_Query = "{MY?}";
		m_QueryResponseHeader = "{MY!";

		// Add names
		addName("DR", "Download Memory Remaining");
		addName("DT", "Download Memory Total");
		addName("EM", "EEPROM Size");
		addName("FM", "Flash Type");
		addName("FR", "Download Format Memory Remaining");
		addName("FS", "Flash Memory Size");
		addName("FT", "Download Format Memory Total");
		addName("RS", "RAM Size");

		return;
	}
	/**
	 * Indicates if getDownloadMemoryRemaining() parameter is present.
	 * <p>
	 * This function is useful to determine if the given parameter is supported on the current printer.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned by the parameter getDownloadMemoryRemaining() may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see MemoryStatus#getDownloadMemoryRemaining()
	 * @return If the parameter is present and valid true, false otherwise.
	 */
	public boolean getDownloadMemoryRemaining_IsPresent() {
		return containsData("DR") && isInteger("DR");
	}

	/**
	 * Download Memory Remaining
	 * <p>
	 * The return value for this parameter is only valid if getDownloadMemoryRemaining_IsPresent() returns true.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see MemoryStatus#getDownloadMemoryRemaining_IsPresent()
	 * @return The current value for the parameter.
	 */
	public long getDownloadMemoryRemaining() {
		return parse_long("DR");
	}

	/**
	 * Indicates if getDownloadMemoryTotal() parameter is present.
	 * <p>
	 * This function is useful to determine if the given parameter is supported on the current printer.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned by the parameter getDownloadMemoryTotal() may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see MemoryStatus#getDownloadMemoryTotal()
	 * @return If the parameter is present and valid true, false otherwise.
	 */
	public boolean getDownloadMemoryTotal_IsPresent() {
		return containsData("DT") && isInteger("DT");
	}

	/**
	 * Download Memory Total
	 * <p>
	 * The return value for this parameter is only valid if getDownloadMemoryTotal_IsPresent() returns true.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see MemoryStatus#getDownloadMemoryTotal_IsPresent()
	 * @return The current value for the parameter.
	 */
	public long getDownloadMemoryTotal() {
		return parse_long("DT");
	}

	/**
	 * Indicates if getEEPROMSize() parameter is present.
	 * <p>
	 * This function is useful to determine if the given parameter is supported on the current printer.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned by the parameter getEEPROMSize() may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see MemoryStatus#getEEPROMSize()
	 * @return If the parameter is present and valid true, false otherwise.
	 */
	public boolean getEEPROMSize_IsPresent() {
		return containsData("EM") && isInteger("EM");
	}

	/**
	 * Size of the EEPROM in KB
	 * <p>
	 * The return value for this parameter is only valid if getEEPROMSize_IsPresent() returns true.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see MemoryStatus#getEEPROMSize_IsPresent()
	 * @return The current value for the parameter.
	 */
	public long getEEPROMSize() {
		return parse_long("EM");
	}

	/**
	 * Indicates if getFlashType() parameter is present.
	 * <p>
	 * This function is useful to determine if the given parameter is supported on the current printer.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned by the parameter getFlashType() may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see MemoryStatus#getFlashType()
	 * @return If the parameter is present and valid true, false otherwise.
	 */
	public boolean getFlashType_IsPresent() {
		return containsData("FM") && isString("FM");
	}

	/**
	 * Flash Type
	 * <p>
	 * The return value for this parameter is only valid if getFlashType_IsPresent() returns true.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see MemoryStatus#getFlashType_IsPresent()
	 * @return The current value for the parameter.
	 */
	public String getFlashType() {
		return parse_string("FM");
	}

	/**
	 * Indicates if getDownloadFormatMemoryRemaining() parameter is present.
	 * <p>
	 * This function is useful to determine if the given parameter is supported on the current printer.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned by the parameter getDownloadFormatMemoryRemaining() may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see MemoryStatus#getDownloadFormatMemoryRemaining()
	 * @return If the parameter is present and valid true, false otherwise.
	 */
	public boolean getDownloadFormatMemoryRemaining_IsPresent() {
		return containsData("FR") && isInteger("FR");
	}

	/**
	 * Download Format Memory Remaining
	 * <p>
	 * The return value for this parameter is only valid if getDownloadFormatMemoryRemaining_IsPresent() returns true.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see MemoryStatus#getDownloadFormatMemoryRemaining_IsPresent()
	 * @return The current value for the parameter.
	 */
	public long getDownloadFormatMemoryRemaining() {
		return parse_long("FR");
	}

	/**
	 * Indicates if getFlashMemorySize() parameter is present.
	 * <p>
	 * This function is useful to determine if the given parameter is supported on the current printer.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned by the parameter getFlashMemorySize() may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see MemoryStatus#getFlashMemorySize()
	 * @return If the parameter is present and valid true, false otherwise.
	 */
	public boolean getFlashMemorySize_IsPresent() {
		return containsData("FS") && isInteger("FS");
	}

	/**
	 * Flash Memory Size
	 * <p>
	 * The return value for this parameter is only valid if getFlashMemorySize_IsPresent() returns true.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see MemoryStatus#getFlashMemorySize_IsPresent()
	 * @return The current value for the parameter.
	 */
	public long getFlashMemorySize() {
		return parse_long("FS");
	}

	/**
	 * Indicates if getDownloadFormatMemoryTotal() parameter is present.
	 * <p>
	 * This function is useful to determine if the given parameter is supported on the current printer.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned by the parameter getDownloadFormatMemoryTotal() may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see MemoryStatus#getDownloadFormatMemoryTotal()
	 * @return If the parameter is present and valid true, false otherwise.
	 */
	public boolean getDownloadFormatMemoryTotal_IsPresent() {
		return containsData("FT") && isInteger("FT");
	}

	/**
	 * Download Format Memory Total
	 * <p>
	 * The return value for this parameter is only valid if getDownloadFormatMemoryTotal_IsPresent() returns true.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see MemoryStatus#getDownloadFormatMemoryTotal_IsPresent()
	 * @return The current value for the parameter.
	 */
	public long getDownloadFormatMemoryTotal() {
		return parse_long("FT");
	}

	/**
	 * Indicates if getRAMSize() parameter is present.
	 * <p>
	 * This function is useful to determine if the given parameter is supported on the current printer.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned by the parameter getRAMSize() may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see MemoryStatus#getRAMSize()
	 * @return If the parameter is present and valid true, false otherwise.
	 */
	public boolean getRAMSize_IsPresent() {
		return containsData("RS") && isInteger("RS");
	}

	/**
	 * RAM Size
	 * <p>
	 * The return value for this parameter is only valid if getRAMSize_IsPresent() returns true.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see MemoryStatus#getRAMSize_IsPresent()
	 * @return The current value for the parameter.
	 */
	public long getRAMSize() {
		return parse_long("RS");
	}

}
