package datamaxoneil.printer.configuration;

/**
 * This class handles the data from an {MR?} query as well as
 * accessors to read the data values.
 * <p>
 * This class supports the following possible parameters:
 * <table border=1>
 *    <tr><th>Parameter</th><th>Description</th></tr>
 *    <tr><td>T1</td><td>Track 1 Data</td></tr>
 *    <tr><td>T2</td><td>Track 2 Data</td></tr>
 *    <tr><td>T3</td><td>Track 3 Data</td></tr>
 * </table>
 * @author Datamax-O'Neil
 * @version 2.0.1 (05 Sept 2013)
 */
public class MagneticCardData extends PrinterState {

	/**
	 * The default constructor will initialize the class with default values.
	 * <p>
	 * Initially all of the _IsValid parameters will be false because no data has been processed.  To 'populate' the values, the object must invoke <see cref="PrinterState.Update(ONeil.Connection.ConnectionBase, int)">Update</see> with the query response string.
	 */
	public MagneticCardData() {

		// Set Query Values
		m_QueryDescription = "Magnetic Card Data";
		m_Query = "{MR?}";
		m_QueryResponseHeader = "{MR!";

		// Add names
		addName("T1", "Track 1 Data");
		addName("T2", "Track 2 Data");
		addName("T3", "Track 3 Data");

		return;
	}
	/**
	 * Indicates if getTrack1Data() parameter is present.
	 * <p>
	 * This function is useful to determine if the given parameter is supported on the current printer.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned by the parameter getTrack1Data() may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see MagneticCardData#getTrack1Data()
	 * @return If the parameter is present and valid true, false otherwise.
	 */
	public boolean getTrack1Data_IsPresent() {
		return containsData("T1") && isString("T1");
	}

	/**
	 * Track 1 Data
	 * <p>
	 * The return value for this parameter is only valid if getTrack1Data_IsPresent() returns true.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 * <p />
	 * Note: When a magnetic card is swiped the data is retained in the printer's memory until the printer goes to sleep, loses power, is reset or the data is manually cleared.  Querying the data will not clear it from the printers memory.  So a best practice is to send the {MZ!} command to the printer in the beginning to clear any previous data, and after you are done so the information doesn't remain.  This can be done with:
	 * <br /><code>printerConnection.write(Document.ESC + "{MZ!}");</code>
	 *
	 * @see MagneticCardData#getTrack1Data_IsPresent()
	 * @return The current value for the parameter.
	 */
	public String getTrack1Data() {
		return parse_string("T1");
	}

	/**
	 * Indicates if getTrack2Data() parameter is present.
	 * <p>
	 * This function is useful to determine if the given parameter is supported on the current printer.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned by the parameter getTrack2Data() may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see MagneticCardData#getTrack2Data()
	 * @return If the parameter is present and valid true, false otherwise.
	 */
	public boolean getTrack2Data_IsPresent() {
		return containsData("T2") && isString("T2");
	}

	/**
	 * Track 2 Data
	 * <p>
	 * The return value for this parameter is only valid if getTrack2Data_IsPresent() returns true.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 * <p />
	 * Note: When a magnetic card is swiped the data is retained in the printer's memory until the printer goes to sleep, loses power, is reset or the data is manually cleared.  Querying the data will not clear it from the printers memory.  So a best practice is to send the {MZ!} command to the printer in the beginning to clear any previous data, and after you are done so the information doesn't remain.  This can be done with:
	 * <br /><code>printerConnection.write(Document.ESC + "{MZ!}");</code>
	 *
	 * @see MagneticCardData#getTrack2Data_IsPresent()
	 * @return The current value for the parameter.
	 */
	public String getTrack2Data() {
		return parse_string("T2");
	}

	/**
	 * Indicates if getTrack3Data() parameter is present.
	 * <p>
	 * This function is useful to determine if the given parameter is supported on the current printer.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned by the parameter getTrack3Data() may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see MagneticCardData#getTrack3Data()
	 * @return If the parameter is present and valid true, false otherwise.
	 */
	public boolean getTrack3Data_IsPresent() {
		return containsData("T3") && isString("T3");
	}

	/**
	 * Track 3 Data
	 * <p>
	 * The return value for this parameter is only valid if getTrack3Data_IsPresent() returns true.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 * <p />
	 * Note: When a magnetic card is swiped the data is retained in the printer's memory until the printer goes to sleep, loses power, is reset or the data is manually cleared.  Querying the data will not clear it from the printers memory.  So a best practice is to send the {MZ!} command to the printer in the beginning to clear any previous data, and after you are done so the information doesn't remain.  This can be done with:
	 * <br /><code>printerConnection.write(Document.ESC + "{MZ!}");</code>
	 *
	 * @see MagneticCardData#getTrack3Data_IsPresent()
	 * @return The current value for the parameter.
	 */
	public String getTrack3Data() {
		return parse_string("T3");
	}

}
