package datamaxoneil.printer.configuration;

/**
 * This class handles the data from an {MC?} query as well as
 * accessors to read the data values.
 * <p>
 * This class supports the following possible parameters:
 * <table border=1>
 *    <tr><th>Parameter</th><th>Description</th></tr>
 *    <tr><td>A</td><td>Auto Print</td></tr>
 *    <tr><td>DIR</td><td>Card Read Direction</td></tr>
 *    <tr><td>EN</td><td>Enabled</td></tr>
 *    <tr><td>S</td><td>Auto Send</td></tr>
 *    <tr><td>T1</td><td>Track 1 Enabled</td></tr>
 *    <tr><td>T2</td><td>Track 2 Enabled</td></tr>
 *    <tr><td>T3</td><td>Track 3 Enabled</td></tr>
 * </table>
 * @author Datamax-O'Neil
 * @version 2.0.1 (05 Sept 2013)
 */
public class MagneticCardConfiguration extends PrinterState {

	/**
	 * The default constructor will initialize the class with default values.
	 * <p>
	 * Initially all of the _IsValid parameters will be false because no data has been processed.  To 'populate' the values, the object must invoke <see cref="PrinterState.Update(ONeil.Connection.ConnectionBase, int)">Update</see> with the query response string.
	 */
	public MagneticCardConfiguration() {

		// Set Query Values
		m_QueryDescription = "Magnetic Card Configuration";
		m_Query = "{MC?}";
		m_QueryResponseHeader = "{MC!";

		// Add names
		addName("A", "Auto Print");
		addName("DIR", "Card Read Direction");
		addName("EN", "Enabled");
		addName("S", "Auto Send");
		addName("T1", "Track 1 Enabled");
		addName("T2", "Track 2 Enabled");
		addName("T3", "Track 3 Enabled");

		return;
	}
	/**
	 * Indicates if getAutoPrint() parameter is present.
	 * <p>
	 * This function is useful to determine if the given parameter is supported on the current printer.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned by the parameter getAutoPrint() may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see MagneticCardConfiguration#getAutoPrint()
	 * @return If the parameter is present and valid true, false otherwise.
	 */
	public boolean getAutoPrint_IsPresent() {
		return containsData("A") && isString("A");
	}

	/**
	 * Auto Print
	 * <p>
	 * The return value for this parameter is only valid if getAutoPrint_IsPresent() returns true.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see MagneticCardConfiguration#getAutoPrint_IsPresent()
	 * @return The current value for the parameter.
	 */
	public boolean getAutoPrint() {
		return parse_boolean("A", "ON", "OFF");
	}

	/**
	 * Indicates if getCardReadDirection() parameter is present.
	 * <p>
	 * This function is useful to determine if the given parameter is supported on the current printer.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned by the parameter getCardReadDirection() may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see MagneticCardConfiguration#getCardReadDirection()
	 * @return If the parameter is present and valid true, false otherwise.
	 */
	public boolean getCardReadDirection_IsPresent() {
		return containsData("DIR") && isString("DIR");
	}

	/**
	 * Card Read Direction
	 * <p>
	 * The return value for this parameter is only valid if getCardReadDirection_IsPresent() returns true.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see MagneticCardConfiguration#getCardReadDirection_IsPresent()
	 * @return The current value for the parameter.
	 */
	public String getCardReadDirection() {
		return parse_string("DIR");
	}

	/**
	 * Indicates if getEnabled() parameter is present.
	 * <p>
	 * This function is useful to determine if the given parameter is supported on the current printer.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned by the parameter getEnabled() may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see MagneticCardConfiguration#getEnabled()
	 * @return If the parameter is present and valid true, false otherwise.
	 */
	public boolean getEnabled_IsPresent() {
		return containsData("EN") && isString("EN");
	}

	/**
	 * Enabled
	 * <p>
	 * The return value for this parameter is only valid if getEnabled_IsPresent() returns true.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see MagneticCardConfiguration#getEnabled_IsPresent()
	 * @return The current value for the parameter.
	 */
	public boolean getEnabled() {
		return parse_boolean("EN", "ON", "OFF");
	}

	/**
	 * Indicates if getAutoSend() parameter is present.
	 * <p>
	 * This function is useful to determine if the given parameter is supported on the current printer.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned by the parameter getAutoSend() may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see MagneticCardConfiguration#getAutoSend()
	 * @return If the parameter is present and valid true, false otherwise.
	 */
	public boolean getAutoSend_IsPresent() {
		return containsData("S") && isString("S");
	}

	/**
	 * Auto Send
	 * <p>
	 * The return value for this parameter is only valid if getAutoSend_IsPresent() returns true.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see MagneticCardConfiguration#getAutoSend_IsPresent()
	 * @return The current value for the parameter.
	 */
	public boolean getAutoSend() {
		return parse_boolean("S", "ON", "OFF");
	}

	/**
	 * Indicates if getTrack1Enabled() parameter is present.
	 * <p>
	 * This function is useful to determine if the given parameter is supported on the current printer.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned by the parameter getTrack1Enabled() may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see MagneticCardConfiguration#getTrack1Enabled()
	 * @return If the parameter is present and valid true, false otherwise.
	 */
	public boolean getTrack1Enabled_IsPresent() {
		return containsData("T1") && isString("T1");
	}

	/**
	 * Track 1 Enabled
	 * <p>
	 * The return value for this parameter is only valid if getTrack1Enabled_IsPresent() returns true.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see MagneticCardConfiguration#getTrack1Enabled_IsPresent()
	 * @return The current value for the parameter.
	 */
	public boolean getTrack1Enabled() {
		return parse_boolean("T1", "ON", "OFF");
	}

	/**
	 * Indicates if getTrack2Enabled() parameter is present.
	 * <p>
	 * This function is useful to determine if the given parameter is supported on the current printer.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned by the parameter getTrack2Enabled() may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see MagneticCardConfiguration#getTrack2Enabled()
	 * @return If the parameter is present and valid true, false otherwise.
	 */
	public boolean getTrack2Enabled_IsPresent() {
		return containsData("T2") && isString("T2");
	}

	/**
	 * Track 2 Enabled
	 * <p>
	 * The return value for this parameter is only valid if getTrack2Enabled_IsPresent() returns true.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see MagneticCardConfiguration#getTrack2Enabled_IsPresent()
	 * @return The current value for the parameter.
	 */
	public boolean getTrack2Enabled() {
		return parse_boolean("T2", "ON", "OFF");
	}

	/**
	 * Indicates if getTrack3Enabled() parameter is present.
	 * <p>
	 * This function is useful to determine if the given parameter is supported on the current printer.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned by the parameter getTrack3Enabled() may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see MagneticCardConfiguration#getTrack3Enabled()
	 * @return If the parameter is present and valid true, false otherwise.
	 */
	public boolean getTrack3Enabled_IsPresent() {
		return containsData("T3") && isString("T3");
	}

	/**
	 * Track 3 Enabled
	 * <p>
	 * The return value for this parameter is only valid if getTrack3Enabled_IsPresent() returns true.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see MagneticCardConfiguration#getTrack3Enabled_IsPresent()
	 * @return The current value for the parameter.
	 */
	public boolean getTrack3Enabled() {
		return parse_boolean("T3", "ON", "OFF");
	}

}
