package datamaxoneil.printer.configuration;
import java.util.List;
import java.util.ArrayList;

/**
 * This class handles the data from an {QUERY} query as well as
 * accessors to read the data values.
 * <p>
 * This class supports the following possible parameters:
 * <table border=1>
 *    <tr><th>Parameter</th><th>Description</th></tr>
 *    <tr><td>L</td><td>Format Location</td></tr>
 *    <tr><td>N1</td><td>One Character Name</td></tr>
 *    <tr><td>N5</td><td>Five Character Name</td></tr>
 *    <tr><td>UD</td><td>User Date</td></tr>
 *    <tr><td>US</td><td>User Description</td></tr>
 *    <tr><td>UV</td><td>User Version</td></tr>
 * </table>
 * @author Datamax-O'Neil
 * @version 2.0.1 (05 Sept 2013)
 */
public class FormatData extends PrinterData {

	/**
	 * The default constructor will initialize the class with default values.
	 * <p>
	 * Initially all of the _IsValid parameters will be false because no data has been processed.  To 'populate' the values, the object must invoke <see cref="PrinterState.Update(ONeil.Connection.ConnectionBase, int)">Update</see> with the query response string.
	 */
	public FormatData() {

		// Set Query Values
		m_QueryDescription = "{NAME}";
		m_Query = "{QUERY}";
		m_QueryResponseHeader = "{RESPONSEHEADER}";

		// Add names
		addName("L", "Memory Location");
		addName("N1", "One Character Name");
		addName("N5", "Five Character Name");
		addName("UD", "User Date");
		addName("US", "User Description");
		addName("UV", "User Version");

		return;
	}
	/**
	 * Indicates if getMemoryLocation() parameter is present.
	 * <p>
	 * This function is useful to determine if the given parameter is supported on the current printer.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned by the parameter getMemoryLocation() may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see FormatData#getMemoryLocation()
	 * @return If the parameter is present and valid true, false otherwise.
	 */
	public boolean getMemoryLocation_IsPresent() {
		return containsData("L") && isString("L");
	}

	/**
	 * Format Location
	 * <p>
	 * The return value for this parameter is only valid if getMemoryLocation_IsPresent() returns true.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see FormatData#getMemoryLocation_IsPresent()
	 * @return The current value for the parameter.
	 */
	public String getMemoryLocation() {
		return parse_string("L");
	}

	/**
	 * Indicates if getOneCharacterName() parameter is present.
	 * <p>
	 * This function is useful to determine if the given parameter is supported on the current printer.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned by the parameter getOneCharacterName() may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see FormatData#getOneCharacterName()
	 * @return If the parameter is present and valid true, false otherwise.
	 */
	public boolean getOneCharacterName_IsPresent() {
		return containsData("N1") && isString("N1");
	}

	/**
	 * One Character Name
	 * <p>
	 * The return value for this parameter is only valid if getOneCharacterName_IsPresent() returns true.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see FormatData#getOneCharacterName_IsPresent()
	 * @return The current value for the parameter.
	 */
	public String getOneCharacterName() {
		return parse_string("N1");
	}

	/**
	 * Indicates if getFiveCharacterName() parameter is present.
	 * <p>
	 * This function is useful to determine if the given parameter is supported on the current printer.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned by the parameter getFiveCharacterName() may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see FormatData#getFiveCharacterName()
	 * @return If the parameter is present and valid true, false otherwise.
	 */
	public boolean getFiveCharacterName_IsPresent() {
		return containsData("N5") && isString("N5");
	}

	/**
	 * Five Character Name
	 * <p>
	 * The return value for this parameter is only valid if getFiveCharacterName_IsPresent() returns true.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see FormatData#getFiveCharacterName_IsPresent()
	 * @return The current value for the parameter.
	 */
	public String getFiveCharacterName() {
		return parse_string("N5");
	}

	/**
	 * Indicates if getUserDate() parameter is present.
	 * <p>
	 * This function is useful to determine if the given parameter is supported on the current printer.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned by the parameter getUserDate() may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see FormatData#getUserDate()
	 * @return If the parameter is present and valid true, false otherwise.
	 */
	public boolean getUserDate_IsPresent() {
		return containsData("UD") && isString("UD");
	}

	/**
	 * User Date
	 * <p>
	 * The return value for this parameter is only valid if getUserDate_IsPresent() returns true.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see FormatData#getUserDate_IsPresent()
	 * @return The current value for the parameter.
	 */
	public String getUserDate() {
		return parse_string("UD");
	}

	/**
	 * Indicates if getUserDescription() parameter is present.
	 * <p>
	 * This function is useful to determine if the given parameter is supported on the current printer.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned by the parameter getUserDescription() may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see FormatData#getUserDescription()
	 * @return If the parameter is present and valid true, false otherwise.
	 */
	public boolean getUserDescription_IsPresent() {
		return containsData("US") && isString("US");
	}

	/**
	 * User Description
	 * <p>
	 * The return value for this parameter is only valid if getUserDescription_IsPresent() returns true.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see FormatData#getUserDescription_IsPresent()
	 * @return The current value for the parameter.
	 */
	public String getUserDescription() {
		return parse_string("US");
	}

	/**
	 * Indicates if getUserVersion() parameter is present.
	 * <p>
	 * This function is useful to determine if the given parameter is supported on the current printer.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned by the parameter getUserVersion() may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see FormatData#getUserVersion()
	 * @return If the parameter is present and valid true, false otherwise.
	 */
	public boolean getUserVersion_IsPresent() {
		return containsData("UV") && isString("UV");
	}

	/**
	 * User Version
	 * <p>
	 * The return value for this parameter is only valid if getUserVersion_IsPresent() returns true.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see FormatData#getUserVersion_IsPresent()
	 * @return The current value for the parameter.
	 */
	public String getUserVersion() {
		return parse_string("UV");
	}


	/**
	 * This factory function will return a list of the objects that were encoded in the query result block.
	 *
	 * @param text All of the objects in a ; delimited list
	 * @return A list of the individual objects
	*/
	static List<FormatData> parse(String text) {
		List<FormatData> results = new ArrayList<FormatData>();

		// Extract the individual elements
		String[] items = text.split(";");

		// Build the individual objects
		for (String item : items) {
			FormatData newItem = new FormatData();
			newItem.update(item.trim());
			results.add(newItem);
		}

		return results;
	}
}
