package datamaxoneil.printer.configuration;

/**
 * This class handles the data from an {CV?} query as well as
 * accessors to read the data values.
 * <p>
 * This class supports the following possible parameters:
 * <table border=1>
 *    <tr><th>Parameter</th><th>Description</th></tr>
 *    <tr><td>T</td><td>Upgrade Type</td></tr>
 *    <tr><td>V</td><td>Upgrade Version</td></tr>
 * </table>
 * @author Datamax-O'Neil
 * @version 2.0.1 (05 Sept 2013)
 */
public class ConfigurationVersion extends PrinterState {

	/**
	 * The default constructor will initialize the class with default values.
	 * <p>
	 * Initially all of the _IsValid parameters will be false because no data has been processed.  To 'populate' the values, the object must invoke <see cref="PrinterState.Update(ONeil.Connection.ConnectionBase, int)">Update</see> with the query response string.
	 */
	public ConfigurationVersion() {

		// Set Query Values
		m_QueryDescription = "Configuration Version";
		m_Query = "{CV?}";
		m_QueryResponseHeader = "{CV!";

		// Add names
		addName("T", "Upgrade Type");
		addName("V", "Upgrade Version");

		return;
	}
	/**
	 * Indicates if getUpgradeType() parameter is present.
	 * <p>
	 * This function is useful to determine if the given parameter is supported on the current printer.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned by the parameter getUpgradeType() may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see ConfigurationVersion#getUpgradeType()
	 * @return If the parameter is present and valid true, false otherwise.
	 */
	public boolean getUpgradeType_IsPresent() {
		return containsData("T") && isString("T");
	}

	/**
	 * Upgrade Type
	 * <p>
	 * The return value for this parameter is only valid if getUpgradeType_IsPresent() returns true.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see ConfigurationVersion#getUpgradeType_IsPresent()
	 * @return The current value for the parameter.
	 */
	public String getUpgradeType() {
		return parse_string("T");
	}

	/**
	 * Indicates if getUpgradeVersion() parameter is present.
	 * <p>
	 * This function is useful to determine if the given parameter is supported on the current printer.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned by the parameter getUpgradeVersion() may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see ConfigurationVersion#getUpgradeVersion()
	 * @return If the parameter is present and valid true, false otherwise.
	 */
	public boolean getUpgradeVersion_IsPresent() {
		return containsData("V") && isString("V");
	}

	/**
	 * Upgrade Version
	 * <p>
	 * The return value for this parameter is only valid if getUpgradeVersion_IsPresent() returns true.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see ConfigurationVersion#getUpgradeVersion_IsPresent()
	 * @return The current value for the parameter.
	 */
	public String getUpgradeVersion() {
		return parse_string("V");
	}

}
