package datamaxoneil.printer.configuration;

/**
 * This class handles the data from an {RS?} query as well as
 * accessors to read the data values.
 * <p>
 * This class supports the following possible parameters:
 * <table border=1>
 *    <tr><th>Parameter</th><th>Description</th></tr>
 *    <tr><td>G</td><td>Green LED Status</td></tr>
 *    <tr><td>P</td><td>Smart Card Power Enabled</td></tr>
 *    <tr><td>R</td><td>Red LED Status</td></tr>
 *    <tr><td>S</td><td>Smart Card Present</td></tr>
 * </table>
 * @author Datamax-O'Neil
 * @version 2.0.1 (05 Sept 2013)
 */
public class CardReaderStatus extends PrinterState {

	/**
	 * The default constructor will initialize the class with default values.
	 * <p>
	 * Initially all of the _IsValid parameters will be false because no data has been processed.  To 'populate' the values, the object must invoke <see cref="PrinterState.Update(ONeil.Connection.ConnectionBase, int)">Update</see> with the query response string.
	 */
	public CardReaderStatus() {

		// Set Query Values
		m_QueryDescription = "Card Reader Status";
		m_Query = "{RS?}";
		m_QueryResponseHeader = "{RS!";

		// Add names
		addName("G", "Green LED Status");
		addName("P", "Smart Card Power Enabled");
		addName("R", "Red LED Status");
		addName("S", "Smart Card Present");

		return;
	}
	/**
	 * Indicates if getGreenLEDStatus() parameter is present.
	 * <p>
	 * This function is useful to determine if the given parameter is supported on the current printer.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned by the parameter getGreenLEDStatus() may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see CardReaderStatus#getGreenLEDStatus()
	 * @return If the parameter is present and valid true, false otherwise.
	 */
	public boolean getGreenLEDStatus_IsPresent() {
		return containsData("G") && isString("G");
	}

	/**
	 * Green LED Status
	 * <p>
	 * The return value for this parameter is only valid if getGreenLEDStatus_IsPresent() returns true.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see CardReaderStatus#getGreenLEDStatus_IsPresent()
	 * @return The current value for the parameter.
	 */
	public String getGreenLEDStatus() {
		return parse_string("G");
	}

	/**
	 * Indicates if getSmartCardPowerEnabled() parameter is present.
	 * <p>
	 * This function is useful to determine if the given parameter is supported on the current printer.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned by the parameter getSmartCardPowerEnabled() may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see CardReaderStatus#getSmartCardPowerEnabled()
	 * @return If the parameter is present and valid true, false otherwise.
	 */
	public boolean getSmartCardPowerEnabled_IsPresent() {
		return containsData("P") && isString("P");
	}

	/**
	 * Smart Card Power Enabled
	 * <p>
	 * The return value for this parameter is only valid if getSmartCardPowerEnabled_IsPresent() returns true.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see CardReaderStatus#getSmartCardPowerEnabled_IsPresent()
	 * @return The current value for the parameter.
	 */
	public boolean getSmartCardPowerEnabled() {
		return parse_boolean("P", "1", "0");
	}

	/**
	 * Indicates if getRedLEDStatus() parameter is present.
	 * <p>
	 * This function is useful to determine if the given parameter is supported on the current printer.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned by the parameter getRedLEDStatus() may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see CardReaderStatus#getRedLEDStatus()
	 * @return If the parameter is present and valid true, false otherwise.
	 */
	public boolean getRedLEDStatus_IsPresent() {
		return containsData("R") && isString("R");
	}

	/**
	 * Red LED Status
	 * <p>
	 * The return value for this parameter is only valid if getRedLEDStatus_IsPresent() returns true.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see CardReaderStatus#getRedLEDStatus_IsPresent()
	 * @return The current value for the parameter.
	 */
	public String getRedLEDStatus() {
		return parse_string("R");
	}

	/**
	 * Indicates if getSmartCardPresent() parameter is present.
	 * <p>
	 * This function is useful to determine if the given parameter is supported on the current printer.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned by the parameter getSmartCardPresent() may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see CardReaderStatus#getSmartCardPresent()
	 * @return If the parameter is present and valid true, false otherwise.
	 */
	public boolean getSmartCardPresent_IsPresent() {
		return containsData("S") && isString("S");
	}

	/**
	 * Smart Card Present
	 * <p>
	 * The return value for this parameter is only valid if getSmartCardPresent_IsPresent() returns true.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see CardReaderStatus#getSmartCardPresent_IsPresent()
	 * @return The current value for the parameter.
	 */
	public boolean getSmartCardPresent() {
		return parse_boolean("S", "1", "0");
	}

}
