package datamaxoneil.printer.configuration;

/**
 * This class handles the data from an {BL?} query as well as
 * accessors to read the data values.
 * <p>
 * This class supports the following possible parameters:
 * <table border=1>
 *    <tr><th>Parameter</th><th>Description</th></tr>
 *    <tr><td>A</td><td>Device's authentication setting.</td></tr>
 *    <tr><td>AD</td><td>Unique MAC address of the Bluetooth device.</td></tr>
 *    <tr><td>B</td><td>Device's bondable setting</td></tr>
 *    <tr><td>C</td><td>Device's connectable setting</td></tr>
 *    <tr><td>CL</td><td>Device class for the Bluetooth device.</td></tr>
 *    <tr><td>D</td><td>Device's discoverability setting</td></tr>
 *    <tr><td>E</td><td>Device's encryption setting.</td></tr>
 *    <tr><td>F</td><td>Friendly name of the Bluetooth device.</td></tr>
 *    <tr><td>I</td><td>How long before the device will automatically disconnect.</td></tr>
 *    <tr><td>P</td><td>Device's passkey configuration.</td></tr>
 *    <tr><td>PR</td><td>Bluetooth profiles supported.</td></tr>
 *    <tr><td>PWR</td><td>Is the Bluetooth module powered.</td></tr>
 *    <tr><td>SN</td><td>Service name of the Bluetooth device.</td></tr>
 *    <tr><td>W</td><td>How long is the watchdog period for Bluetooth</td></tr>
 * </table>
 * @author Datamax-O'Neil
 * @version 2.0.1 (05 Sept 2013)
 */
public class BluetoothConfiguration extends PrinterState {

	/**
	 * The default constructor will initialize the class with default values.
	 * <p>
	 * Initially all of the _IsValid parameters will be false because no data has been processed.  To 'populate' the values, the object must invoke <see cref="PrinterState.Update(ONeil.Connection.ConnectionBase, int)">Update</see> with the query response string.
	 */
	public BluetoothConfiguration() {

		// Set Query Values
		m_QueryDescription = "Bluetooth Configuration";
		m_Query = "{BL?}";
		m_QueryResponseHeader = "{BL!";

		// Add names
		addName("A", "Authentication");
		addName("AD", "Bluetooth Address");
		addName("B", "Bondable");
		addName("C", "Connectable");
		addName("CL", "DeviceClass");
		addName("D", "Discoverable");
		addName("E", "Encryption");
		addName("F", "Friendly Name");
		addName("I", "Inactivity Timeout");
		addName("P", "Passkey");
		addName("PR", "Profile");
		addName("PWR", "Power");
		addName("SN", "Service Name");
		addName("W", "Watchdog Period");

		return;
	}
	/**
	 * Indicates if getAuthentication() parameter is present.
	 * <p>
	 * This function is useful to determine if the given parameter is supported on the current printer.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned by the parameter getAuthentication() may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see BluetoothConfiguration#getAuthentication()
	 * @return If the parameter is present and valid true, false otherwise.
	 */
	public boolean getAuthentication_IsPresent() {
		return containsData("A") && isString("A");
	}

	/**
	 * Device's authentication setting.
	 * <p>
	 * The return value for this parameter is only valid if getAuthentication_IsPresent() returns true.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see BluetoothConfiguration#getAuthentication_IsPresent()
	 * @return The current value for the parameter.
	 */
	public boolean getAuthentication() {
		return parse_boolean("A", "Y", "N");
	}

	/**
	 * Indicates if getBluetoothAddress() parameter is present.
	 * <p>
	 * This function is useful to determine if the given parameter is supported on the current printer.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned by the parameter getBluetoothAddress() may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see BluetoothConfiguration#getBluetoothAddress()
	 * @return If the parameter is present and valid true, false otherwise.
	 */
	public boolean getBluetoothAddress_IsPresent() {
		return containsData("AD") && isString("AD");
	}

	/**
	 * Unique MAC address of the Bluetooth device.
	 * <p>
	 * The return value for this parameter is only valid if getBluetoothAddress_IsPresent() returns true.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see BluetoothConfiguration#getBluetoothAddress_IsPresent()
	 * @return The current value for the parameter.
	 */
	public String getBluetoothAddress() {
		return parse_string("AD");
	}

	/**
	 * Indicates if getBondable() parameter is present.
	 * <p>
	 * This function is useful to determine if the given parameter is supported on the current printer.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned by the parameter getBondable() may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see BluetoothConfiguration#getBondable()
	 * @return If the parameter is present and valid true, false otherwise.
	 */
	public boolean getBondable_IsPresent() {
		return containsData("B") && isString("B");
	}

	/**
	 * Device's bondable setting
	 * <p>
	 * The return value for this parameter is only valid if getBondable_IsPresent() returns true.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see BluetoothConfiguration#getBondable_IsPresent()
	 * @return The current value for the parameter.
	 */
	public boolean getBondable() {
		return parse_boolean("B", "Y", "N");
	}

	/**
	 * Indicates if getConnectable() parameter is present.
	 * <p>
	 * This function is useful to determine if the given parameter is supported on the current printer.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned by the parameter getConnectable() may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see BluetoothConfiguration#getConnectable()
	 * @return If the parameter is present and valid true, false otherwise.
	 */
	public boolean getConnectable_IsPresent() {
		return containsData("C") && isString("C");
	}

	/**
	 * Device's connectable setting
	 * <p>
	 * The return value for this parameter is only valid if getConnectable_IsPresent() returns true.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see BluetoothConfiguration#getConnectable_IsPresent()
	 * @return The current value for the parameter.
	 */
	public boolean getConnectable() {
		return parse_boolean("C", "Y", "N");
	}

	/**
	 * Indicates if getDeviceClass() parameter is present.
	 * <p>
	 * This function is useful to determine if the given parameter is supported on the current printer.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned by the parameter getDeviceClass() may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see BluetoothConfiguration#getDeviceClass()
	 * @return If the parameter is present and valid true, false otherwise.
	 */
	public boolean getDeviceClass_IsPresent() {
		return containsData("CL") && isString("CL");
	}

	/**
	 * Device class for the Bluetooth device.
	 * <p>
	 * The return value for this parameter is only valid if getDeviceClass_IsPresent() returns true.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see BluetoothConfiguration#getDeviceClass_IsPresent()
	 * @return The current value for the parameter.
	 */
	public String getDeviceClass() {
		return parse_string("CL");
	}

	/**
	 * Indicates if getDiscoverable() parameter is present.
	 * <p>
	 * This function is useful to determine if the given parameter is supported on the current printer.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned by the parameter getDiscoverable() may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see BluetoothConfiguration#getDiscoverable()
	 * @return If the parameter is present and valid true, false otherwise.
	 */
	public boolean getDiscoverable_IsPresent() {
		return containsData("D") && isString("D");
	}

	/**
	 * Device's discoverability setting
	 * <p>
	 * The return value for this parameter is only valid if getDiscoverable_IsPresent() returns true.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see BluetoothConfiguration#getDiscoverable_IsPresent()
	 * @return The current value for the parameter.
	 */
	public boolean getDiscoverable() {
		return parse_boolean("D", "Y", "N");
	}

	/**
	 * Indicates if getEncryption() parameter is present.
	 * <p>
	 * This function is useful to determine if the given parameter is supported on the current printer.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned by the parameter getEncryption() may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see BluetoothConfiguration#getEncryption()
	 * @return If the parameter is present and valid true, false otherwise.
	 */
	public boolean getEncryption_IsPresent() {
		return containsData("E") && isString("E");
	}

	/**
	 * Device's encryption setting.
	 * <p>
	 * The return value for this parameter is only valid if getEncryption_IsPresent() returns true.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see BluetoothConfiguration#getEncryption_IsPresent()
	 * @return The current value for the parameter.
	 */
	public boolean getEncryption() {
		return parse_boolean("E", "Y", "N");
	}

	/**
	 * Indicates if getFriendlyName() parameter is present.
	 * <p>
	 * This function is useful to determine if the given parameter is supported on the current printer.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned by the parameter getFriendlyName() may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see BluetoothConfiguration#getFriendlyName()
	 * @return If the parameter is present and valid true, false otherwise.
	 */
	public boolean getFriendlyName_IsPresent() {
		return containsData("F") && isString("F");
	}

	/**
	 * Friendly name of the Bluetooth device.
	 * <p>
	 * The return value for this parameter is only valid if getFriendlyName_IsPresent() returns true.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see BluetoothConfiguration#getFriendlyName_IsPresent()
	 * @return The current value for the parameter.
	 */
	public String getFriendlyName() {
		return parse_string("F");
	}

	/**
	 * Indicates if getInactivityTimeout() parameter is present.
	 * <p>
	 * This function is useful to determine if the given parameter is supported on the current printer.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned by the parameter getInactivityTimeout() may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see BluetoothConfiguration#getInactivityTimeout()
	 * @return If the parameter is present and valid true, false otherwise.
	 */
	public boolean getInactivityTimeout_IsPresent() {
		return containsData("I") && isInteger("I");
	}

	/**
	 * How long before the device will automatically disconnect.
	 * <p>
	 * The return value for this parameter is only valid if getInactivityTimeout_IsPresent() returns true.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see BluetoothConfiguration#getInactivityTimeout_IsPresent()
	 * @return The current value for the parameter.
	 */
	public long getInactivityTimeout() {
		return parse_long("I");
	}

	/**
	 * Indicates if getPasskey() parameter is present.
	 * <p>
	 * This function is useful to determine if the given parameter is supported on the current printer.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned by the parameter getPasskey() may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see BluetoothConfiguration#getPasskey()
	 * @return If the parameter is present and valid true, false otherwise.
	 */
	public boolean getPasskey_IsPresent() {
		return containsData("P") && isString("P");
	}

	/**
	 * Device's passkey configuration.
	 * <p>
	 * The return value for this parameter is only valid if getPasskey_IsPresent() returns true.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see BluetoothConfiguration#getPasskey_IsPresent()
	 * @return The current value for the parameter.
	 */
	public boolean getPasskey() {
		return parse_boolean("P", "Y", "N");
	}

	/**
	 * Indicates if getProfile() parameter is present.
	 * <p>
	 * This function is useful to determine if the given parameter is supported on the current printer.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned by the parameter getProfile() may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see BluetoothConfiguration#getProfile()
	 * @return If the parameter is present and valid true, false otherwise.
	 */
	public boolean getProfile_IsPresent() {
		return containsData("PR") && isString("PR");
	}

	/**
	 * Bluetooth profiles supported.
	 * <p>
	 * The return value for this parameter is only valid if getProfile_IsPresent() returns true.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see BluetoothConfiguration#getProfile_IsPresent()
	 * @return The current value for the parameter.
	 */
	public String getProfile() {
		return parse_string("PR");
	}

	/**
	 * Indicates if getPower() parameter is present.
	 * <p>
	 * This function is useful to determine if the given parameter is supported on the current printer.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned by the parameter getPower() may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see BluetoothConfiguration#getPower()
	 * @return If the parameter is present and valid true, false otherwise.
	 */
	public boolean getPower_IsPresent() {
		return containsData("PWR") && isString("PWR");
	}

	/**
	 * Is the Bluetooth module powered.
	 * <p>
	 * The return value for this parameter is only valid if getPower_IsPresent() returns true.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see BluetoothConfiguration#getPower_IsPresent()
	 * @return The current value for the parameter.
	 */
	public boolean getPower() {
		return parse_boolean("PWR", "ON", "OFF");
	}

	/**
	 * Indicates if getServiceName() parameter is present.
	 * <p>
	 * This function is useful to determine if the given parameter is supported on the current printer.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned by the parameter getServiceName() may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see BluetoothConfiguration#getServiceName()
	 * @return If the parameter is present and valid true, false otherwise.
	 */
	public boolean getServiceName_IsPresent() {
		return containsData("SN") && isString("SN");
	}

	/**
	 * Service name of the Bluetooth device.
	 * <p>
	 * The return value for this parameter is only valid if getServiceName_IsPresent() returns true.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see BluetoothConfiguration#getServiceName_IsPresent()
	 * @return The current value for the parameter.
	 */
	public String getServiceName() {
		return parse_string("SN");
	}

	/**
	 * Indicates if getWatchdogPeriod() parameter is present.
	 * <p>
	 * This function is useful to determine if the given parameter is supported on the current printer.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned by the parameter getWatchdogPeriod() may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see BluetoothConfiguration#getWatchdogPeriod()
	 * @return If the parameter is present and valid true, false otherwise.
	 */
	public boolean getWatchdogPeriod_IsPresent() {
		return containsData("W") && isInteger("W");
	}

	/**
	 * How long is the watchdog period for Bluetooth
	 * <p>
	 * The return value for this parameter is only valid if getWatchdogPeriod_IsPresent() returns true.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see BluetoothConfiguration#getWatchdogPeriod_IsPresent()
	 * @return The current value for the parameter.
	 */
	public long getWatchdogPeriod() {
		return parse_long("W");
	}

}
