package datamaxoneil.printer.configuration;
import java.util.List;
import java.util.ArrayList;

/**
 * This class handles the data from an {QUERY} query as well as
 * accessors to read the data values.
 * <p>
 * This class supports the following possible parameters:
 * <table border=1>
 *    <tr><th>Parameter</th><th>Description</th></tr>
 *    <tr><td>F</td><td>Flags describing the file state.</td></tr>
 *    <tr><td>N</td><td>Name of the file.</td></tr>
 *    <tr><td>S</td><td>Size of the file in bites.</td></tr>
 * </table>
 * @author Datamax-O'Neil
 * @version 2.0.1 (05 Sept 2013)
 */
public class AvalancheFileData extends PrinterData {

	/**
	 * The default constructor will initialize the class with default values.
	 * <p>
	 * Initially all of the _IsValid parameters will be false because no data has been processed.  To 'populate' the values, the object must invoke <see cref="PrinterState.Update(ONeil.Connection.ConnectionBase, int)">Update</see> with the query response string.
	 */
	public AvalancheFileData() {

		// Set Query Values
		m_QueryDescription = "{NAME}";
		m_Query = "{QUERY}";
		m_QueryResponseHeader = "{RESPONSEHEADER}";

		// Add names
		addName("F", "Flags");
		addName("N", "Name");
		addName("S", "Size");

		return;
	}
	/**
	 * Indicates if getFlags() parameter is present.
	 * <p>
	 * This function is useful to determine if the given parameter is supported on the current printer.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned by the parameter getFlags() may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see AvalancheFileData#getFlags()
	 * @return If the parameter is present and valid true, false otherwise.
	 */
	public boolean getFlags_IsPresent() {
		return containsData("F") && isString("F");
	}

	/**
	 * Flags describing the file state.
	 * <p>
	 * The return value for this parameter is only valid if getFlags_IsPresent() returns true.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see AvalancheFileData#getFlags_IsPresent()
	 * @return The current value for the parameter.
	 */
	public String getFlags() {
		return parse_string("F");
	}

	/**
	 * Indicates if getName() parameter is present.
	 * <p>
	 * This function is useful to determine if the given parameter is supported on the current printer.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned by the parameter getName() may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see AvalancheFileData#getName()
	 * @return If the parameter is present and valid true, false otherwise.
	 */
	public boolean getName_IsPresent() {
		return containsData("N") && isString("N");
	}

	/**
	 * Name of the file.
	 * <p>
	 * The return value for this parameter is only valid if getName_IsPresent() returns true.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see AvalancheFileData#getName_IsPresent()
	 * @return The current value for the parameter.
	 */
	public String getName() {
		return parse_string("N");
	}

	/**
	 * Indicates if getSize() parameter is present.
	 * <p>
	 * This function is useful to determine if the given parameter is supported on the current printer.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned by the parameter getSize() may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see AvalancheFileData#getSize()
	 * @return If the parameter is present and valid true, false otherwise.
	 */
	public boolean getSize_IsPresent() {
		return containsData("S") && isInteger("S");
	}

	/**
	 * Size of the file in bites.
	 * <p>
	 * The return value for this parameter is only valid if getSize_IsPresent() returns true.  Because of differences in configuration, hardware or version certain parameter may not exist and the results returned may not be valid.  Instead of trying to indicate this with 'Magic Values' this method was implemented.
	 *
	 * @see AvalancheFileData#getSize_IsPresent()
	 * @return The current value for the parameter.
	 */
	public long getSize() {
		return parse_long("S");
	}


	/**
	 * This factory function will return a list of the objects that were encoded in the query result block.
	 *
	 * @param text All of the objects in a ; delimited list
	 * @return A list of the individual objects
	*/
	static List<AvalancheFileData> parse(String text) {
		List<AvalancheFileData> results = new ArrayList<AvalancheFileData>();

		// Extract the individual elements
		String[] items = text.split(";");

		// Build the individual objects
		for (String item : items) {
			AvalancheFileData newItem = new AvalancheFileData();
			newItem.update(item.trim());
			results.add(newItem);
		}

		return results;
	}
}
