package datamaxoneil.printer;

import datamaxoneil.printer.Parameters;

/**
 * This class represents the general parameters that can be used to alter the
 * printing characteristics when 'printing' to a DocumentLP object. Printing
 * characteristics are 'local' to each print command they are passed into. To
 * have global settings the same parameters object can be passed into each write
 * call to the Document object.
 * 
 * @author Datamax-O'Neil
 * @version 2.0.1 (05 Sept 2013)
 */
public class ParametersLP extends Parameters {

	/**
	 * The font name is a one character string that represents the name of the
	 * font, already loaded on the printer, that you wish to print with.
	 * 
	 * @param fontName The one character font name or the empty string if the
	 *        default font is to be used.
	 * @since 1.0.0
	 */
	public void setFont(String fontName) {

		// Assign Value
		setFont(fontName, 1);

		return;
	}

	/**
	 * The horizontal multiplier property will cause the horizontal printing of
	 * the object to be scaled by that amount. So a value of two would cause a
	 * printing of the object to be double its original width. The default value
	 * for this parameter is 1 and the range of valid values is 1 to 2.
	 * 
	 * @param multiplier Factor by which to scale the printing horizontally.
	 * @throws IllegalArgumentException If the parameter values are not in the
	 *         valid range.
	 * @since 1.0.0
	 */
	public void setHorizontalMultiplier(int multiplier) throws IllegalArgumentException {

		// Assign Value
		setHorizontalMultiplier(multiplier, 1, 2);

		return;
	}

	/**
	 * The vertical multiplier property will cause the vertical printing of the
	 * object to be scaled by that amount. So a value of two would cause a
	 * printing of the object to be double its original height. The default
	 * value for this parameter is 1 and the range of valid values is 1 to 2.
	 * 
	 * @param multiplier Factor by which to scale the printing vertically.
	 * @throws IllegalArgumentException If the parameter values are not in the
	 *         valid range.
	 * @since 1.0.0
	 */
	public void setVerticalMultiplier(int multiplier) throws IllegalArgumentException {

		// Assign Value
		setVerticalMultiplier(multiplier, 1, 2);

		return;
	}
}
