package datamaxoneil.printer;

import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;

import javax.imageio.ImageIO;

/**
 * This class converts any bitmap object into a monochrome bitmap. 
 * @author Datamax-O'Neil
 * @version 2.1.0 (25 Oct 2013)
 */
public class MonoBitmapConverter {

	private int mWidth, mHeight;
	private ByteArrayOutputStream mImageStream;



/**
 * Converts the input image to 1bpp-monochrome bitmap
 * @param srcBitmap : Bitmap to be converted
 * @return :  Returns the byte array of the converted image.
 */
    public byte[] convertBitmap(BufferedImage srcBitmap) throws Exception
    {

    	mWidth = srcBitmap.getWidth();
    	mHeight = srcBitmap.getHeight();
    	mImageStream = new ByteArrayOutputStream();
    	
    	//Create a monochrome image buffer
    	BufferedImage monoImage = new BufferedImage(mWidth, mHeight, BufferedImage.TYPE_BYTE_BINARY);
    	
    	//For each pixel copy each pixel from original image to new image
    	for (int y = 0;y < mHeight;y++)
    		for (int x = 0; x < mWidth; x++)
    			monoImage.setRGB(x, y, srcBitmap.getRGB(x, y));
   
		//Write new image to data stream
    	ImageIO.write(monoImage, "bmp", mImageStream);

    	return mImageStream.toByteArray();
    }
  
}


