/*
 * Decompiled with CFR 0.152.
 */
package datamaxoneil.printer.configuration;

import datamaxoneil.printer.configuration.PrinterState;

public class TCPIPStatus
extends PrinterState {
    public TCPIPStatus() {
        this.m_QueryDescription = "TCPIP Status";
        this.m_Query = "{TC?}";
        this.m_QueryResponseHeader = "{TC!";
        this.addName("802.11B Info", "Wireless Card Info");
        this.addName("C", "Valid Certificate Present");
        this.addName("CR", "Connection Reporting Enabled");
        this.addName("D", "Acquire IP");
        this.addName("DR", "Wireless Radio State");
        this.addName("E", "ESSID");
        this.addName("ET", "EAP Type");
        this.addName("G", "Gateway Address");
        this.addName("I", "IP Address");
        this.addName("I2", "Inactivity Timeout");
        this.addName("K", "Key To Use");
        this.addName("K1", "Key1");
        this.addName("K2", "Key2");
        this.addName("K3", "Key3");
        this.addName("K4", "Key4");
        this.addName("M", "Subnet Mask");
        this.addName("MAC", "MAC Address");
        this.addName("MX", "Migration Mode Enabled");
        this.addName("N", "Station Name");
        this.addName("NA", "Network Authentication");
        this.addName("P", "TCP Printing Port");
        this.addName("P2", "Power Saving Mode");
        this.addName("P2M", "Phase 2 Method");
        this.addName("P3", "UDP Printing Port");
        this.addName("PWR", "Card Powered");
        this.addName("Q", "Signal Quality Indicator");
        this.addName("S", "Authentication Algorithm");
        this.addName("T", "Station Type");
        this.addName("W", "Encryption Enabled");
        this.addName("Z", "Current Certificate CRC");
    }

    public boolean getWirelessCardInfo_IsPresent() {
        return this.containsData("802.11B Info") && this.isString("802.11B Info");
    }

    public String getWirelessCardInfo() {
        return this.parse_string("802.11B Info");
    }

    public boolean getValidCertificatePresent_IsPresent() {
        return this.containsData("C") && this.isString("C");
    }

    public boolean getValidCertificatePresent() {
        return this.parse_boolean("C", "Y", "N");
    }

    public boolean getConnectionReporting_IsPresent() {
        return this.containsData("CR") && this.isString("CR");
    }

    public boolean getConnectionReporting() {
        return this.parse_boolean("CR", "Y", "N");
    }

    public boolean getAcquireIP_IsPresent() {
        return this.containsData("D") && this.isString("D");
    }

    public IPAquiringValues getAcquireIP() {
        IPAquiringValues result = IPAquiringValues.Unset;
        if (this.containsData("D")) {
            result = this.queryResult("D").equals("B") ? IPAquiringValues.BOOTP : (this.queryResult("D").equals("F") ? IPAquiringValues.RequestFailed : (this.queryResult("D").equals("N") ? IPAquiringValues.StaticIP : (this.queryResult("D").equals("R") ? IPAquiringValues.RequestingIP : (this.queryResult("D").equals("Y") ? IPAquiringValues.DHCP : IPAquiringValues.Unknown))));
        }
        return result;
    }

    public boolean getRadioDisabled_IsPresent() {
        return this.containsData("DR") && this.isString("DR");
    }

    public boolean getRadioDisabled() {
        return this.parse_boolean("DR", "1", "0");
    }

    public boolean getESSID_IsPresent() {
        return this.containsData("E") && this.isString("E");
    }

    public String getESSID() {
        return this.parse_string("E");
    }

    public boolean getEAPType_IsPresent() {
        return this.containsData("ET") && this.isString("ET");
    }

    public EAPTypeValues getEAPType() {
        EAPTypeValues result = EAPTypeValues.Unset;
        if (this.containsData("ET")) {
            result = this.queryResult("ET").equals("0") ? EAPTypeValues.NONE : (this.queryResult("ET").equals("1") ? EAPTypeValues.IDENTITY : (this.queryResult("ET").equals("2") ? EAPTypeValues.NOTIFICATION : (this.queryResult("ET").equals("3") ? EAPTypeValues.NAK : (this.queryResult("ET").equals("4") ? EAPTypeValues.MD5 : (this.queryResult("ET").equals("5") ? EAPTypeValues.OTP : (this.queryResult("ET").equals("6") ? EAPTypeValues.GTC : (this.queryResult("ET").equals("13") ? EAPTypeValues.TLS : (this.queryResult("ET").equals("17") ? EAPTypeValues.LEAP : (this.queryResult("ET").equals("18") ? EAPTypeValues.SIM : (this.queryResult("ET").equals("21") ? EAPTypeValues.TTLS : (this.queryResult("ET").equals("25") ? EAPTypeValues.PEAP : (this.queryResult("ET").equals("26") ? EAPTypeValues.MSCHAPV2 : (this.queryResult("ET").equals("33") ? EAPTypeValues.TLV : (this.queryResult("ET").equals("43") ? EAPTypeValues.FAST : EAPTypeValues.Unknown))))))))))))));
        }
        return result;
    }

    public boolean getGatewayAddress_IsPresent() {
        return this.containsData("G") && this.isString("G");
    }

    public String getGatewayAddress() {
        return this.parse_string("G");
    }

    public boolean getIPAddress_IsPresent() {
        return this.containsData("I") && this.isString("I");
    }

    public String getIPAddress() {
        return this.parse_string("I");
    }

    public boolean getInactivityTimeout_IsPresent() {
        return this.containsData("I2") && this.isInteger("I2");
    }

    public long getInactivityTimeout() {
        return this.parse_long("I2");
    }

    public boolean getKeyToUse_IsPresent() {
        return this.containsData("K") && this.isInteger("K");
    }

    public long getKeyToUse() {
        return this.parse_long("K");
    }

    public boolean getKey1_IsPresent() {
        return this.containsData("K1") && this.isString("K1");
    }

    public AuthenticationKeyTypeValues getKey1() {
        AuthenticationKeyTypeValues result = AuthenticationKeyTypeValues.Unset;
        if (this.containsData("K1")) {
            result = this.queryResult("K1").equals("0") ? AuthenticationKeyTypeValues.None : (this.queryResult("K1").equals("5") ? AuthenticationKeyTypeValues.PSK_64Bits : (this.queryResult("K1").equals("13") ? AuthenticationKeyTypeValues.PSK_128Bits : AuthenticationKeyTypeValues.Unknown));
        }
        return result;
    }

    public boolean getKey2_IsPresent() {
        return this.containsData("K2") && this.isString("K2");
    }

    public AuthenticationKeyTypeValues getKey2() {
        AuthenticationKeyTypeValues result = AuthenticationKeyTypeValues.Unset;
        if (this.containsData("K2")) {
            result = this.queryResult("K2").equals("0") ? AuthenticationKeyTypeValues.None : (this.queryResult("K2").equals("5") ? AuthenticationKeyTypeValues.PSK_64Bits : (this.queryResult("K2").equals("13") ? AuthenticationKeyTypeValues.PSK_128Bits : AuthenticationKeyTypeValues.Unknown));
        }
        return result;
    }

    public boolean getKey3_IsPresent() {
        return this.containsData("K3") && this.isString("K3");
    }

    public AuthenticationKeyTypeValues getKey3() {
        AuthenticationKeyTypeValues result = AuthenticationKeyTypeValues.Unset;
        if (this.containsData("K3")) {
            result = this.queryResult("K3").equals("0") ? AuthenticationKeyTypeValues.None : (this.queryResult("K3").equals("5") ? AuthenticationKeyTypeValues.PSK_64Bits : (this.queryResult("K3").equals("13") ? AuthenticationKeyTypeValues.PSK_128Bits : AuthenticationKeyTypeValues.Unknown));
        }
        return result;
    }

    public boolean getKey4_IsPresent() {
        return this.containsData("K4") && this.isString("K4");
    }

    public AuthenticationKeyTypeValues getKey4() {
        AuthenticationKeyTypeValues result = AuthenticationKeyTypeValues.Unset;
        if (this.containsData("K4")) {
            result = this.queryResult("K4").equals("0") ? AuthenticationKeyTypeValues.None : (this.queryResult("K4").equals("5") ? AuthenticationKeyTypeValues.PSK_64Bits : (this.queryResult("K4").equals("13") ? AuthenticationKeyTypeValues.PSK_128Bits : AuthenticationKeyTypeValues.Unknown));
        }
        return result;
    }

    public boolean getSubnetMask_IsPresent() {
        return this.containsData("M") && this.isString("M");
    }

    public String getSubnetMask() {
        return this.parse_string("M");
    }

    public boolean getMACAddress_IsPresent() {
        return this.containsData("MAC") && this.isString("MAC");
    }

    public String getMACAddress() {
        return this.parse_string("MAC");
    }

    public boolean getMigrationModeEnabled_IsPresent() {
        return this.containsData("MX") && this.isString("MX");
    }

    public boolean getMigrationModeEnabled() {
        return this.parse_boolean("MX", "1", "0");
    }

    public boolean getStationName_IsPresent() {
        return this.containsData("N") && this.isString("N");
    }

    public String getStationName() {
        return this.parse_string("N");
    }

    public boolean getNetworkAuthentication_IsPresent() {
        return this.containsData("NA") && this.isString("NA");
    }

    public NetworkAuthenticationValues getNetworkAuthentication() {
        NetworkAuthenticationValues result = NetworkAuthenticationValues.Unset;
        if (this.containsData("NA")) {
            result = this.queryResult("NA").equals("0") ? NetworkAuthenticationValues.None : (this.queryResult("NA").equals("1") ? NetworkAuthenticationValues.LEAP : (this.queryResult("NA").equals("2") ? NetworkAuthenticationValues.WPA_PSK : (this.queryResult("NA").equals("3") ? NetworkAuthenticationValues.WPA : (this.queryResult("NA").equals("4") ? NetworkAuthenticationValues.WPA_LEAP : (this.queryResult("NA").equals("5") ? NetworkAuthenticationValues.WPA2_PSK : (this.queryResult("NA").equals("6") ? NetworkAuthenticationValues.WPA2 : (this.queryResult("NA").equals("7") ? NetworkAuthenticationValues.HostBasedEAP : NetworkAuthenticationValues.Unknown)))))));
        }
        return result;
    }

    public boolean getTCPPrintingPort_IsPresent() {
        return this.containsData("P") && this.isInteger("P");
    }

    public long getTCPPrintingPort() {
        return this.parse_long("P");
    }

    public boolean getPowerSavingMode_IsPresent() {
        return this.containsData("P2") && this.isString("P2");
    }

    public boolean getPowerSavingMode() {
        return this.parse_boolean("P2", "Y", "N");
    }

    public boolean getPhase2Method_IsPresent() {
        return this.containsData("P2M") && this.isString("P2M");
    }

    public Phase2MethodValues getPhase2Method() {
        Phase2MethodValues result = Phase2MethodValues.Unset;
        if (this.containsData("P2M")) {
            result = this.queryResult("P2M").equals("1") ? Phase2MethodValues.EAP_GTC : (this.queryResult("P2M").equals("2") ? Phase2MethodValues.EAP_MSCHAPV2 : (this.queryResult("P2M").equals("3") ? Phase2MethodValues.EAP_MD5 : (this.queryResult("P2M").equals("4") ? Phase2MethodValues.GTC : (this.queryResult("P2M").equals("5") ? Phase2MethodValues.MSCHAPV2 : (this.queryResult("P2M").equals("6") ? Phase2MethodValues.MSCHAP : (this.queryResult("P2M").equals("7") ? Phase2MethodValues.CHAP : (this.queryResult("P2M").equals("8") ? Phase2MethodValues.EAP_TLS : Phase2MethodValues.Unknown)))))));
        }
        return result;
    }

    public boolean getUDPPrintingPort_IsPresent() {
        return this.containsData("P3") && this.isInteger("P3");
    }

    public long getUDPPrintingPort() {
        return this.parse_long("P3");
    }

    public boolean getCardPowered_IsPresent() {
        return this.containsData("PWR") && this.isString("PWR");
    }

    public boolean getCardPowered() {
        return this.parse_boolean("PWR", "ON", "OFF");
    }

    public boolean getSignalQualityIndicator_IsPresent() {
        return this.containsData("Q") && this.isString("Q");
    }

    public boolean getSignalQualityIndicator() {
        return this.parse_boolean("Q", "Y", "N");
    }

    public boolean getAuthenticationAlgorithm_IsPresent() {
        return this.containsData("S") && this.isString("S");
    }

    public AuthenticationKeyTypeValues getAuthenticationAlgorithm() {
        AuthenticationKeyTypeValues result = AuthenticationKeyTypeValues.Unset;
        if (this.containsData("S")) {
            result = this.queryResult("S").equals("0") ? AuthenticationKeyTypeValues.None : (this.queryResult("S").equals("5") ? AuthenticationKeyTypeValues.PSK_64Bits : (this.queryResult("S").equals("13") ? AuthenticationKeyTypeValues.PSK_128Bits : AuthenticationKeyTypeValues.Unknown));
        }
        return result;
    }

    public boolean getStationType_IsPresent() {
        return this.containsData("T") && this.isString("T");
    }

    public NetworkTypeValues getStationType() {
        NetworkTypeValues result = NetworkTypeValues.Unset;
        if (this.containsData("T")) {
            result = this.queryResult("T").equals("H") ? NetworkTypeValues.AD_HOC : (this.queryResult("T").equals("P") ? NetworkTypeValues.AccessPoint : NetworkTypeValues.Unknown);
        }
        return result;
    }

    public boolean getEncryptionEnabled_IsPresent() {
        return this.containsData("W") && this.isInteger("W");
    }

    public long getEncryptionEnabled() {
        return this.parse_long("W");
    }

    public boolean getCurrentCertificateCRC_IsPresent() {
        return this.containsData("Z") && this.isString("Z");
    }

    public String getCurrentCertificateCRC() {
        return this.parse_string("Z");
    }

    public static enum NetworkTypeValues {
        Unset(-2),
        Unknown(-1),
        AD_HOC(72),
        AccessPoint(80);

        private int m_Value;

        private NetworkTypeValues(int value) {
            this.m_Value = value;
        }

        public int value() {
            return this.m_Value;
        }
    }

    public static enum Phase2MethodValues {
        Unset(-2),
        Unknown(-1),
        EAP_GTC(1),
        EAP_MSCHAPV2(2),
        EAP_MD5(3),
        GTC(4),
        MSCHAPV2(5),
        MSCHAP(6),
        CHAP(7),
        EAP_TLS(8);

        private int m_Value;

        private Phase2MethodValues(int value) {
            this.m_Value = value;
        }

        public int value() {
            return this.m_Value;
        }
    }

    public static enum NetworkAuthenticationValues {
        Unset(-2),
        Unknown(-1),
        None(0),
        LEAP(1),
        WPA_PSK(2),
        WPA(3),
        WPA_LEAP(4),
        WPA2_PSK(5),
        WPA2(6),
        HostBasedEAP(7);

        private int m_Value;

        private NetworkAuthenticationValues(int value) {
            this.m_Value = value;
        }

        public int value() {
            return this.m_Value;
        }
    }

    public static enum AuthenticationKeyTypeValues {
        Unset(-2),
        Unknown(-1),
        None(0),
        PSK_64Bits(5),
        PSK_128Bits(13);

        private int m_Value;

        private AuthenticationKeyTypeValues(int value) {
            this.m_Value = value;
        }

        public int value() {
            return this.m_Value;
        }
    }

    public static enum EAPTypeValues {
        Unset(-2),
        Unknown(-1),
        NONE(0),
        IDENTITY(1),
        NOTIFICATION(2),
        NAK(3),
        MD5(4),
        OTP(5),
        GTC(6),
        TLS(13),
        LEAP(17),
        SIM(18),
        TTLS(21),
        PEAP(25),
        MSCHAPV2(26),
        TLV(33),
        FAST(43);

        private int m_Value;

        private EAPTypeValues(int value) {
            this.m_Value = value;
        }

        public int value() {
            return this.m_Value;
        }
    }

    public static enum IPAquiringValues {
        Unset(-2),
        Unknown(-1),
        BOOTP(66),
        RequestFailed(70),
        StaticIP(78),
        RequestingIP(82),
        DHCP(89);

        private int m_Value;

        private IPAquiringValues(int value) {
            this.m_Value = value;
        }

        public int value() {
            return this.m_Value;
        }
    }
}

