/*
 * Decompiled with CFR 0.152.
 */
package datamaxoneil.printer.configuration;

import datamaxoneil.printer.configuration.PrinterState;

public class SSP_CommParameters
extends PrinterState {
    public SSP_CommParameters() {
        this.m_QueryDescription = "SSP Comm Parameters";
        this.m_Query = "{S2?}";
        this.m_QueryResponseHeader = "{S2!";
        this.addName("B", "Baud Rate");
        this.addName("H", "RS232 Handshake");
        this.addName("N", "RS232 Data Bits");
        this.addName("P", "RS232 Parity");
    }

    public boolean getBaudRate_IsPresent() {
        return this.containsData("B") && this.isString("B");
    }

    public BaudValue getBaudRate() {
        BaudValue result = BaudValue.Unset;
        if (this.containsData("B")) {
            result = this.queryResult("B").equals("012") ? BaudValue.Baud_1200 : (this.queryResult("B").equals("024") ? BaudValue.Baud_2400 : (this.queryResult("B").equals("048") ? BaudValue.Baud_4800 : (this.queryResult("B").equals("096") ? BaudValue.Baud_9600 : (this.queryResult("B").equals("192") ? BaudValue.Baud_19200 : (this.queryResult("B").equals("384") ? BaudValue.Baud_38400 : (this.queryResult("B").equals("576") ? BaudValue.Baud_57600 : (this.queryResult("B").equals("115") ? BaudValue.Baud_115200 : (this.queryResult("B").equals("230") ? BaudValue.Baud_230400 : (this.queryResult("B").equals("460") ? BaudValue.Baud_460800 : (this.queryResult("B").equals("921") ? BaudValue.Baud_921600 : BaudValue.Unknown))))))))));
        }
        return result;
    }

    public boolean getRS232Handshake_IsPresent() {
        return this.containsData("H") && this.isString("H");
    }

    public Handshake getRS232Handshake() {
        Handshake result = Handshake.Unset;
        if (this.containsData("H")) {
            result = this.queryResult("H").equals("N") ? Handshake.None : (this.queryResult("H").equals("H") ? Handshake.Hardware : (this.queryResult("H").equals("S") ? Handshake.Software : (this.queryResult("H").equals("B") ? Handshake.Both : Handshake.Unknown)));
        }
        return result;
    }

    public boolean getRS232DataBits_IsPresent() {
        return this.containsData("N") && this.isInteger("N");
    }

    public long getRS232DataBits() {
        return this.parse_long("N");
    }

    public boolean getRS232Parity_IsPresent() {
        return this.containsData("P") && this.isString("P");
    }

    public Parity getRS232Parity() {
        Parity result = Parity.Unset;
        if (this.containsData("P")) {
            result = this.queryResult("P").equals("N") ? Parity.None : (this.queryResult("P").equals("E") ? Parity.Even : (this.queryResult("P").equals("O") ? Parity.Odd : Parity.Unknown));
        }
        return result;
    }

    public static enum Parity {
        Unset(-2),
        Unknown(-1),
        None(0),
        Even(1),
        Odd(2);

        private int m_Value;

        private Parity(int value) {
            this.m_Value = value;
        }

        public int value() {
            return this.m_Value;
        }
    }

    public static enum Handshake {
        Unset(-2),
        Unknown(-1),
        None(0),
        Hardware(1),
        Software(2),
        Both(3);

        private int m_Value;

        private Handshake(int value) {
            this.m_Value = value;
        }

        public int value() {
            return this.m_Value;
        }
    }

    public static enum BaudValue {
        Unset(-2),
        Unknown(-1),
        Baud_1200(1200),
        Baud_2400(2400),
        Baud_4800(4800),
        Baud_9600(9600),
        Baud_19200(19200),
        Baud_38400(38400),
        Baud_57600(57600),
        Baud_115200(115200),
        Baud_230400(230400),
        Baud_460800(460800),
        Baud_921600(921600);

        private int m_Value;

        private BaudValue(int value) {
            this.m_Value = value;
        }

        public int value() {
            return this.m_Value;
        }
    }
}

