/*
 * Decompiled with CFR 0.152.
 */
package datamaxoneil.printer.configuration;

import datamaxoneil.connection.ConnectionBase;
import datamaxoneil.printer.configuration.PrinterData;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class PrinterState
extends PrinterData {
    public void update(ConnectionBase connection, int timeout) {
        connection.clearReadBuffer();
        connection.write(this.getQuery());
        this.update(connection.read("}", timeout));
    }

    @Override
    protected HashMap<String, PrinterData.NameValue> querySettings(String queryResults) throws IllegalStateException {
        int index;
        HashMap<String, PrinterData.NameValue> settings = new HashMap<String, PrinterData.NameValue>();
        if (this.m_Query == "{MR?}" && queryResults.indexOf(this.m_QueryResponseHeader) == -1 && queryResults.indexOf("{N}") != -1) {
            queryResults = "{MR!T1:|T2:|T3:}";
        }
        if ((index = queryResults.indexOf(this.m_QueryResponseHeader)) == -1) {
            return settings;
        }
        if ((index = (queryResults = queryResults.substring(index + this.m_QueryResponseHeader.length())).indexOf("}")) == -1) {
            return settings;
        }
        queryResults = queryResults.substring(0, index);
        if (this.m_Names.containsKey("")) {
            settings.put("", new PrinterData.NameValue(this, "", queryResults));
        } else {
            Pattern regexObject = this.m_Query.equalsIgnoreCase("{MR?}") ? Pattern.compile("([^:]+):([^|]*)\\|*") : Pattern.compile("([^:]+):([^;]*);*");
            Matcher matchObject = regexObject.matcher(queryResults);
            while (matchObject.find()) {
                String name = matchObject.group(1);
                String value = matchObject.group(2);
                if (settings.containsKey(name)) {
                    throw new IllegalStateException("Duplicate parameter '" + name + "' found in query '" + this.m_Query + "': " + queryResults);
                }
                if (this.m_Names.containsKey(name)) {
                    settings.put(name, new PrinterData.NameValue(this, name, value));
                    continue;
                }
                settings.put(name, new PrinterData.NameValue(this, name, value));
            }
        }
        return settings;
    }
}

