/*
 * Decompiled with CFR 0.152.
 */
package datamaxoneil.printer.configuration;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class PrinterData {
    protected HashMap<String, String> m_Names = new HashMap();
    private List<String> m_NamesOrder = new ArrayList<String>();
    private HashMap<String, NameValue> m_NameValuePairs_Queried = new HashMap();
    private HashMap<String, NameValue> m_NameValuePairs_Current = new HashMap();
    protected String m_QueryDescription;
    protected String m_Query;
    protected String m_QueryResponseHeader;

    public boolean getValid() {
        return this.m_NameValuePairs_Queried.size() > 0;
    }

    public String getQuery() {
        return "\u001b" + this.m_Query;
    }

    public String getQueryDescription() {
        return this.m_QueryDescription;
    }

    public void update(String responseString) {
        this.m_NameValuePairs_Queried = this.querySettings(responseString);
        this.m_NameValuePairs_Current.clear();
        for (String key : this.m_NameValuePairs_Queried.keySet()) {
            this.m_NameValuePairs_Current.put(key, this.m_NameValuePairs_Queried.get(key));
        }
    }

    public String queryResult(String name) {
        String result = null;
        if (this.m_NameValuePairs_Current.containsKey(name)) {
            result = this.m_NameValuePairs_Current.get(name).getValue();
        }
        return result;
    }

    public List<String> queryResults() {
        int index = 1;
        ArrayList<String> items = new ArrayList<String>();
        for (String name : this.m_NamesOrder) {
            if (!this.m_NameValuePairs_Current.containsKey(name)) continue;
            items.add(this.m_Names.get(name) + "\t" + this.m_NameValuePairs_Current.get(name).getValue());
        }
        for (NameValue item : this.m_NameValuePairs_Current.values()) {
            if (this.m_Names.containsKey(item.getName())) continue;
            items.add("Unknown" + index + "\t" + item.getValue());
        }
        return items;
    }

    public String toString() {
        return this.toString("L");
    }

    public String toString(String format) {
        String results = "";
        String resultsUnknown = "";
        if ("L".compareTo(format) == 0) {
            results = results + this.m_QueryDescription + "\n";
            for (String name : this.m_NamesOrder) {
                if (!this.m_NameValuePairs_Current.containsKey(name)) continue;
                results = results + this.m_Names.get(name) + "(" + this.m_NameValuePairs_Current.get(name).getName() + ")" + ":" + this.m_NameValuePairs_Current.get(name).getValue() + "\n";
            }
            for (NameValue item : this.m_NameValuePairs_Current.values()) {
                if (this.m_Names.containsKey(item.getName())) continue;
                resultsUnknown = resultsUnknown + "\t*** Unknown Parameter(" + item.getName() + "): " + item.getValue() + "\n";
            }
        } else if ("S".compareTo(format) == 0) {
            for (String name : this.m_NamesOrder) {
                if (!this.m_NameValuePairs_Current.containsKey(name)) continue;
                if (name != "") {
                    results = results + this.m_NameValuePairs_Current.get(name).getName() + ": " + this.m_NameValuePairs_Current.get(name).getValue() + "\n";
                    continue;
                }
                results = results + this.m_NameValuePairs_Current.get(name).getValue() + "\n";
            }
            for (NameValue item : this.m_NameValuePairs_Current.values()) {
                if (this.m_Names.containsKey(item.getName())) continue;
                resultsUnknown = resultsUnknown + item.getName() + ": " + item.getValue() + "\n";
            }
        } else {
            throw new IllegalArgumentException("toString parameter must be 'L' or 'S'");
        }
        return results + resultsUnknown;
    }

    protected HashMap<String, NameValue> querySettings(String queryResults) throws IllegalStateException {
        HashMap<String, NameValue> settings = new HashMap<String, NameValue>();
        Pattern regexObject = Pattern.compile("([^:]+):([^;]*);*");
        Matcher matchObject = regexObject.matcher(queryResults);
        while (matchObject.find()) {
            String name = matchObject.group(1);
            String value = matchObject.group(2);
            if (settings.containsKey(name)) {
                throw new IllegalStateException("Duplicate parameter '" + name + "' found in query '" + this.m_Query + "': " + queryResults);
            }
            if (this.m_Names.containsKey(name)) {
                settings.put(name, new NameValue(name, value));
                continue;
            }
            settings.put(name, new NameValue(name, value));
        }
        return settings;
    }

    protected boolean containsData(String parameter) {
        return this.m_NameValuePairs_Current.containsKey(parameter);
    }

    protected boolean isInteger(String name) {
        int index;
        String temp = this.m_NameValuePairs_Current.get(name).getValue().trim();
        for (index = 0; index < temp.length() && (temp.charAt(index) >= '0' && temp.charAt(index) <= '9' || temp.charAt(index) == '-'); ++index) {
        }
        if (index == 0) {
            return false;
        }
        try {
            Integer.parseInt(temp.substring(0, index));
        }
        catch (Exception ignore) {
            return false;
        }
        return temp != null && temp.length() > 0;
    }

    protected boolean isDouble(String name) {
        int index;
        String temp = this.m_NameValuePairs_Current.get(name).getValue().trim();
        for (index = 0; index < temp.length() && (temp.charAt(index) >= '0' && temp.charAt(index) <= '9' || temp.charAt(index) == '-' || temp.charAt(index) == '.'); ++index) {
        }
        if (index == 0) {
            return false;
        }
        try {
            Double.parseDouble(temp.substring(0, index));
        }
        catch (Exception ignore) {
            return false;
        }
        return temp != null && temp.length() > 0;
    }

    protected boolean isString(String name) {
        String temp = this.m_NameValuePairs_Current.get(name).getValue();
        return temp != null && temp.length() > 0;
    }

    protected boolean parse_boolean(String name, String trueValue, String falseValue) throws IllegalArgumentException {
        boolean result = false;
        if (this.m_NameValuePairs_Current.containsKey(name)) {
            String value = this.m_NameValuePairs_Current.get(name).getValue();
            if (value.equals(trueValue)) {
                result = true;
            } else if (value.equals(falseValue)) {
                result = false;
            } else {
                throw new IllegalArgumentException("Boolean value should have been \"" + trueValue + "\" or \"" + falseValue + "\" but instead was \"" + value + "\".");
            }
        }
        return result;
    }

    protected long parse_long(String name) {
        long result = 0L;
        if (this.m_NameValuePairs_Current.containsKey(name)) {
            int index;
            String temp = this.m_NameValuePairs_Current.get(name).getValue();
            for (index = 0; index < temp.length() && (temp.charAt(index) >= '0' && temp.charAt(index) <= '9' || temp.charAt(index) == '-'); ++index) {
            }
            temp = temp.substring(0, index);
            try {
                result = Integer.parseInt(temp);
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
        return result;
    }

    protected double parse_double(String name) {
        double result = 0.0;
        if (this.m_NameValuePairs_Current.containsKey(name)) {
            int index;
            String temp = this.m_NameValuePairs_Current.get(name).getValue();
            for (index = 0; index < temp.length() && (temp.charAt(index) >= '0' && temp.charAt(index) <= '9' || temp.charAt(index) == '-' || temp.charAt(index) == '.'); ++index) {
            }
            temp = temp.substring(0, index);
            try {
                result = Double.parseDouble(temp);
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
        return result;
    }

    protected String parse_string(String name) {
        String result = null;
        if (this.m_NameValuePairs_Current.containsKey(name)) {
            result = this.m_NameValuePairs_Current.get(name).getValue();
        }
        return result;
    }

    protected void addName(String parameter, String description) {
        this.m_Names.put(parameter, description);
        this.m_NamesOrder.add(parameter);
    }

    protected class NameValue {
        public String m_Name;
        public String m_Value;

        public String getName() {
            return this.m_Name;
        }

        public String getValue() {
            return this.m_Value;
        }

        public NameValue(String name, String value) {
            this.m_Name = name;
            this.m_Value = value;
        }
    }
}

