/*
 * Decompiled with CFR 0.152.
 */
package datamaxoneil.printer.configuration;

import datamaxoneil.printer.configuration.PrinterState;

public class LabelConfiguration
extends PrinterState {
    public LabelConfiguration() {
        this.m_QueryDescription = "Label Related Configuration Values";
        this.m_Query = "{CL?}";
        this.m_QueryResponseHeader = "{CL!";
        this.addName("B", "BackUp Distance");
        this.addName("BKO", "Backup Offset");
        this.addName("D", "QMark Stop Length");
        this.addName("I", "Additional Self Test Prints");
        this.addName("M", "Maximum QMark Advance");
        this.addName("MO", "Horizontal Offset");
        this.addName("P", "Use Presenter");
        this.addName("QBO", "QMARKB Offset");
        this.addName("QGO", "QMARKG Offset");
        this.addName("QTO", "QMARKT Offset");
        this.addName("QW", "White QMark");
        this.addName("S", "Paperout Sensor");
        this.addName("T", "Paper Stock Type");
        this.addName("U", "Presenter Timeout");
        this.addName("W", "Auto QMark Advance");
        this.addName("WB", "Auto QMark Backup");
    }

    public boolean getBackUpDistance_IsPresent() {
        return this.containsData("B") && this.isInteger("B");
    }

    public long getBackUpDistance() {
        return this.parse_long("B");
    }

    public boolean getBackupOffset_IsPresent() {
        return this.containsData("BKO") && this.isInteger("BKO");
    }

    public long getBackupOffset() {
        return this.parse_long("BKO");
    }

    public boolean getQMarkStopLength_IsPresent() {
        return this.containsData("D") && this.isInteger("D");
    }

    public long getQMarkStopLength() {
        return this.parse_long("D");
    }

    public boolean getAdditionalSelfTestPrints_IsPresent() {
        return this.containsData("I") && this.isInteger("I");
    }

    public long getAdditionalSelfTestPrints() {
        return this.parse_long("I");
    }

    public boolean getMaximumQMarkAdvance_IsPresent() {
        return this.containsData("M") && this.isInteger("M");
    }

    public long getMaximumQMarkAdvance() {
        return this.parse_long("M");
    }

    public boolean getHorizontalOffset_IsPresent() {
        return this.containsData("MO") && this.isInteger("MO");
    }

    public long getHorizontalOffset() {
        return this.parse_long("MO");
    }

    public boolean getUsePresenter_IsPresent() {
        return this.containsData("P") && this.isString("P");
    }

    public boolean getUsePresenter() {
        return this.parse_boolean("P", "Y", "N");
    }

    public boolean getQMARKBOffset_IsPresent() {
        return this.containsData("QBO") && this.isInteger("QBO");
    }

    public long getQMARKBOffset() {
        return this.parse_long("QBO");
    }

    public boolean getQMARKGOffset_IsPresent() {
        return this.containsData("QGO") && this.isInteger("QGO");
    }

    public long getQMARKGOffset() {
        return this.parse_long("QGO");
    }

    public boolean getQMARKTOffset_IsPresent() {
        return this.containsData("QTO") && this.isInteger("QTO");
    }

    public long getQMARKTOffset() {
        return this.parse_long("QTO");
    }

    public boolean getWhiteQMark_IsPresent() {
        return this.containsData("QW") && this.isString("QW");
    }

    public boolean getWhiteQMark() {
        return this.parse_boolean("QW", "Y", "N");
    }

    public boolean getPaperoutSensor_IsPresent() {
        return this.containsData("S") && this.isString("S");
    }

    public PaperOutSensorValue getPaperoutSensor() {
        PaperOutSensorValue result = PaperOutSensorValue.Unset;
        if (this.containsData("S")) {
            result = this.queryResult("S").equals("B") ? PaperOutSensorValue.Bottom : (this.queryResult("S").equals("T") ? PaperOutSensorValue.Top : PaperOutSensorValue.Unknown);
        }
        return result;
    }

    public boolean getPaperStockType_IsPresent() {
        return this.containsData("T") && this.isString("T");
    }

    public QMarkValue getPaperStockType() {
        QMarkValue result = QMarkValue.Unset;
        if (this.containsData("T")) {
            result = this.queryResult("T").equals("B") ? QMarkValue.BottomQMark : (this.queryResult("T").equals("G") ? QMarkValue.InterLabelGap : (this.queryResult("T").equals("P") ? QMarkValue.PlainPaper : (this.queryResult("T").equals("T") ? QMarkValue.TopQMARK : QMarkValue.Unknown)));
        }
        return result;
    }

    public boolean getPresenterTimeout_IsPresent() {
        return this.containsData("U") && this.isInteger("U");
    }

    public long getPresenterTimeout() {
        return this.parse_long("U");
    }

    public boolean getAutoQMarkAdvance_IsPresent() {
        return this.containsData("W") && this.isString("W");
    }

    public boolean getAutoQMarkAdvance() {
        return this.parse_boolean("W", "Y", "N");
    }

    public boolean getAutoQMarkBackup_IsPresent() {
        return this.containsData("WB") && this.isString("WB");
    }

    public boolean getAutoQMarkBackup() {
        return this.parse_boolean("WB", "Y", "N");
    }

    public static enum QMarkValue {
        Unset(-2),
        Unknown(-1),
        BottomQMark(66),
        InterLabelGap(71),
        PlainPaper(80),
        TopQMARK(84);

        private int m_Value;

        private QMarkValue(int value) {
            this.m_Value = value;
        }

        public int value() {
            return this.m_Value;
        }
    }

    public static enum PaperOutSensorValue {
        Unset(-2),
        Unknown(-1),
        Bottom(66),
        Top(84);

        private int m_Value;

        private PaperOutSensorValue(int value) {
            this.m_Value = value;
        }

        public int value() {
            return this.m_Value;
        }
    }
}

