/*
 * Decompiled with CFR 0.152.
 */
package datamaxoneil.printer.configuration;

import datamaxoneil.printer.configuration.PrinterState;

public class IrDAConfiguration
extends PrinterState {
    public IrDAConfiguration() {
        this.m_QueryDescription = "IrDA Configuration";
        this.m_Query = "{IR?}";
        this.m_QueryResponseHeader = "{IR!";
        this.addName("DV", "Direct Version");
        this.addName("ID", "IrDA Nickname");
        this.addName("IN", "IrDA Name");
        this.addName("IV", "IrDA Version");
        this.addName("P", "Protocol");
    }

    public boolean getDirectVersion_IsPresent() {
        return this.containsData("DV") && this.isString("DV");
    }

    public String getDirectVersion() {
        return this.parse_string("DV");
    }

    public boolean getIrDANickname_IsPresent() {
        return this.containsData("ID") && this.isString("ID");
    }

    public String getIrDANickname() {
        return this.parse_string("ID");
    }

    public boolean getIrDAName_IsPresent() {
        return this.containsData("IN") && this.isString("IN");
    }

    public String getIrDAName() {
        return this.parse_string("IN");
    }

    public boolean getIrDAVersion_IsPresent() {
        return this.containsData("IV") && this.isString("IV");
    }

    public String getIrDAVersion() {
        return this.parse_string("IV");
    }

    public boolean getProtocol_IsPresent() {
        return this.containsData("P") && this.isString("P");
    }

    public IrDAProtocolValue getProtocol() {
        IrDAProtocolValue result = IrDAProtocolValue.Unset;
        if (this.containsData("P")) {
            result = this.queryResult("P").equals("OFF") ? IrDAProtocolValue.OFF : (this.queryResult("P").equals("None") ? IrDAProtocolValue.None : (this.queryResult("P").equals("IrDA") ? IrDAProtocolValue.IrDA : (this.queryResult("P").equals("ASK") ? IrDAProtocolValue.ASK : (this.queryResult("P").equals("ASK_CRC") ? IrDAProtocolValue.ASK_CRC : (this.queryResult("P").equals("Direct") ? IrDAProtocolValue.Direct : (this.queryResult("P").equals("Direct_CRC") ? IrDAProtocolValue.Direct_CRC : (this.queryResult("P").equals("Pulse") ? IrDAProtocolValue.Pulse : (this.queryResult("P").equals("Pulse_CRC") ? IrDAProtocolValue.Pulse_CRC : IrDAProtocolValue.Unknown))))))));
        }
        return result;
    }

    public static enum IrDAProtocolValue {
        Unset(-2),
        Unknown(-1),
        OFF(0),
        None(1),
        IrDA(2),
        ASK(3),
        ASK_CRC(4),
        Direct(5),
        Direct_CRC(6),
        Pulse(7),
        Pulse_CRC(8);

        private int m_Value;

        private IrDAProtocolValue(int value) {
            this.m_Value = value;
        }

        public int value() {
            return this.m_Value;
        }
    }
}

