/*
 * Decompiled with CFR 0.152.
 */
package datamaxoneil.printer.configuration;

import datamaxoneil.printer.configuration.PrinterData;
import java.util.ArrayList;
import java.util.List;

public class GraphicData
extends PrinterData {
    public GraphicData() {
        this.m_QueryDescription = "{NAME}";
        this.m_Query = "{QUERY}";
        this.m_QueryResponseHeader = "{RESPONSEHEADER}";
        this.addName("CPI", "Characters Per Inch");
        this.addName("L", "Memory Location");
        this.addName("N1", "One Character Name");
        this.addName("N5", "Five Character Name");
        this.addName("UD", "User Date");
        this.addName("US", "User Description");
        this.addName("UV", "User Version");
    }

    public boolean getCharactersPerInch_IsPresent() {
        return this.containsData("CPI") && this.isString("CPI");
    }

    public String getCharactersPerInch() {
        return this.parse_string("CPI");
    }

    public boolean getMemoryLocation_IsPresent() {
        return this.containsData("L") && this.isString("L");
    }

    public String getMemoryLocation() {
        return this.parse_string("L");
    }

    public boolean getOneCharacterName_IsPresent() {
        return this.containsData("N1") && this.isString("N1");
    }

    public String getOneCharacterName() {
        return this.parse_string("N1");
    }

    public boolean getFiveCharacterName_IsPresent() {
        return this.containsData("N5") && this.isString("N5");
    }

    public String getFiveCharacterName() {
        return this.parse_string("N5");
    }

    public boolean getUserDate_IsPresent() {
        return this.containsData("UD") && this.isString("UD");
    }

    public String getUserDate() {
        return this.parse_string("UD");
    }

    public boolean getUserDescription_IsPresent() {
        return this.containsData("US") && this.isString("US");
    }

    public String getUserDescription() {
        return this.parse_string("US");
    }

    public boolean getUserVersion_IsPresent() {
        return this.containsData("UV") && this.isString("UV");
    }

    public String getUserVersion() {
        return this.parse_string("UV");
    }

    static List<GraphicData> parse(String text) {
        String[] items;
        ArrayList<GraphicData> results = new ArrayList<GraphicData>();
        for (String item : items = text.split(";")) {
            GraphicData newItem = new GraphicData();
            newItem.update(item.trim());
            results.add(newItem);
        }
        return results;
    }
}

