/*
 * Decompiled with CFR 0.152.
 */
package datamaxoneil.printer.configuration;

import datamaxoneil.printer.configuration.PrinterState;

public class GeneralStatus
extends PrinterState {
    public GeneralStatus() {
        this.m_QueryDescription = "General Status";
        this.m_Query = "{ST?}";
        this.m_QueryResponseHeader = "{ST!";
        this.addName("B", "Battery Temp and Voltage Status");
        this.addName("E", "Error Status");
        this.addName("J", "Paper Jam");
        this.addName("L", "Head Lever Down");
        this.addName("P", "Paper Present");
        this.addName("R", "Remaining RAM");
        this.addName("S", "Printer Status");
    }

    public boolean getBatteryTempandVoltageStatus_IsPresent() {
        return this.containsData("B") && this.isString("B");
    }

    public BatteryStatusValue getBatteryTempandVoltageStatus() {
        BatteryStatusValue result = BatteryStatusValue.Unset;
        if (this.containsData("B")) {
            result = this.queryResult("B").equals("O") ? BatteryStatusValue.AllOK : (this.queryResult("B").equals("T") ? BatteryStatusValue.TemperatureError : (this.queryResult("B").equals("V") ? BatteryStatusValue.VoltageError : BatteryStatusValue.Unknown));
        }
        return result;
    }

    public boolean getErrorStatus_IsPresent() {
        return this.containsData("E") && this.isString("E");
    }

    public ErrorStatusValue getErrorStatus() {
        ErrorStatusValue result = ErrorStatusValue.Unset;
        if (this.containsData("E")) {
            result = this.queryResult("E").equals("N") ? ErrorStatusValue.None : (this.queryResult("E").equals("c") ? ErrorStatusValue.Command : (this.queryResult("E").equals("d") ? ErrorStatusValue.Data : (this.queryResult("E").equals("g") ? ErrorStatusValue.GlobalParameter : (this.queryResult("E").equals("n") ? ErrorStatusValue.Name : (this.queryResult("E").equals("p") ? ErrorStatusValue.Protocol : (this.queryResult("E").equals("s") ? ErrorStatusValue.Syntax : (this.queryResult("E").equals("x") ? ErrorStatusValue.PCX_File : ErrorStatusValue.Unknown)))))));
        }
        return result;
    }

    public boolean getPaperJam_IsPresent() {
        return this.containsData("J") && this.isString("J");
    }

    public boolean getPaperJam() {
        return this.parse_boolean("J", "J", "N");
    }

    public boolean getHeadLeverDown_IsPresent() {
        return this.containsData("L") && this.isString("L");
    }

    public boolean getHeadLeverDown() {
        return this.parse_boolean("L", "D", "U");
    }

    public boolean getPaperPresent_IsPresent() {
        return this.containsData("P") && this.isString("P");
    }

    public boolean getPaperPresent() {
        return this.parse_boolean("P", "P", "N");
    }

    public boolean getRemainingRAM_IsPresent() {
        return this.containsData("R") && this.isInteger("R");
    }

    public long getRemainingRAM() {
        return this.parse_long("R");
    }

    public boolean getPrinterStatus_IsPresent() {
        return this.containsData("S") && this.isString("S");
    }

    public PrinterStatusValue getPrinterStatus() {
        PrinterStatusValue result = PrinterStatusValue.Unset;
        if (this.containsData("S")) {
            result = this.queryResult("S").equals("C") ? PrinterStatusValue.Complete : (this.queryResult("S").equals("I") ? PrinterStatusValue.Idle : (this.queryResult("S").equals("K") ? PrinterStatusValue.Killed : (this.queryResult("S").equals("P") ? PrinterStatusValue.Printing : (this.queryResult("S").equals("T") ? PrinterStatusValue.TimeOut : PrinterStatusValue.Unknown))));
        }
        return result;
    }

    public static enum PrinterStatusValue {
        Unset(-2),
        Unknown(-1),
        Complete(67),
        Idle(73),
        Killed(75),
        Printing(80),
        TimeOut(84);

        private int m_Value;

        private PrinterStatusValue(int value) {
            this.m_Value = value;
        }

        public int value() {
            return this.m_Value;
        }
    }

    public static enum ErrorStatusValue {
        Unset(-2),
        Unknown(-1),
        None(78),
        Command(99),
        Data(100),
        GlobalParameter(103),
        Name(110),
        Protocol(112),
        Syntax(115),
        PCX_File(120);

        private int m_Value;

        private ErrorStatusValue(int value) {
            this.m_Value = value;
        }

        public int value() {
            return this.m_Value;
        }
    }

    public static enum BatteryStatusValue {
        Unset(-2),
        Unknown(-1),
        AllOK(79),
        TemperatureError(84),
        VoltageError(86);

        private int m_Value;

        private BatteryStatusValue(int value) {
            this.m_Value = value;
        }

        public int value() {
            return this.m_Value;
        }
    }
}

