/*
 * Decompiled with CFR 0.152.
 */
package datamaxoneil.printer.configuration;

import datamaxoneil.printer.configuration.PrinterState;

public class GeneralConfiguration
extends PrinterState {
    public GeneralConfiguration() {
        this.m_QueryDescription = "General Configuration";
        this.m_Query = "{CF?}";
        this.m_QueryResponseHeader = "{CF!";
        this.addName("A", "White Space Advance");
        this.addName("B", "Baud Rate");
        this.addName("D", "Darkness Adjustment");
        this.addName("F", "Form Feed");
        this.addName("G", "Charger Beep");
        this.addName("H", "RS232 Handshake");
        this.addName("I", "Lines Per Page");
        this.addName("J", "EZ Print Job Status Report");
        this.addName("L", "Default Protocol");
        this.addName("LT", "Self Test Print Language");
        this.addName("M", "Form Feed Centering");
        this.addName("N", "RS232 Data Bits");
        this.addName("P", "RS232 Parity");
        this.addName("PF", "Formfeed Button Disabled");
        this.addName("PO", "Power Button Disabled");
        this.addName("PR", "RF Button Disabled");
        this.addName("QC", "QStop Multiplier");
        this.addName("R", "RF Power Timeout");
        this.addName("S", "Sound Enabled");
        this.addName("T", "System Timeout");
        this.addName("TP", "Special Test Print");
        this.addName("U", "Paper Out Beep");
        this.addName("UC", "USB Class");
        this.addName("USB", "Using USB");
    }

    public boolean getWhiteSpaceAdvance_IsPresent() {
        return this.containsData("A") && this.isString("A");
    }

    public boolean getWhiteSpaceAdvance() {
        return this.parse_boolean("A", "Y", "N");
    }

    public boolean getBaudRate_IsPresent() {
        return this.containsData("B") && this.isString("B");
    }

    public BaudValue getBaudRate() {
        BaudValue result = BaudValue.Unset;
        if (this.containsData("B")) {
            result = this.queryResult("B").equals("012") ? BaudValue.Baud_1200 : (this.queryResult("B").equals("024") ? BaudValue.Baud_2400 : (this.queryResult("B").equals("048") ? BaudValue.Baud_4800 : (this.queryResult("B").equals("096") ? BaudValue.Baud_9600 : (this.queryResult("B").equals("192") ? BaudValue.Baud_19200 : (this.queryResult("B").equals("384") ? BaudValue.Baud_38400 : (this.queryResult("B").equals("576") ? BaudValue.Baud_57600 : (this.queryResult("B").equals("115") ? BaudValue.Baud_115200 : (this.queryResult("B").equals("230") ? BaudValue.Baud_230400 : (this.queryResult("B").equals("460") ? BaudValue.Baud_460800 : (this.queryResult("B").equals("921") ? BaudValue.Baud_921600 : BaudValue.Unknown))))))))));
        }
        return result;
    }

    public boolean getDarknessAdjustment_IsPresent() {
        return this.containsData("D") && this.isInteger("D");
    }

    public long getDarknessAdjustment() {
        return this.parse_long("D");
    }

    public boolean getFormFeed_IsPresent() {
        return this.containsData("F") && this.isString("F");
    }

    public boolean getFormFeed() {
        return this.parse_boolean("F", "Y", "N");
    }

    public boolean getChargerBeep_IsPresent() {
        return this.containsData("G") && this.isString("G");
    }

    public boolean getChargerBeep() {
        return this.parse_boolean("G", "Y", "N");
    }

    public boolean getRS232Handshake_IsPresent() {
        return this.containsData("H") && this.isString("H");
    }

    public Handshake getRS232Handshake() {
        Handshake result = Handshake.Unset;
        if (this.containsData("H")) {
            result = this.queryResult("H").equals("N") ? Handshake.None : (this.queryResult("H").equals("H") ? Handshake.Hardware : (this.queryResult("H").equals("S") ? Handshake.Software : (this.queryResult("H").equals("B") ? Handshake.Both : Handshake.Unknown)));
        }
        return result;
    }

    public boolean getLinesPerPage_IsPresent() {
        return this.containsData("I") && this.isInteger("I");
    }

    public long getLinesPerPage() {
        return this.parse_long("I");
    }

    public boolean getEZPrintJobStatusReport_IsPresent() {
        return this.containsData("J") && this.isString("J");
    }

    public boolean getEZPrintJobStatusReport() {
        return this.parse_boolean("J", "Y", "N");
    }

    public boolean getDefaultProtocol_IsPresent() {
        return this.containsData("L") && this.isString("L");
    }

    public EmulationProtocolValue getDefaultProtocol() {
        EmulationProtocolValue result = EmulationProtocolValue.Unset;
        if (this.containsData("L")) {
            result = this.queryResult("L").equals("PK80") ? EmulationProtocolValue.PK80 : (this.queryResult("L").equals("EZ") ? EmulationProtocolValue.EZ : (this.queryResult("L").equals("ESC") ? EmulationProtocolValue.ESC : (this.queryResult("L").equals("LP") ? EmulationProtocolValue.LP : (this.queryResult("L").equals("EMZ1") ? EmulationProtocolValue.EMZ1 : (this.queryResult("L").equals("EMZ2") ? EmulationProtocolValue.EMZ2 : (this.queryResult("L").equals("EMZ3") ? EmulationProtocolValue.EMZ3 : (this.queryResult("L").equals("EMZ4") ? EmulationProtocolValue.EMZ4 : (this.queryResult("L").equals("EMC1") ? EmulationProtocolValue.EMC1 : (this.queryResult("L").equals("EMC2") ? EmulationProtocolValue.EMC2 : (this.queryResult("L").equals("EMC3") ? EmulationProtocolValue.EMC3 : (this.queryResult("L").equals("EMC4") ? EmulationProtocolValue.EMC4 : (this.queryResult("L").equals("EMP1") ? EmulationProtocolValue.EMP1 : (this.queryResult("L").equals("EMM1") ? EmulationProtocolValue.EMM1 : (this.queryResult("L").equals("EMZ5") ? EmulationProtocolValue.EMZ5 : (this.queryResult("L").equals("EMC6") ? EmulationProtocolValue.EMC6 : EmulationProtocolValue.Unknown)))))))))))))));
        }
        return result;
    }

    public boolean getSelfTestPrintLanguage_IsPresent() {
        return this.containsData("LT") && this.isInteger("LT");
    }

    public long getSelfTestPrintLanguage() {
        return this.parse_long("LT");
    }

    public boolean getFormFeedCentering_IsPresent() {
        return this.containsData("M") && this.isString("M");
    }

    public boolean getFormFeedCentering() {
        return this.parse_boolean("M", "Y", "N");
    }

    public boolean getRS232DataBits_IsPresent() {
        return this.containsData("N") && this.isInteger("N");
    }

    public long getRS232DataBits() {
        return this.parse_long("N");
    }

    public boolean getRS232Parity_IsPresent() {
        return this.containsData("P") && this.isString("P");
    }

    public Parity getRS232Parity() {
        Parity result = Parity.Unset;
        if (this.containsData("P")) {
            result = this.queryResult("P").equals("N") ? Parity.None : (this.queryResult("P").equals("E") ? Parity.Even : (this.queryResult("P").equals("O") ? Parity.Odd : Parity.Unknown));
        }
        return result;
    }

    public boolean getFormfeedButtonDisabled_IsPresent() {
        return this.containsData("PF") && this.isString("PF");
    }

    public boolean getFormfeedButtonDisabled() {
        return this.parse_boolean("PF", "Y", "N");
    }

    public boolean getPowerButtonDisabled_IsPresent() {
        return this.containsData("PO") && this.isString("PO");
    }

    public boolean getPowerButtonDisabled() {
        return this.parse_boolean("PO", "Y", "N");
    }

    public boolean getRFButtonDisabled_IsPresent() {
        return this.containsData("PR") && this.isString("PR");
    }

    public boolean getRFButtonDisabled() {
        return this.parse_boolean("PR", "Y", "N");
    }

    public boolean getQStopMultiplier_IsPresent() {
        return this.containsData("QC") && this.isInteger("QC");
    }

    public long getQStopMultiplier() {
        return this.parse_long("QC");
    }

    public boolean getRFPowerTimeout_IsPresent() {
        return this.containsData("R") && this.isInteger("R");
    }

    public long getRFPowerTimeout() {
        return this.parse_long("R");
    }

    public boolean getSoundEnabled_IsPresent() {
        return this.containsData("S") && this.isString("S");
    }

    public boolean getSoundEnabled() {
        return this.parse_boolean("S", "Y", "N");
    }

    public boolean getSystemTimeout_IsPresent() {
        return this.containsData("T") && this.isString("T");
    }

    public String getSystemTimeout() {
        return this.parse_string("T");
    }

    public boolean getSpecialTestPrint_IsPresent() {
        return this.containsData("TP") && this.isInteger("TP");
    }

    public long getSpecialTestPrint() {
        return this.parse_long("TP");
    }

    public boolean getPaperOutBeep_IsPresent() {
        return this.containsData("U") && this.isString("U");
    }

    public PaperOutBeepValue getPaperOutBeep() {
        PaperOutBeepValue result = PaperOutBeepValue.Unset;
        if (this.containsData("U")) {
            result = this.queryResult("U").equals("0") ? PaperOutBeepValue.OneBeep : (this.queryResult("U").equals("1") ? PaperOutBeepValue.FiveBeepsOnce : (this.queryResult("U").equals("2") ? PaperOutBeepValue.FiveBeepsEvery15Sec : (this.queryResult("U").equals("3") ? PaperOutBeepValue.FiveBeepsEvery30Sec : (this.queryResult("U").equals("4") ? PaperOutBeepValue.FiveBeepsEvery60Sec : PaperOutBeepValue.Unknown))));
        }
        return result;
    }

    public boolean getUSBClass_IsPresent() {
        return this.containsData("UC") && this.isString("UC");
    }

    public USBClassType getUSBClass() {
        USBClassType result = USBClassType.Unset;
        if (this.containsData("UC")) {
            result = this.queryResult("UC").equals("0") ? USBClassType.CDC : (this.queryResult("UC").equals("1") ? USBClassType.Printer : (this.queryResult("UC").equals("2") ? USBClassType.PrinterCDC : (this.queryResult("UC").equals("3") ? USBClassType.PrinterCDC_IAD : USBClassType.Unknown)));
        }
        return result;
    }

    public boolean getUsingUSB_IsPresent() {
        return this.containsData("USB") && this.isString("USB");
    }

    public boolean getUsingUSB() {
        return this.parse_boolean("USB", "1", "0");
    }

    public static enum USBClassType {
        Unset(-2),
        Unknown(-1),
        CDC(0),
        Printer(1),
        PrinterCDC(2),
        PrinterCDC_IAD(3);

        private int m_Value;

        private USBClassType(int value) {
            this.m_Value = value;
        }

        public int value() {
            return this.m_Value;
        }
    }

    public static enum PaperOutBeepValue {
        Unset(-2),
        Unknown(-1),
        OneBeep(0),
        FiveBeepsOnce(1),
        FiveBeepsEvery15Sec(2),
        FiveBeepsEvery30Sec(3),
        FiveBeepsEvery60Sec(4);

        private int m_Value;

        private PaperOutBeepValue(int value) {
            this.m_Value = value;
        }

        public int value() {
            return this.m_Value;
        }
    }

    public static enum Parity {
        Unset(-2),
        Unknown(-1),
        None(0),
        Even(1),
        Odd(2);

        private int m_Value;

        private Parity(int value) {
            this.m_Value = value;
        }

        public int value() {
            return this.m_Value;
        }
    }

    public static enum EmulationProtocolValue {
        Unset(-2),
        Unknown(-1),
        PK80(13),
        EZ(0),
        ESC(1),
        LP(2),
        EMZ1(3),
        EMZ2(4),
        EMZ3(5),
        EMZ4(6),
        EMC1(7),
        EMC2(8),
        EMC3(9),
        EMC4(10),
        EMP1(11),
        EMM1(12),
        EMZ5(14),
        EMC6(15);

        private int m_Value;

        private EmulationProtocolValue(int value) {
            this.m_Value = value;
        }

        public int value() {
            return this.m_Value;
        }
    }

    public static enum Handshake {
        Unset(-2),
        Unknown(-1),
        None(0),
        Hardware(1),
        Software(2),
        Both(3);

        private int m_Value;

        private Handshake(int value) {
            this.m_Value = value;
        }

        public int value() {
            return this.m_Value;
        }
    }

    public static enum BaudValue {
        Unset(-2),
        Unknown(-1),
        Baud_1200(1200),
        Baud_2400(2400),
        Baud_4800(4800),
        Baud_9600(9600),
        Baud_19200(19200),
        Baud_38400(38400),
        Baud_57600(57600),
        Baud_115200(115200),
        Baud_230400(230400),
        Baud_460800(460800),
        Baud_921600(921600);

        private int m_Value;

        private BaudValue(int value) {
            this.m_Value = value;
        }

        public int value() {
            return this.m_Value;
        }
    }
}

