/*
 * Decompiled with CFR 0.152.
 */
package datamaxoneil.printer.configuration;

import datamaxoneil.printer.configuration.PrinterState;

public class BluetoothConfiguration
extends PrinterState {
    public BluetoothConfiguration() {
        this.m_QueryDescription = "Bluetooth Configuration";
        this.m_Query = "{BL?}";
        this.m_QueryResponseHeader = "{BL!";
        this.addName("A", "Authentication");
        this.addName("AD", "Bluetooth Address");
        this.addName("B", "Bondable");
        this.addName("C", "Connectable");
        this.addName("CL", "DeviceClass");
        this.addName("D", "Discoverable");
        this.addName("E", "Encryption");
        this.addName("F", "Friendly Name");
        this.addName("I", "Inactivity Timeout");
        this.addName("P", "Passkey");
        this.addName("PR", "Profile");
        this.addName("PWR", "Power");
        this.addName("SN", "Service Name");
        this.addName("W", "Watchdog Period");
    }

    public boolean getAuthentication_IsPresent() {
        return this.containsData("A") && this.isString("A");
    }

    public boolean getAuthentication() {
        return this.parse_boolean("A", "Y", "N");
    }

    public boolean getBluetoothAddress_IsPresent() {
        return this.containsData("AD") && this.isString("AD");
    }

    public String getBluetoothAddress() {
        return this.parse_string("AD");
    }

    public boolean getBondable_IsPresent() {
        return this.containsData("B") && this.isString("B");
    }

    public boolean getBondable() {
        return this.parse_boolean("B", "Y", "N");
    }

    public boolean getConnectable_IsPresent() {
        return this.containsData("C") && this.isString("C");
    }

    public boolean getConnectable() {
        return this.parse_boolean("C", "Y", "N");
    }

    public boolean getDeviceClass_IsPresent() {
        return this.containsData("CL") && this.isString("CL");
    }

    public String getDeviceClass() {
        return this.parse_string("CL");
    }

    public boolean getDiscoverable_IsPresent() {
        return this.containsData("D") && this.isString("D");
    }

    public boolean getDiscoverable() {
        return this.parse_boolean("D", "Y", "N");
    }

    public boolean getEncryption_IsPresent() {
        return this.containsData("E") && this.isString("E");
    }

    public boolean getEncryption() {
        return this.parse_boolean("E", "Y", "N");
    }

    public boolean getFriendlyName_IsPresent() {
        return this.containsData("F") && this.isString("F");
    }

    public String getFriendlyName() {
        return this.parse_string("F");
    }

    public boolean getInactivityTimeout_IsPresent() {
        return this.containsData("I") && this.isInteger("I");
    }

    public long getInactivityTimeout() {
        return this.parse_long("I");
    }

    public boolean getPasskey_IsPresent() {
        return this.containsData("P") && this.isString("P");
    }

    public boolean getPasskey() {
        return this.parse_boolean("P", "Y", "N");
    }

    public boolean getProfile_IsPresent() {
        return this.containsData("PR") && this.isString("PR");
    }

    public String getProfile() {
        return this.parse_string("PR");
    }

    public boolean getPower_IsPresent() {
        return this.containsData("PWR") && this.isString("PWR");
    }

    public boolean getPower() {
        return this.parse_boolean("PWR", "ON", "OFF");
    }

    public boolean getServiceName_IsPresent() {
        return this.containsData("SN") && this.isString("SN");
    }

    public String getServiceName() {
        return this.parse_string("SN");
    }

    public boolean getWatchdogPeriod_IsPresent() {
        return this.containsData("W") && this.isInteger("W");
    }

    public long getWatchdogPeriod() {
        return this.parse_long("W");
    }
}

