/*
 * Decompiled with CFR 0.152.
 */
package datamaxoneil.printer.configuration;

import datamaxoneil.printer.configuration.PrinterState;

public class BatteryCondition
extends PrinterState {
    public BatteryCondition() {
        this.m_QueryDescription = "Battery Condition";
        this.m_Query = "{BT?}";
        this.m_QueryResponseHeader = "{BT!";
        this.addName("CH", "Charger Connected");
        this.addName("PS", "Power Source");
        this.addName("T", "Battery Temperature");
        this.addName("V", "Voltage Battery Single");
        this.addName("V1", "Voltage Battery 1");
        this.addName("V2", "Voltage Battery 2");
        this.addName("VE", "Voltage Battery Eliminator");
    }

    public boolean getChargerConnected_IsPresent() {
        return this.containsData("CH") && this.isString("CH");
    }

    public boolean getChargerConnected() {
        return this.parse_boolean("CH", "Y", "N");
    }

    public boolean getPowerSource_IsPresent() {
        return this.containsData("PS") && this.isString("PS");
    }

    public PowerSourceValue getPowerSource() {
        PowerSourceValue result = PowerSourceValue.Unset;
        if (this.containsData("PS")) {
            result = this.queryResult("PS").equals("A") ? PowerSourceValue.DCOverBattery : (this.queryResult("PS").equals("B") ? PowerSourceValue.BatteryOverDC : (this.queryResult("PS").equals("C") ? PowerSourceValue.BatteryEliminator : PowerSourceValue.Unknown));
        }
        return result;
    }

    public boolean getBatteryTemperature_IsPresent() {
        return this.containsData("T") && this.isDouble("T");
    }

    public double getBatteryTemperature() {
        return this.parse_double("T");
    }

    public boolean getVoltageBatterySingle_IsPresent() {
        return this.containsData("V") && this.isDouble("V");
    }

    public double getVoltageBatterySingle() {
        return this.parse_double("V");
    }

    public boolean getVoltageBattery1_IsPresent() {
        return this.containsData("V1") && this.isDouble("V1");
    }

    public double getVoltageBattery1() {
        return this.parse_double("V1");
    }

    public boolean getVoltageBattery2_IsPresent() {
        return this.containsData("V2") && this.isDouble("V2");
    }

    public double getVoltageBattery2() {
        return this.parse_double("V2");
    }

    public boolean getVoltageBatteryEliminator_IsPresent() {
        return this.containsData("VE") && this.isDouble("VE");
    }

    public double getVoltageBatteryEliminator() {
        return this.parse_double("VE");
    }

    public static enum PowerSourceValue {
        Unset(-2),
        Unknown(-1),
        DCOverBattery(65),
        BatteryOverDC(66),
        BatteryEliminator(67);

        private int m_Value;

        private PowerSourceValue(int value) {
            this.m_Value = value;
        }

        public int value() {
            return this.m_Value;
        }
    }
}

