/*
 * Decompiled with CFR 0.152.
 */
package datamaxoneil.printer.configuration;

import datamaxoneil.printer.configuration.PrinterState;

public class AvalancheSettings
extends PrinterState {
    public AvalancheSettings() {
        this.m_QueryDescription = "Avalanche Settings";
        this.m_Query = "{AE?}";
        this.m_QueryResponseHeader = "{AE!";
        this.addName("AIP", "Agent IP");
        this.addName("ALL", "Selftest Data");
        this.addName("ANA", "Agent Name");
        this.addName("APT", "Agent Port");
        this.addName("CON", "Connection Type");
        this.addName("MLN", "Printer Model Name");
        this.addName("PRE", "Prelicensed");
        this.addName("PRN", "Printer Name");
        this.addName("PRS", "Printer Result Flag");
        this.addName("RUN", "Avalanche Enabled");
        this.addName("TTO", "TCP Connect Timeout");
        this.addName("UIN", "Update Interval");
        this.addName("UPD", "Update Flags");
        this.addName("UTO", "UDP Timeout");
        this.addName("WRD", "Wired");
    }

    public boolean getAgentIP_IsPresent() {
        return this.containsData("AIP") && this.isString("AIP");
    }

    public String getAgentIP() {
        return this.parse_string("AIP");
    }

    public boolean getShowAllData_IsPresent() {
        return this.containsData("ALL") && this.isString("ALL");
    }

    public boolean getShowAllData() {
        return this.parse_boolean("ALL", "y", "n");
    }

    public boolean getAgentName_IsPresent() {
        return this.containsData("ANA") && this.isString("ANA");
    }

    public String getAgentName() {
        return this.parse_string("ANA");
    }

    public boolean getAgentPort_IsPresent() {
        return this.containsData("APT") && this.isInteger("APT");
    }

    public long getAgentPort() {
        return this.parse_long("APT");
    }

    public boolean getConnectionType_IsPresent() {
        return this.containsData("CON") && this.isString("CON");
    }

    public Connection getConnectionType() {
        Connection result = Connection.Unset;
        if (this.containsData("CON")) {
            result = this.queryResult("CON").equals("r") ? Connection.Serial : (this.queryResult("CON").equals("p") ? Connection.TCP_UDP : Connection.Unknown);
        }
        return result;
    }

    public boolean getPrinterModelName_IsPresent() {
        return this.containsData("MLN") && this.isString("MLN");
    }

    public String getPrinterModelName() {
        return this.parse_string("MLN");
    }

    public boolean getIsPrelicensed_IsPresent() {
        return this.containsData("PRE") && this.isString("PRE");
    }

    public boolean getIsPrelicensed() {
        return this.parse_boolean("PRE", "1", "0");
    }

    public boolean getPrinterName_IsPresent() {
        return this.containsData("PRN") && this.isString("PRN");
    }

    public String getPrinterName() {
        return this.parse_string("PRN");
    }

    public boolean getPrinterResultFlag_IsPresent() {
        return this.containsData("PRS") && this.isString("PRS");
    }

    public boolean getPrinterResultFlag() {
        return this.parse_boolean("PRS", "y", "n");
    }

    public boolean getIsAvalancheEnabled_IsPresent() {
        return this.containsData("RUN") && this.isString("RUN");
    }

    public boolean getIsAvalancheEnabled() {
        return this.parse_boolean("RUN", "1", "0");
    }

    public boolean getTCP_ConnectTimeout_IsPresent() {
        return this.containsData("TTO") && this.isInteger("TTO");
    }

    public long getTCP_ConnectTimeout() {
        return this.parse_long("TTO");
    }

    public boolean getUpdateInterval_IsPresent() {
        return this.containsData("UIN") && this.isInteger("UIN");
    }

    public long getUpdateInterval() {
        return this.parse_long("UIN");
    }

    public boolean getUpdateFlags_IsPresent() {
        return this.containsData("UPD") && this.isInteger("UPD");
    }

    public long getUpdateFlags() {
        return this.parse_long("UPD");
    }

    public boolean getUDP_Timeout_IsPresent() {
        return this.containsData("UTO") && this.isInteger("UTO");
    }

    public long getUDP_Timeout() {
        return this.parse_long("UTO");
    }

    public boolean getIsWired_IsPresent() {
        return this.containsData("WRD") && this.isString("WRD");
    }

    public boolean getIsWired() {
        return this.parse_boolean("WRD", "1", "0");
    }

    public static enum Connection {
        Unset(-2),
        Unknown(-1),
        Serial(72),
        TCP_UDP(70);

        private int m_Value;

        private Connection(int value) {
            this.m_Value = value;
        }

        public int value() {
            return this.m_Value;
        }
    }
}

