/*
 * Decompiled with CFR 0.152.
 */
package datamaxoneil.printer;

import datamaxoneil.printer.Parameters;

public class ParametersDPL
extends Parameters {
    private SingleByteSymbolSet m_SBSymbolSet = SingleByteSymbolSet.PC850_Multi;
    private DoubleByteSymbolSet m_DBSymbolSet = DoubleByteSymbolSet.GovernmentBureau;
    private boolean m_isDotMode = false;
    private String m_typeID = "0";
    private int m_FontHeight = 0;
    private int m_FontWidth = 0;
    private boolean m_isUnicode = false;
    private Rotation m_Rotation = Rotation.Rotate_0;
    private Alignment m_Alignment = Alignment.Left;
    private boolean m_IsMirrored = false;
    private MeasurementMode m_Measurement = MeasurementMode.Inch;
    private int m_symbolHeight = 0;
    private int m_fillPattern = 0;
    private int m_wideBarWidth = 0;
    private int m_narrowBarWidth = 0;

    public Rotation getRotate() {
        return this.m_Rotation;
    }

    public Alignment getAlignment() {
        return this.m_Alignment;
    }

    public int getWideBarWidth() {
        return this.m_wideBarWidth;
    }

    public void setWideBarWidth(int value) {
        if (value < 0 || value > 61) {
            throw new IllegalArgumentException(String.format("Parameter 'wideBarWidth' must be in the range of %1$s to %2$s, a value of %3$s was given.", 0, 61, value));
        }
        this.m_wideBarWidth = value;
    }

    public int getNarrowBarWidth() {
        return this.m_narrowBarWidth;
    }

    public void setNarrowBarWidth(int value) {
        if (value < 0 || value > 61) {
            throw new IllegalArgumentException(String.format("Parameter 'narrowBarWidth' must be in the range of %1$s to %2$s, a value of %3$s was given.", 0, 61, value));
        }
        this.m_narrowBarWidth = value;
    }

    public boolean getIsUnicode() {
        return this.m_isUnicode;
    }

    public void setIsUnicode(boolean value) {
        this.m_isUnicode = value;
    }

    public String getTypeID() {
        return this.m_typeID;
    }

    public void setTypeID(String value) {
        if (value.length() != 1) {
            throw new IllegalArgumentException(String.format("Parameter 'typeID' must be between 1 character in length. Value given was %1$s characters long.", value.length()));
        }
        this.m_typeID = value;
    }

    public SingleByteSymbolSet getSBSymbolSet() {
        return this.m_SBSymbolSet;
    }

    public void setSBSymbolSet(SingleByteSymbolSet value) {
        this.m_SBSymbolSet = value;
    }

    public DoubleByteSymbolSet getDBSymbolSet() {
        return this.m_DBSymbolSet;
    }

    public void setDBSymbolSet(DoubleByteSymbolSet value) {
        this.m_DBSymbolSet = value;
    }

    public String SymbolSetToString(SingleByteSymbolSet symbolSet) {
        switch (symbolSet) {
            case DeskTop: {
                return "DT";
            }
            case ISO8859_1_Latin1: {
                return "ET";
            }
            case ISO8859_2_Latin2: {
                return "E2";
            }
            case ISO8859_9_Latin5: {
                return "E5";
            }
            case ISO8859_10_Latin6: {
                return "E6";
            }
            case ISO8859_15_Latin9: {
                return "E9";
            }
            case ISO15_Italian: {
                return "IT";
            }
            case Legal: {
                return "LG";
            }
            case Math_8: {
                return "M8";
            }
            case Macintosh: {
                return "MC";
            }
            case PC858_Multi: {
                return "P9";
            }
            case PC8_Code437: {
                return "PC";
            }
            case PC8_DN_Code437N: {
                return "PD";
            }
            case PC852_Latin2: {
                return "PE";
            }
            case PC862_LatinHebrew: {
                return "PH";
            }
            case PC850_Multi: {
                return "PM";
            }
            case PC864_LatinArabic: {
                return "PR";
            }
            case PC8TK_Code437T: {
                return "PT";
            }
            case PC1004: {
                return "PU";
            }
            case PC775_Baltic: {
                return "PV";
            }
            case Roman8: {
                return "R8";
            }
            case Roman9: {
                return "R9";
            }
            case ISO17_Spanish: {
                return "SP";
            }
            case ISO11_Swedish: {
                return "SW";
            }
            case PS_Text: {
                return "TS";
            }
            case ISO4_UK: {
                return "UK";
            }
            case ISO6_ASCII: {
                return "US";
            }
            case UTF8: {
                return "U8";
            }
            case VentInt: {
                return "VI";
            }
            case VentMath: {
                return "VM";
            }
            case Windows31_Latin1: {
                return "W1";
            }
            case Windows_LatinArabic: {
                return "WA";
            }
            case Windows31_Latin2: {
                return "WE";
            }
            case Windows31_Baltic: {
                return "WL";
            }
            case Windows30_Latin1: {
                return "WO";
            }
            case Windows_LatinCyrillic: {
                return "WR";
            }
            case Windows31_Latin5: {
                return "WT";
            }
        }
        return "US";
    }

    public String SymbolSetToString(DoubleByteSymbolSet symbolSet) {
        switch (symbolSet) {
            case EUC: {
                return "EU";
            }
            case GovernmentBureau: {
                return "GB";
            }
            case JIS: {
                return "JS";
            }
            case ShiftJIS: {
                return "SJ";
            }
            case Unicode: {
                return "UC";
            }
        }
        return "GB";
    }

    public int getFontHeight() {
        return this.m_FontHeight;
    }

    public void setFontHeight(int value) {
        if (value != 0 && (value < 4 || value > 4163)) {
            throw new IllegalArgumentException(String.format("Parameter 'fontHeight' must be equal to 0 or between 4 - 4163. Value given was %1$s", value));
        }
        this.m_FontHeight = value;
    }

    public int getFontWidth() {
        return this.m_FontWidth;
    }

    public void setFontWidth(int value) {
        if (value != 0 && (value < 4 || value > 4163)) {
            throw new IllegalArgumentException(String.format("Parameter 'fontWidth' must be  0 or between 4 - 4163. Value given was %1$s", value));
        }
        this.m_FontWidth = value;
    }

    public int getFillPattern() {
        return this.m_fillPattern;
    }

    public void setFillPattern(int value) {
        if (value < 0 || value > 11) {
            throw new IllegalArgumentException(String.format("Parameter 'fillPattern' must be between 0 - 11. Value given was %1$s", value));
        }
        this.m_fillPattern = value;
    }

    public boolean getIsDotMode() {
        return this.m_isDotMode;
    }

    public void setIsDotMode(boolean value) {
        this.m_isDotMode = value;
    }

    public int getSymbolHeight() {
        return this.m_symbolHeight;
    }

    public void setSymbolHeight(int value) {
        if (value < 0 || value > 999) {
            throw new IllegalArgumentException(String.format("Parameter 'symbolHeight' must be between 0 - 999. Value given was %1$s", value));
        }
        this.m_symbolHeight = value;
    }

    public void setHorizontalMultiplier(int value) {
        this.setHorizontalMultiplier(value, 0, 61);
    }

    public void setVerticalMultiplier(int value) {
        this.setVerticalMultiplier(value, 0, 61);
    }

    public void setRotate(Rotation rotationAngle) throws IllegalArgumentException {
        if (rotationAngle == null) {
            throw new IllegalArgumentException("Parameter 'rotationAngle' cannot be null.");
        }
        this.m_Rotation = rotationAngle;
    }

    public void setAlignment(Alignment alignment) {
        if (alignment == null) {
            throw new IllegalArgumentException("Parameter 'rotationAngle' cannot be null.");
        }
        this.m_Alignment = alignment;
    }

    public boolean getIsMirrored() {
        return this.m_IsMirrored;
    }

    public void setIsMirrored(boolean value) {
        this.m_IsMirrored = value;
    }

    public MeasurementMode getMeasurement() {
        return this.m_Measurement;
    }

    public void setMeasurement(MeasurementMode value) {
        this.m_Measurement = value;
    }

    public static enum SingleByteSymbolSet {
        DeskTop,
        ISO8859_1_Latin1,
        ISO8859_2_Latin2,
        ISO8859_9_Latin5,
        ISO8859_10_Latin6,
        ISO8859_15_Latin9,
        ISO15_Italian,
        Legal,
        Math_8,
        Macintosh,
        PS_Math,
        PC858_Multi,
        PC8_Code437,
        PC8_DN_Code437N,
        PC852_Latin2,
        PC862_LatinHebrew,
        PC850_Multi,
        PC864_LatinArabic,
        PC8TK_Code437T,
        PC1004,
        PC775_Baltic,
        Roman8,
        Roman9,
        ISO17_Spanish,
        ISO11_Swedish,
        PS_Text,
        ISO4_UK,
        ISO6_ASCII,
        UTF8,
        VentInt,
        VentMath,
        Windows31_Latin1,
        Windows_LatinArabic,
        Windows31_Latin2,
        Windows31_Baltic,
        Windows30_Latin1,
        Windows_LatinCyrillic,
        Windows31_Latin5;

    }

    public static enum DoubleByteSymbolSet {
        BIG5,
        EUC,
        GovernmentBureau,
        JIS,
        ShiftJIS,
        Unicode;

    }

    public static enum MeasurementMode {
        Metric,
        Inch;

    }

    public static enum Alignment {
        Left,
        Center,
        Right;

    }

    public static enum Rotation {
        Rotate_0(1),
        Rotate_90(2),
        Rotate_180(3),
        Rotate_270(4);

        private int angle;

        private Rotation(int intValue) {
            this.angle = intValue;
        }

        public int getValue() {
            return this.angle;
        }
    }
}

