/*
 * Decompiled with CFR 0.152.
 */
package datamaxoneil.printer;

public abstract class Parameters {
    private String m_FontName = "";
    private boolean m_IsInverse = false;
    private int m_HorizontalMultiplier = 1;
    private int m_VerticalMultiplier = 1;

    public String getFont() {
        return this.m_FontName;
    }

    protected void setFont(String fontName, int size) throws IllegalArgumentException {
        if (fontName == null || fontName.length() != size && fontName.length() != 0) {
            throw new IllegalArgumentException("Parameter 'fontName' must be either " + size + " characters in length or the empty string.");
        }
        this.m_FontName = fontName;
    }

    protected void setFont(String fontName) {
        if (fontName == null || fontName.length() > 3 && fontName.length() != 0) {
            throw new IllegalArgumentException(String.format("Parameter 'fontName' must be at least " + Integer.toString(3) + " characters in length or the empty string.", new Object[0]));
        }
        this.m_FontName = fontName;
    }

    public boolean getIsInverse() {
        return this.m_IsInverse;
    }

    public void setIsInverse(boolean isPrintingInverse) {
        this.m_IsInverse = isPrintingInverse;
    }

    public int getHorizontalMultiplier() {
        return this.m_HorizontalMultiplier;
    }

    protected void setHorizontalMultiplier(int multiplier, int lowerBound, int upperBound) throws IllegalArgumentException {
        if (multiplier < lowerBound || multiplier > upperBound) {
            throw new IllegalArgumentException("Parameter 'multiplier' must be in the range of " + lowerBound + " to " + upperBound + ", a value of " + multiplier + " was given.");
        }
        this.m_HorizontalMultiplier = multiplier;
    }

    public int getVerticalMultiplier() {
        return this.m_VerticalMultiplier;
    }

    protected void setVerticalMultiplier(int multiplier, int lowerBound, int upperBound) throws IllegalArgumentException {
        if (multiplier < lowerBound || multiplier > upperBound) {
            throw new IllegalArgumentException("Parameter 'multiplier' must be in the range of " + lowerBound + " to " + upperBound + ", a value of " + multiplier + " was given.");
        }
        this.m_VerticalMultiplier = multiplier;
    }
}

