/*
 * Decompiled with CFR 0.152.
 */
package datamaxoneil.printer;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import javax.imageio.ImageIO;

public class MonoBitmapConverter {
    private int mWidth;
    private int mHeight;
    private ByteArrayOutputStream mImageStream;

    public byte[] convertBitmap(BufferedImage srcBitmap) throws Exception {
        this.mWidth = srcBitmap.getWidth();
        this.mHeight = srcBitmap.getHeight();
        this.mImageStream = new ByteArrayOutputStream();
        BufferedImage monoImage = new BufferedImage(this.mWidth, this.mHeight, 12);
        for (int y = 0; y < this.mHeight; ++y) {
            for (int x = 0; x < this.mWidth; ++x) {
                monoImage.setRGB(x, y, srcBitmap.getRGB(x, y));
            }
        }
        ImageIO.write((RenderedImage)monoImage, "bmp", this.mImageStream);
        return this.mImageStream.toByteArray();
    }
}

