/*
 * Decompiled with CFR 0.152.
 */
package datamaxoneil.printer;

import datamaxoneil.printer.Document;
import datamaxoneil.printer.ParametersLP;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;

public class DocumentLP
extends Document {
    private int m_LineSpacing = 0;
    private int m_FormLength = 0;
    private CharacterSet m_CharacterRemap = CharacterSet.USA;

    public DocumentLP(String fontName) throws IllegalArgumentException {
        this.m_FontNameLength = 1;
        this.setDefaultFont(fontName);
    }

    public int getPageLength() {
        return this.m_FormLength;
    }

    public void setPageLength(int textLines) throws IllegalArgumentException {
        if (textLines < 0 || textLines > 255) {
            throw new IllegalArgumentException("Parameter 'textLines' must be from 0 to 255, a value of " + textLines + " was given.");
        }
        this.m_FormLength = textLines;
    }

    public int getLineSpacing() {
        return this.m_LineSpacing;
    }

    public void setLineSpacing(int dotLines) throws IllegalArgumentException {
        if (dotLines < 0 || dotLines > 255) {
            throw new IllegalArgumentException("Parameter 'dotLines' must be from 0 to 255, a value of " + dotLines + " was given.");
        }
        this.m_LineSpacing = dotLines;
        byte commandValue = (byte)dotLines;
        this.addToDoc(this.m_Document, ESC + "A");
        this.addToDoc(this.m_Document, commandValue);
    }

    public CharacterSet getCharacterRemap() {
        return this.m_CharacterRemap;
    }

    public void setCharacterRemap(CharacterSet characterSet) throws IllegalArgumentException {
        if (characterSet == null) {
            throw new IllegalArgumentException("Parameter 'characterSet' cannot be null.");
        }
        this.m_CharacterRemap = characterSet;
    }

    public void writeText(String textString) throws IllegalArgumentException {
        this.writeText(textString, new ParametersLP());
    }

    public void writeText(String textString, ParametersLP parameters) throws IllegalArgumentException {
        if (textString == null) {
            throw new IllegalArgumentException("Parameter 'textString' was null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter 'parameters' was null.");
        }
        byte[] paramString = this.parameterString(parameters, Document.PrintingType.General);
        byte[] paramEndString = this.parameterEndString(parameters, Document.PrintingType.General);
        this.addToDoc(this.m_Document, paramString);
        this.addToDoc(this.m_Document, textString);
        this.addToDoc(this.m_Document, paramEndString);
        this.addToDoc(this.m_Document, EOL);
    }

    public void writeTextPartial(String textString) throws IllegalArgumentException {
        this.writeTextPartial(textString, new ParametersLP());
    }

    public void writeTextPartial(String textString, ParametersLP parameters) throws IllegalArgumentException {
        if (textString == null) {
            throw new IllegalArgumentException("Parameter 'textString' was null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter 'parameters' was null.");
        }
        byte[] paramString = this.parameterString(parameters, Document.PrintingType.General);
        byte[] paramEndString = this.parameterEndString(parameters, Document.PrintingType.General);
        this.addToDoc(this.m_Document, paramString);
        this.addToDoc(this.m_Document, textString);
        this.addToDoc(this.m_Document, paramEndString);
    }

    public void writeImage(BufferedImage imageObject, int printHeadWidth) throws IllegalArgumentException {
        if (imageObject == null) {
            throw new IllegalArgumentException("Parameter 'imageObject' was null.");
        }
        if (printHeadWidth < 1) {
            throw new IllegalArgumentException("Parameter 'printHeadWidth' must be greater than 0.");
        }
        int height = imageObject.getHeight();
        int width = imageObject.getWidth();
        byte blanklineCount = 0;
        byte[] dataline = new byte[printHeadWidth + 7 >> 3];
        int[] imageData = new int[height * width];
        imageObject.getRGB(0, 0, width, height, imageData, 0, width);
        this.addToDoc(this.m_Document, ESC + "B");
        for (int row = 0; row < height; ++row) {
            boolean blankLine = true;
            for (int index = 0; index < width; index += 8) {
                int currentByte = 0;
                int offset = row * width + index;
                if (index >= printHeadWidth) break;
                int value = index + 0 < width ? imageData[offset + 0] & 0xFFFFFF : 0xFFFFFF;
                boolean set = (value >> 0 & 0xFF) + (value >> 8 & 0xFF) + (value >> 16 & 0xFF) < 384;
                currentByte = (byte)(currentByte | (set ? -128 : 0));
                value = index + 1 < width ? imageData[offset + 1] & 0xFFFFFF : 0xFFFFFF;
                set = (value >> 0 & 0xFF) + (value >> 8 & 0xFF) + (value >> 16 & 0xFF) < 384;
                currentByte = (byte)(currentByte | (set ? 64 : 0));
                value = index + 2 < width ? imageData[offset + 2] & 0xFFFFFF : 0xFFFFFF;
                set = (value >> 0 & 0xFF) + (value >> 8 & 0xFF) + (value >> 16 & 0xFF) < 384;
                currentByte = (byte)(currentByte | (set ? 32 : 0));
                value = index + 3 < width ? imageData[offset + 3] & 0xFFFFFF : 0xFFFFFF;
                set = (value >> 0 & 0xFF) + (value >> 8 & 0xFF) + (value >> 16 & 0xFF) < 384;
                currentByte = (byte)(currentByte | (set ? 16 : 0));
                value = index + 4 < width ? imageData[offset + 4] & 0xFFFFFF : 0xFFFFFF;
                set = (value >> 0 & 0xFF) + (value >> 8 & 0xFF) + (value >> 16 & 0xFF) < 384;
                currentByte = (byte)(currentByte | (set ? 8 : 0));
                value = index + 5 < width ? imageData[offset + 5] & 0xFFFFFF : 0xFFFFFF;
                set = (value >> 0 & 0xFF) + (value >> 8 & 0xFF) + (value >> 16 & 0xFF) < 384;
                currentByte = (byte)(currentByte | (set ? 4 : 0));
                value = index + 6 < width ? imageData[offset + 6] & 0xFFFFFF : 0xFFFFFF;
                set = (value >> 0 & 0xFF) + (value >> 8 & 0xFF) + (value >> 16 & 0xFF) < 384;
                currentByte = (byte)(currentByte | (set ? 2 : 0));
                value = index + 7 < width ? imageData[offset + 7] & 0xFFFFFF : 0xFFFFFF;
                set = (value >> 0 & 0xFF) + (value >> 8 & 0xFF) + (value >> 16 & 0xFF) < 384;
                dataline[index >> 3] = currentByte = (int)((byte)(currentByte | (set ? 1 : 0)));
                blankLine &= currentByte == 0;
            }
            if (!blankLine) {
                if (blanklineCount > 0) {
                    this.addToDoc(this.m_Document, "A");
                    this.addToDoc(this.m_Document, blanklineCount);
                    blanklineCount = 0;
                }
                this.addToDoc(this.m_Document, this.compressGraphicLine(dataline));
                continue;
            }
            if ((blanklineCount = (byte)(blanklineCount + 1)) != 255) continue;
            this.addToDoc(this.m_Document, "A");
            this.addToDoc(this.m_Document, blanklineCount);
            blanklineCount = 0;
        }
        if (blanklineCount > 0) {
            this.addToDoc(this.m_Document, "A");
            this.addToDoc(this.m_Document, blanklineCount);
            blanklineCount = 0;
        }
        this.addToDoc(this.m_Document, ESC + "E");
    }

    private byte[] compressGraphicLine(byte[] dataline) {
        byte count = 0;
        byte currentByte = 0;
        ByteArrayOutputStream rleString = new ByteArrayOutputStream(128);
        this.addToDoc(rleString, "G");
        for (int index = 0; index < dataline.length; ++index) {
            if (count == 0) {
                currentByte = dataline[index];
                this.addToDoc(rleString, currentByte);
                count = (byte)(count + 1);
                continue;
            }
            if (count < 255 && currentByte == dataline[index]) {
                count = (byte)(count + 1);
                continue;
            }
            this.addToDoc(rleString, count);
            count = 0;
            currentByte = dataline[index];
            this.addToDoc(rleString, currentByte);
            count = (byte)(count + 1);
        }
        if (count > 0) {
            this.addToDoc(rleString, count);
        }
        if (rleString.size() > dataline.length + 1) {
            rleString.reset();
            this.addToDoc(rleString, "U");
            for (int item = 0; item < dataline.length; ++item) {
                this.addToDoc(rleString, dataline[item]);
            }
        }
        return rleString.toByteArray();
    }

    public void advanceToNextPage() {
        byte command = 12;
        this.addToDoc(this.m_Document, command);
    }

    public void advanceToQueueMark(int additionalRows) {
        if (additionalRows < 0 || additionalRows > 65535) {
            throw new IllegalArgumentException("Parameter 'additionalRows' must be an integer from 0 to 65535, a value of " + additionalRows + " was given.");
        }
        char bitH = (char)(additionalRows >> 8 & 0xFF);
        char bitL = (char)(additionalRows >> 0 & 0xFF);
        this.addToDoc(this.m_Document, ESC + "Q" + bitL + bitH);
    }

    private byte[] parameterString(ParametersLP parameters, Document.PrintingType type) {
        ByteArrayOutputStream paramData = new ByteArrayOutputStream(128);
        if (type == Document.PrintingType.General) {
            if (parameters.getFont() == "") {
                this.addToDoc(paramData, ESC + "w" + this.getDefaultFont());
            } else {
                this.addToDoc(paramData, ESC + "w" + parameters.getFont());
            }
        }
        if (parameters.getIsInverse()) {
            this.addToDoc(paramData, ESC + "I1");
        }
        if (parameters.getHorizontalMultiplier() == 2 || parameters.getVerticalMultiplier() == 2) {
            char bitField = '\u0000';
            bitField = (char)(bitField | (parameters.getHorizontalMultiplier() == 2 ? 32 : 0));
            bitField = (char)(bitField | (parameters.getVerticalMultiplier() == 2 ? 16 : 0));
            this.addToDoc(paramData, ESC + "!" + bitField);
        }
        return paramData.toByteArray();
    }

    private byte[] parameterEndString(ParametersLP parameters, Document.PrintingType type) {
        ByteArrayOutputStream paramData = new ByteArrayOutputStream(128);
        if (parameters.getIsInverse()) {
            this.addToDoc(paramData, ESC + "I0");
        }
        if (parameters.getHorizontalMultiplier() == 2 || parameters.getVerticalMultiplier() == 2) {
            this.addToDoc(paramData, ESC + "!\u0000");
        }
        return paramData.toByteArray();
    }

    @Override
    public byte[] getDocumentData() {
        char commandValue;
        ByteArrayOutputStream dataStream = new ByteArrayOutputStream();
        String globalsStart = "";
        String globalsEnd = "";
        if (this.getPageLength() != 0) {
            commandValue = (char)this.getPageLength();
            globalsStart = globalsStart + ESC + "w" + this.getDefaultFont();
            globalsStart = globalsStart + ESC + "C" + commandValue;
        }
        if (this.getLineSpacing() != 0) {
            commandValue = (char)this.getLineSpacing();
            globalsStart = globalsStart + ESC + "A" + commandValue;
        }
        if (this.getCharacterRemap() != CharacterSet.USA) {
            commandValue = (char)(this.getCharacterRemap().value() - 48);
            globalsStart = globalsStart + ESC + "R" + commandValue;
        }
        if (this.getIsLandscapeMode()) {
            commandValue = '\u00b3';
            globalsStart = globalsStart + ESC + "L";
            globalsEnd = globalsEnd + ESC + "" + commandValue;
        }
        globalsEnd = globalsEnd + ESC + "@";
        this.addToDoc(dataStream, ESC + "EZ{}{LP}" + globalsStart);
        this.addToDoc(dataStream, this.m_Document.toByteArray());
        this.addToDoc(dataStream, globalsEnd);
        return dataStream.toByteArray();
    }

    public static enum CharacterSet {
        USA('0', "USA"),
        France('1', "France"),
        Germany('2', "Germany"),
        UK('3', "UK"),
        Denmark('4', "Denmark"),
        Sweden('5', "Sweden"),
        Italy('6', "Italy"),
        Spain('7', "Spain");

        private final char m_Value;
        private final String m_Name;

        private CharacterSet(char value, String name) {
            this.m_Value = value;
            this.m_Name = name;
        }

        public char value() {
            return this.m_Value;
        }

        public String named() {
            return this.m_Name;
        }
    }
}

