/*
 * Decompiled with CFR 0.152.
 */
package datamaxoneil.printer;

import datamaxoneil.printer.Document;
import datamaxoneil.printer.ParametersEZ;
import java.io.ByteArrayOutputStream;

public class DocumentEZ
extends Document {
    private int m_InitialPaperBack = 0;
    private int m_PageLength = 0;
    private int m_PrintQuantity = 1;
    private boolean m_PrintOptimize = false;
    private QStop m_QMarkMode = QStop.Default;
    private int m_QMarkDotLines = 0;

    public DocumentEZ(String fontName) throws IllegalArgumentException {
        this.m_FontNameLength = 5;
        this.setDefaultFont(fontName);
    }

    public int getInitialPaperBackup() {
        return this.m_InitialPaperBack;
    }

    public void setInitialPaperBackup(int dotLines) throws IllegalArgumentException {
        if (dotLines < 0 || dotLines > 8192) {
            throw new IllegalArgumentException("Parameter 'dotLines' must be from 0 to 8192, a value of " + dotLines + " was given.");
        }
        this.m_InitialPaperBack = dotLines;
    }

    public int getPageLength() {
        return this.m_PageLength;
    }

    public void setPageLength(int dotLines) throws IllegalArgumentException {
        if (dotLines < 0 || dotLines > 8192) {
            throw new IllegalArgumentException("Parameter 'dotLines' must be from 0 to 8192, a value of " + dotLines + " was given.");
        }
        this.m_PageLength = dotLines;
    }

    public int getPrintQuantity() {
        return this.m_PrintQuantity;
    }

    public boolean getPrintQuantityOptimized() {
        return this.m_PrintOptimize;
    }

    public void setPrintQuantity(int quantity) throws IllegalArgumentException {
        if (quantity < 1 || quantity > 255) {
            throw new IllegalArgumentException("Parameter 'quantity' must be from 1 to 255, a value of " + quantity + " was given.");
        }
        this.m_PrintQuantity = quantity;
    }

    public void setPrintQuantityOptimized(boolean optimize) {
        this.m_PrintOptimize = optimize;
    }

    public int getQMarkDotLines() {
        return this.m_QMarkDotLines;
    }

    public QStop getQMarkStop() {
        return this.m_QMarkMode;
    }

    public void setQMarkStop(QStop mode) throws IllegalArgumentException {
        if (mode == null) {
            throw new IllegalArgumentException("Parameter 'mode' cannot be null.");
        }
        this.m_QMarkMode = mode;
    }

    public void setQMarkDotLines(int dotLines) throws IllegalArgumentException {
        if (dotLines < 0 || dotLines > 8192) {
            throw new IllegalArgumentException("Parameter 'dotLines' must be from 0 to 8192, a value of " + dotLines + " was given.");
        }
        this.m_QMarkDotLines = dotLines;
    }

    public void writeText(String textString, int row, int col) throws IllegalArgumentException {
        this.writeText(textString, row, col, new ParametersEZ());
    }

    public void writeText(String textString, int row, int col, ParametersEZ parameters) throws IllegalArgumentException {
        this.validatePosition(row, col);
        if (textString == null) {
            throw new IllegalArgumentException("Parameter 'textString' was null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter 'parameters' was null.");
        }
        byte[] paramData = this.parameterString(parameters, Document.PrintingType.General);
        this.addToDoc(this.m_Document, "@" + row + "," + col + ":");
        this.addToDoc(this.m_Document, paramData);
        this.addToDoc(this.m_Document, "|" + textString + "|");
        this.addToDoc(this.m_Document, EOL);
    }

    public void writeHorizontalLine(int row, int col, int length, int thickness) throws IllegalArgumentException {
        this.writeHorizontalLine(row, col, length, thickness, new ParametersEZ());
    }

    public void writeHorizontalLine(int row, int col, int length, int thickness, ParametersEZ parameters) throws IllegalArgumentException {
        int l = length;
        int t = thickness;
        this.validatePosition(row, col);
        if (length < 1 || length > 8192) {
            throw new IllegalArgumentException("Parameter 'length' must be an integer from 1 to 8192, a value of " + length + " was given.");
        }
        if (thickness < 1 || thickness > 8192) {
            throw new IllegalArgumentException("Parameter 'thickness' must be an integer from 1 to 8192, a value of " + thickness + " was given.");
        }
        byte[] paramData = this.parameterString(parameters, Document.PrintingType.Line);
        this.addToDoc(this.m_Document, "@" + row + "," + col);
        this.addToDoc(this.m_Document, ":HLINE,L" + l + ",T" + t);
        this.addToDoc(this.m_Document, paramData);
        this.addToDoc(this.m_Document, "|");
        this.addToDoc(this.m_Document, EOL);
    }

    public void writeVerticalLine(int row, int col, int length, int thickness) throws IllegalArgumentException {
        this.writeVerticalLine(row, col, length, thickness, new ParametersEZ());
    }

    public void writeVerticalLine(int row, int col, int length, int thickness, ParametersEZ parameters) throws IllegalArgumentException {
        int l = length;
        int t = thickness;
        this.validatePosition(row, col);
        if (length < 1 || length > 8192) {
            throw new IllegalArgumentException("Parameter 'length' must be an integer from 1 to 8192, a value of " + length + " was given.");
        }
        if (thickness < 1 || thickness > 8192) {
            throw new IllegalArgumentException("Parameter 'thickness' must be an integer from 1 to 8192, a value of " + thickness + " was given.");
        }
        byte[] paramData = this.parameterString(parameters, Document.PrintingType.Line);
        this.addToDoc(this.m_Document, "@" + row + "," + col);
        this.addToDoc(this.m_Document, ":VLINE,L" + l + ",T" + t);
        this.addToDoc(this.m_Document, paramData);
        this.addToDoc(this.m_Document, "|");
        this.addToDoc(this.m_Document, EOL);
    }

    public void writeBarCode(String bcFont, String textString, int row, int col) throws IllegalArgumentException {
        ParametersEZ paramEZ = new ParametersEZ();
        paramEZ.setHorizontalMultiplier(2);
        paramEZ.setVerticalMultiplier(10);
        this.writeBarCode(bcFont, textString, row, col, paramEZ);
    }

    public void writeBarCode(String bcFont, String textString, int row, int col, ParametersEZ parameters) throws IllegalArgumentException {
        this.validatePosition(row, col);
        if (bcFont == null || bcFont.length() != this.m_FontNameLength) {
            throw new IllegalArgumentException("Parameter 'bcFont' must be " + this.m_FontNameLength + " characters in length.");
        }
        if (textString == null) {
            throw new IllegalArgumentException("Parameter 'textString' was null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter 'parameters' was null.");
        }
        byte[] paramData = this.parameterString(parameters, Document.PrintingType.Barcode);
        this.addToDoc(this.m_Document, "@" + row + "," + col + ":" + bcFont);
        this.addToDoc(this.m_Document, paramData);
        this.addToDoc(this.m_Document, "|" + textString + "|");
        this.addToDoc(this.m_Document, EOL);
    }

    public void writeBarCodePDF417(String textString, int row, int col, int dataColumns, int redundancyLevel) throws IllegalArgumentException {
        ParametersEZ paramEZ = new ParametersEZ();
        paramEZ.setHorizontalMultiplier(2);
        paramEZ.setVerticalMultiplier(10);
        this.writeBarCodePDF417(textString, row, col, dataColumns, redundancyLevel, paramEZ);
    }

    public void writeBarCodePDF417(String textString, int row, int col, int dataColumns, int redundancyLevel, ParametersEZ parameters) throws IllegalArgumentException {
        this.validatePosition(row, col);
        if (textString == null) {
            throw new IllegalArgumentException("Parameter 'textString' was null.");
        }
        if (dataColumns < 1 || dataColumns > 255) {
            throw new IllegalArgumentException("Parameter 'dataColumns' must be a positive integer from 1 to 255, a value of " + dataColumns + " was given.");
        }
        if (redundancyLevel < 1 || redundancyLevel > 8) {
            throw new IllegalArgumentException("Parameter 'redundancyLevel' must be an integer from 1 to 8, a value of " + redundancyLevel + " was given.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter 'parameters' was null.");
        }
        byte[] paramData = this.parameterString(parameters, Document.PrintingType.Barcode417);
        this.addToDoc(this.m_Document, "@" + row + "," + col);
        this.addToDoc(this.m_Document, ":PD417,COLUMNS" + dataColumns + ",SECURITY" + redundancyLevel);
        this.addToDoc(this.m_Document, paramData);
        this.addToDoc(this.m_Document, "|");
        this.addToDoc(this.m_Document, textString);
        this.addToDoc(this.m_Document, "|");
        this.addToDoc(this.m_Document, EOL);
    }

    public void writeImage(String imageName, int row, int col) throws IllegalArgumentException {
        this.writeImage(imageName, row, col, new ParametersEZ());
    }

    public void writeImage(String imageName, int row, int col, ParametersEZ parameters) throws IllegalArgumentException {
        this.validatePosition(row, col);
        if (imageName == null) {
            throw new IllegalArgumentException("Parameter 'imageName' was null.");
        }
        if (imageName.length() == 0) {
            throw new IllegalArgumentException("Parameter 'imageName' can not be the empty string.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter 'parameters' was null.");
        }
        byte[] paramData = this.parameterString(parameters, Document.PrintingType.Image);
        this.addToDoc(this.m_Document, "@" + row + "," + col + ":" + imageName);
        this.addToDoc(this.m_Document, paramData);
        this.addToDoc(this.m_Document, "|");
        this.addToDoc(this.m_Document, EOL);
    }

    public void writeInverseRegion(int row, int col, int width, int height) throws IllegalArgumentException {
        this.writeInverseRegion(row, col, width, height, new ParametersEZ());
    }

    public void writeInverseRegion(int row, int col, int width, int height, ParametersEZ parameters) throws IllegalArgumentException {
        int l = width;
        int t = height;
        this.validatePosition(row, col);
        if (width < 1 || width > 8192) {
            throw new IllegalArgumentException("Parameter 'width' must be an integer from 1 to 8192, a value of " + width + " was given.");
        }
        if (height < 1 || height > 8192) {
            throw new IllegalArgumentException("Parameter 'height' must be an integer from 1 to 8192, a value of " + height + " was given.");
        }
        byte[] paramData = this.parameterString(parameters, Document.PrintingType.Line);
        this.addToDoc(this.m_Document, "@" + row + "," + col);
        this.addToDoc(this.m_Document, ":INVRS,L" + l + ",T" + t);
        this.addToDoc(this.m_Document, paramData);
        this.addToDoc(this.m_Document, "|");
        this.addToDoc(this.m_Document, EOL);
    }

    private void validatePosition(int row, int col) throws IllegalArgumentException {
        if (row < 0 || row > 8192) {
            throw new IllegalArgumentException("Parameter 'row' must be an integer from 0 to 8192, a value of " + row + " was given.");
        }
        if (col < 0 || col > 8192) {
            throw new IllegalArgumentException("Parameter 'col' must be an integer from 0 to 8192, a value of " + col + " was given.");
        }
    }

    private byte[] parameterString(ParametersEZ parameters, Document.PrintingType type) {
        ByteArrayOutputStream paramData = new ByteArrayOutputStream(128);
        if (type == Document.PrintingType.General) {
            if (parameters.getFont() == "") {
                this.addToDoc(paramData, this.getDefaultFont());
            } else {
                this.addToDoc(paramData, parameters.getFont());
            }
        }
        if ((type == Document.PrintingType.General || type == Document.PrintingType.Line || type == Document.PrintingType.Image) && parameters.getIsInverse()) {
            this.addToDoc(paramData, ",I");
        }
        if (parameters.getRotate() == ParametersEZ.Rotation.Rotate_90) {
            this.addToDoc(paramData, ",ROT90");
        } else if (parameters.getRotate() == ParametersEZ.Rotation.Rotate_180) {
            this.addToDoc(paramData, ",ROT180");
        } else if (parameters.getRotate() == ParametersEZ.Rotation.Rotate_270) {
            this.addToDoc(paramData, ",ROT270");
        }
        if (parameters.getAlignment() == ParametersEZ.Alignment.Center) {
            this.addToDoc(paramData, ",CENTER");
        } else if (parameters.getAlignment() == ParametersEZ.Alignment.Right) {
            this.addToDoc(paramData, ",RIGHT");
        }
        if (type == Document.PrintingType.General || type == Document.PrintingType.Line || type == Document.PrintingType.Image) {
            if (parameters.getHorizontalMultiplier() != 1) {
                this.addToDoc(paramData, ",HM" + parameters.getHorizontalMultiplier());
            }
            if (parameters.getVerticalMultiplier() != 1) {
                this.addToDoc(paramData, ",VM" + parameters.getVerticalMultiplier());
            }
        } else if (type == Document.PrintingType.Barcode) {
            if (parameters.getHorizontalMultiplier() != 1) {
                this.addToDoc(paramData, ",W" + parameters.getHorizontalMultiplier());
            }
            if (parameters.getVerticalMultiplier() != 1) {
                this.addToDoc(paramData, ",H" + parameters.getVerticalMultiplier());
            }
        } else if (type == Document.PrintingType.Barcode417) {
            this.addToDoc(paramData, ",XDIM" + parameters.getHorizontalMultiplier());
            this.addToDoc(paramData, ",YDIM" + parameters.getVerticalMultiplier());
        }
        return paramData.toByteArray();
    }

    @Override
    public byte[] getDocumentData() {
        String globals = "";
        ByteArrayOutputStream dataStream = new ByteArrayOutputStream();
        if (this.getInitialPaperBackup() > 0) {
            globals = globals + ",BACK" + this.getInitialPaperBackup();
        }
        if (this.getQMarkStop() == QStop.Front) {
            globals = globals + ",QSTOPT" + this.getQMarkDotLines();
        } else if (this.getQMarkStop() == QStop.Back) {
            globals = globals + ",QSTOPB" + this.getQMarkDotLines();
        } else if (this.getQMarkStop() == QStop.Gap) {
            globals = globals + ",QSTOPG" + this.getQMarkDotLines();
        } else if (this.getQMarkStop() == QStop.None) {
            globals = globals + ",QSTOPN";
        }
        if (this.getPrintQuantity() != 1 && this.getPrintQuantityOptimized()) {
            globals = globals + ",QUANTITY" + this.getPrintQuantity();
        } else if (this.getPrintQuantity() != 1 && !this.getPrintQuantityOptimized()) {
            globals = globals + ",QUANTITYNOPT" + this.getPrintQuantity();
        }
        if (this.getIsLandscapeMode()) {
            globals = globals + ",ROT270";
        }
        if (this.getPageLength() != 0) {
            globals = globals + ",STOP" + this.getPageLength();
        }
        this.addToDoc(dataStream, ESC + "EZ{PRINT" + globals + ":\r\n");
        this.addToDoc(dataStream, this.m_Document.toByteArray());
        this.addToDoc(dataStream, "}\r\n");
        return dataStream.toByteArray();
    }

    public static enum QStop {
        Default,
        Front,
        Back,
        Gap,
        None;

    }
}

