/*
 * Decompiled with CFR 0.152.
 */
package datamaxoneil.printer;

import datamaxoneil.printer.Document;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import javax.imageio.ImageIO;

public class DocumentEXPCL
extends Document {
    private PrinterModel m_printerModel = PrinterModel.APEX3;

    public void writeImage(String fileName) {
        try {
            BufferedImage imageObject = ImageIO.read(new File(fileName));
            int height = imageObject.getHeight();
            int width = imageObject.getWidth();
            int printHeadWidth = 0;
            PrinterModel printerModel = this.getPrinterModel();
            switch (printerModel) {
                case APEX2: {
                    printHeadWidth = 384;
                    break;
                }
                case APEX3: {
                    printHeadWidth = 576;
                    break;
                }
                case APEX4: {
                    printHeadWidth = 832;
                }
            }
            byte[] graphicCommand = new byte[]{(byte)ESC, 86, (byte)height, 0};
            this.addToDoc(this.m_Document, graphicCommand);
            byte[] dataline = new byte[printHeadWidth + 7 >> 3];
            int[] imageData = new int[height * width];
            imageObject.getRGB(0, 0, width, height, imageData, 0, width);
            for (int row = 0; row < height; ++row) {
                for (int index = 0; index < width; index += 8) {
                    int currentByte = 0;
                    int offset = row * width + index;
                    if (index >= printHeadWidth) break;
                    int value = index + 0 < width ? imageData[offset + 0] & 0xFFFFFF : 0xFFFFFF;
                    boolean set = (value >> 0 & 0xFF) + (value >> 8 & 0xFF) + (value >> 16 & 0xFF) < 384;
                    currentByte = (byte)(currentByte | (set ? -128 : 0));
                    value = index + 1 < width ? imageData[offset + 1] & 0xFFFFFF : 0xFFFFFF;
                    set = (value >> 0 & 0xFF) + (value >> 8 & 0xFF) + (value >> 16 & 0xFF) < 384;
                    currentByte = (byte)(currentByte | (set ? 64 : 0));
                    value = index + 2 < width ? imageData[offset + 2] & 0xFFFFFF : 0xFFFFFF;
                    set = (value >> 0 & 0xFF) + (value >> 8 & 0xFF) + (value >> 16 & 0xFF) < 384;
                    currentByte = (byte)(currentByte | (set ? 32 : 0));
                    value = index + 3 < width ? imageData[offset + 3] & 0xFFFFFF : 0xFFFFFF;
                    set = (value >> 0 & 0xFF) + (value >> 8 & 0xFF) + (value >> 16 & 0xFF) < 384;
                    currentByte = (byte)(currentByte | (set ? 16 : 0));
                    value = index + 4 < width ? imageData[offset + 4] & 0xFFFFFF : 0xFFFFFF;
                    set = (value >> 0 & 0xFF) + (value >> 8 & 0xFF) + (value >> 16 & 0xFF) < 384;
                    currentByte = (byte)(currentByte | (set ? 8 : 0));
                    value = index + 5 < width ? imageData[offset + 5] & 0xFFFFFF : 0xFFFFFF;
                    set = (value >> 0 & 0xFF) + (value >> 8 & 0xFF) + (value >> 16 & 0xFF) < 384;
                    currentByte = (byte)(currentByte | (set ? 4 : 0));
                    value = index + 6 < width ? imageData[offset + 6] & 0xFFFFFF : 0xFFFFFF;
                    set = (value >> 0 & 0xFF) + (value >> 8 & 0xFF) + (value >> 16 & 0xFF) < 384;
                    currentByte = (byte)(currentByte | (set ? 2 : 0));
                    value = index + 7 < width ? imageData[offset + 7] & 0xFFFFFF : 0xFFFFFF;
                    set = (value >> 0 & 0xFF) + (value >> 8 & 0xFF) + (value >> 16 & 0xFF) < 384;
                    dataline[index >> 3] = currentByte = (int)((byte)(currentByte | (set ? 1 : 0)));
                }
                this.addToDoc(this.m_Document, dataline);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public byte[] getDocumentData() {
        ByteArrayOutputStream dataStream = new ByteArrayOutputStream();
        this.addToDoc(dataStream, this.m_Document.toByteArray());
        return dataStream.toByteArray();
    }

    public PrinterModel getPrinterModel() {
        return this.m_printerModel;
    }

    public void setPrinterModel(PrinterModel printerModel) {
        this.m_printerModel = printerModel;
    }

    public static enum PrinterModel {
        APEX2,
        APEX3,
        APEX4;

    }
}

