/*
 * Decompiled with CFR 0.152.
 */
package datamaxoneil.printer;

import datamaxoneil.printer.Document;
import datamaxoneil.printer.MonoBitmapConverter;
import datamaxoneil.printer.ParametersDPL;
import datamaxoneil.printer.UPSMessage;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import javax.imageio.ImageIO;

public class DocumentDPL
extends Document {
    public static char GS = (char)29;
    public static char RS = (char)30;
    public static char EOT = (char)4;
    private int m_RowOffset = 0;
    private int m_ColumnOffset = 0;
    private int m_DotWidthMultiplier = 1;
    private int m_DotHeightMultiplier = 1;
    private int m_HeatSettings = 10;
    private int m_PrintQuantity;
    private Label_Format m_LabelFormat = Label_Format.XOR_Mode;

    public Label_Format getLabelFormat() {
        return this.m_LabelFormat;
    }

    public void setLabelFormat(Label_Format value) {
        this.m_LabelFormat = value;
    }

    public int getColumnOffset() {
        return this.m_ColumnOffset;
    }

    public void setColumnOffset(int offset) {
        if (offset < 0 || offset > 9999) {
            throw new IllegalArgumentException(String.format("Parameter 'columnOffset' must be from 0 - 9999, a value of %1$s was given.", offset));
        }
        this.m_ColumnOffset = offset;
    }

    public int getRowOffset() {
        return this.m_RowOffset;
    }

    public void setRowOffset(int value) {
        if (value < 0 || value > 9999) {
            throw new IllegalArgumentException(String.format("Parameter 'rowOffset' must be from 0 - 9999, a value of %1$s was given.", value));
        }
        this.m_RowOffset = value;
    }

    public int getDotWidthMultiplier() {
        return this.m_DotWidthMultiplier;
    }

    public void setDotWidthMultiplier(int value) {
        if (value < 1 || value > 2) {
            throw new IllegalArgumentException(String.format("Parameter 'dot-width-multiplier' must be from 1 to 2, a value of %1$s was given.", value));
        }
    }

    public int getDotHeightMultiplier() {
        return this.m_DotHeightMultiplier;
    }

    public void setDotHeightMultiplier(int value) {
        if (value < 1 || value > 3) {
            throw new IllegalArgumentException(String.format("Parameter 'dot-height-multiplier' must be from 1 to 3, a value of %1$s was given.", value));
        }
        this.m_DotHeightMultiplier = value;
    }

    public int getHeatSettings() {
        return this.m_HeatSettings;
    }

    public void setHeatSettings(int value) {
        if (value < 0 || value > 30) {
            throw new IllegalArgumentException(String.format("Parameter 'heat settings' must be from 0 to 30, a value of %1$s was given.", value));
        }
        this.m_HeatSettings = value;
    }

    public int getPrintQuantity() {
        return this.m_PrintQuantity;
    }

    public void setPrintQuantity(int value) {
        if (value < 1 || value > 255) {
            throw new IllegalArgumentException(String.format("Parameter 'quantity' must be from 1 to 255, a value of %1$s was given.", value));
        }
        this.m_PrintQuantity = value;
    }

    public void writeTextInternalBitmapped(String textString, int fontID, int row, int col) {
        ParametersDPL parameters = new ParametersDPL();
        parameters.setFont("000");
        if (fontID < 0 || fontID > 8) {
            throw new IllegalArgumentException(String.format("Parameter 'font-id' must be between 0 - 8. Value given was %1$s", fontID));
        }
        parameters.setTypeID(Integer.toString(fontID));
        this.writeText(textString, row, col, parameters.getTypeID(), Font_Type.InternalBitmapped, parameters);
    }

    public void writeTextScalable(String textString, String fontID, int row, int col) {
        ParametersDPL parameters = new ParametersDPL();
        parameters.setIsDotMode(false);
        parameters.setIsUnicode(false);
        parameters.setFontHeight(12);
        parameters.setFontWidth(12);
        this.writeTextScalable(textString, fontID, row, col, parameters);
    }

    public void writeTextScalable(String textString, String fontID, int row, int col, ParametersDPL parameters) {
        parameters.setFont(fontID);
        if (parameters.getFontHeight() != 0 && parameters.getFontWidth() != 0) {
            if (!parameters.getIsDotMode()) {
                if (parameters.getFontHeight() < 4 && parameters.getFontHeight() > 999) {
                    throw new IllegalArgumentException(String.format("Parameter 'fontHeight' must be between 4 - 999 for points unit. Value given was %1$s", parameters.getFontHeight()));
                }
                if (parameters.getFontWidth() < 4 && parameters.getFontWidth() > 999) {
                    throw new IllegalArgumentException(String.format("Parameter 'fontWidth' must be between 4 - 999 for points unit. Value given was %1$s", parameters.getFontWidth()));
                }
                textString = "P" + String.format("%03d", parameters.getFontHeight()) + "P" + String.format("%03d", parameters.getFontWidth()) + textString;
            } else {
                if (parameters.getFontHeight() < 14 && parameters.getFontHeight() > 4163) {
                    throw new IllegalArgumentException(String.format("Parameter 'fontHeight' must be between 14 - 4163 for points unit. Value given was %1$s", parameters.getFontHeight()));
                }
                if (parameters.getFontWidth() < 16 && parameters.getFontWidth() > 4163) {
                    throw new IllegalArgumentException(String.format("Parameter 'fontWidth' must be between 16 - 4163 for points unit. Value given was %1$s", parameters.getFontWidth()));
                }
                textString = String.format("%04d", parameters.getFontHeight()) + String.format("%04d", parameters.getFontWidth()) + textString;
            }
        }
        this.writeText(textString, row, col, "9", Font_Type.Scalable, parameters);
    }

    public void writeText(String textString, int row, int col, String fontIDType, Font_Type fontType, ParametersDPL parameters) {
        this.ValidatePosition(row, col);
        if (textString == null) {
            throw new IllegalArgumentException("Parameter 'textString' was null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter 'parameters' was null.");
        }
        byte[] tempArray = this.parameterString(fontIDType, parameters, Document.PrintingType.General);
        this.addToDoc(this.m_Document, tempArray);
        this.addToDoc(this.m_Document, String.format("%04d", row) + String.format("%04d", col));
        this.addToDoc(this.m_Document, textString);
        this.addToDoc(this.m_Document, EOL);
    }

    public void writeBarCode(String barcodeID, String textString, int row, int col) {
        ParametersDPL parameters = new ParametersDPL();
        parameters.setWideBarWidth(0);
        parameters.setNarrowBarWidth(0);
        parameters.setSymbolHeight(0);
        this.writeBarCode(barcodeID, textString, row, col, parameters);
    }

    public void writeBarCodeUPSMaxiCode(int mode, UPSMessage message, int row, int col, ParametersDPL parameters) {
        if (mode != 2 && mode != 3) {
            throw new IllegalArgumentException("Parameter 'mode' must be either 2 or 3. Value given was " + mode);
        }
        String textString = "#" + Integer.valueOf(mode).toString() + "[)>" + RS + "01" + GS + "96";
        if (mode == 2) {
            if (message.getZipCode().length() != 5 && message.getZipCode().length() != 9) {
                throw new RuntimeException("Zip code provided for Mode 2 (US) must be 5 or 9 digits.");
            }
            textString = textString + DocumentDPL.rightPad(message.getZipCode(), 9, '0') + GS;
            if (message.getCountryCode() != 840) {
                throw new RuntimeException("Country Code provided for Mode 2 (US) must be 840");
            }
            textString = textString + String.format("%03d", message.getCountryCode()) + GS;
        } else if (mode == 3) {
            if (message.getZipCode().length() != 6) {
                throw new RuntimeException("Zip code provided for Mode 3 (International) must be 6 characters in length.");
            }
            textString = textString + message.getZipCode() + GS;
            if (message.getCountryCode() == 840) {
                throw new RuntimeException("Country Code provided for Mode 3 (International) cannot be 840");
            }
            textString = textString + String.format("%03d", message.getCountryCode()) + GS;
        }
        textString = textString + String.format("%03d", message.getClassOfService()) + GS + message.getTrackingNumber() + GS + message.getSCAC() + GS + message.getShipperNumber() + GS + String.format("%03d", message.getJulianPickupDay()) + GS + message.getShipmentID() + GS + Integer.valueOf(message.getCurrentPackage()).toString() + "/" + Integer.valueOf(message.getTotalPackage()).toString() + GS + Integer.valueOf(message.getPackageWeight()).toString() + GS + (message.getValidateAddress() ? "Y" : "N") + GS + message.getShipToAddr() + GS + message.getShipToCity() + GS + message.getShipToState() + RS + EOT;
        this.writeBarCode("u", textString, row, col, parameters);
    }

    public void writeBarCodePDF417(String textString, boolean isTruncated, int securityLevel, int aspectRatio, int dataRows, int dataCols, int row, int col, ParametersDPL parameters) {
        if (securityLevel < 0 || securityLevel > 8) {
            throw new IllegalArgumentException("Parameter 'securityLevel' must be between 0-8. Value given was " + Integer.valueOf(securityLevel).toString());
        }
        if (aspectRatio < 0 || aspectRatio > 99) {
            throw new IllegalArgumentException("Parameter 'aspectRatio' must be between 0-99. Value given was " + Integer.valueOf(aspectRatio).toString());
        }
        if (dataRows < 0 || dataRows > 99) {
            throw new IllegalArgumentException("Parameter 'dataRows' must be between 0-99. Value given was " + Integer.valueOf(dataRows).toString());
        }
        if (dataCols < 0 || dataCols > 99) {
            throw new IllegalArgumentException("Parameter 'dataCols' must be between 0-99. Value given was " + Integer.valueOf(dataCols).toString());
        }
        String newTextString = (isTruncated ? "T" : "F") + Integer.valueOf(securityLevel).toString() + String.format("%02d", aspectRatio);
        newTextString = newTextString + (dataRows == 0 ? String.format("%02d", 0) : (dataRows < 3 ? String.format("%02d", 3) : (dataRows > 90 ? String.format("%02d", 90) : String.format("%02d", dataRows))));
        newTextString = newTextString + (dataCols == 0 ? String.format("%02d", 0) : (dataCols > 30 ? String.format("%02d", 30) : String.format("%02d", dataCols))) + textString;
        this.writeBarCode("z", newTextString, row, col, parameters);
    }

    public void writeBarCodeDataMatrix(String textString, int correctionLevel, int digitFormatID, int rowsRequested, int colsRequested, int row, int col, ParametersDPL parameters) {
        parameters.setSymbolHeight(0);
        if (correctionLevel < 0 || correctionLevel > 200) {
            throw new IllegalArgumentException("Parameter 'correctionLevel' must be between 0-200. Value given was " + Integer.valueOf(correctionLevel).toString());
        }
        if (digitFormatID < 0 || digitFormatID > 6) {
            throw new IllegalArgumentException("Parameter 'digitFormatID' must be between 0-6. Value given was " + Integer.valueOf(digitFormatID).toString());
        }
        if (rowsRequested != 0 && (rowsRequested < 9 || rowsRequested > 144)) {
            throw new IllegalArgumentException("Parameter 'rowsRequested' must be 0 or between 9-144. Value given was " + Integer.valueOf(rowsRequested).toString());
        }
        if (colsRequested != 0 && (colsRequested < 9 || colsRequested > 144)) {
            throw new IllegalArgumentException("Parameter 'colsRequested' must be 0 or between 9-144. Value given was " + Integer.valueOf(colsRequested).toString());
        }
        this.writeBarCode("W1c", String.format("%03d", correctionLevel) + (correctionLevel == 200 ? "0" : Integer.valueOf(digitFormatID).toString()) + String.format("%03d", rowsRequested) + String.format("%03d", colsRequested) + textString, row, col, parameters);
    }

    public void writeBarCodeQRCode(String textString, boolean autoFormatting, int QRCodeModel, String correctionLevel, String maskNumber, String inputMode, String charMode, int row, int col, ParametersDPL parameters) {
        parameters.setSymbolHeight(0);
        if (autoFormatting) {
            this.writeBarCode("W1d", textString + "\r", row, col, parameters);
        } else {
            if (QRCodeModel != 1 && QRCodeModel != 2) {
                throw new IllegalArgumentException("Parameter 'QRCodeModel' must be 1 or 2.Value given was " + Integer.valueOf(QRCodeModel).toString());
            }
            if (!(correctionLevel.equals("H") || correctionLevel.equals("Q") || correctionLevel.equals("M") || correctionLevel.equals("L"))) {
                throw new IllegalArgumentException("Parameter 'correctionLevel' must be H,Q,M, or L. Value given was " + correctionLevel);
            }
            if (!Document.matches(maskNumber, "^[0-8]{1}$") && !maskNumber.equals("")) {
                throw new IllegalArgumentException("Parameter 'Mask Number' must be between 0-8 or blank. Value given was " + maskNumber.toString());
            }
            if (!(inputMode.equals("A") || inputMode.equals("a") || inputMode.equals("M") || inputMode.equals("m"))) {
                throw new IllegalArgumentException("Parameter 'inputMode' must be A,a,M, or m. Value given was " + inputMode);
            }
            if (!(charMode.equals("N") || charMode.equals("A") || charMode.equals("B") || charMode.equals("K"))) {
                throw new IllegalArgumentException("Parameter 'charMode' must be N,A,B, or K. Value given was " + charMode);
            }
            this.writeBarCode("W1D", Integer.valueOf(QRCodeModel).toString() + ',' + correctionLevel + maskNumber.toString() + inputMode + ',' + charMode + textString, row, col, parameters);
        }
    }

    public void writeBarCodeAztec(String textString, int textLength, boolean ECIMode, int errorCorrection, int row, int col, ParametersDPL parameters) {
        parameters.setSymbolHeight(0);
        if (textLength < 0 || textLength > 9999) {
            throw new IllegalArgumentException("Parameter 'textLength' must be between 0-9999. Value given was " + Integer.valueOf(textLength).toString());
        }
        if (errorCorrection < 0 || errorCorrection > 300) {
            throw new IllegalArgumentException("Parameter 'errorCorrection' must be between 0-300. Value given was " + Integer.valueOf(errorCorrection).toString());
        }
        this.writeBarCode("W1f", String.format("%04d", textLength) + (ECIMode ? Integer.valueOf(1).toString() : Integer.valueOf(0).toString()) + String.format("%03d", errorCorrection) + textString, row, col, parameters);
    }

    public void writeGS1DataBar(String textString, String barCodeData, String GS1Type, int pixelMultiplier, int xPixelUndercut, int yPixelUndercut, int segmentsPerRow, int row, int col, ParametersDPL parameters) {
        parameters.setSymbolHeight(0);
        if (!(GS1Type.equals("E") || GS1Type.equals("R") || GS1Type.equals("T") || GS1Type.equals("S") || GS1Type.equals("D") || GS1Type.equals("L"))) {
            throw new IllegalArgumentException("Parameter 'GS1Type' must be E,R,T,S,D, or L. Value given was " + GS1Type);
        }
        if (pixelMultiplier < 1 || pixelMultiplier > 9) {
            throw new IllegalArgumentException("Parameter 'pixelMultiplier' must be between 1-9. Value given was " + Integer.valueOf(pixelMultiplier).toString());
        }
        if (xPixelUndercut < 0 || xPixelUndercut > pixelMultiplier - 1) {
            throw new IllegalArgumentException("Parameter 'xPixelUndercut' must be between 0 and pixelMultiplier value. Value given was " + Integer.valueOf(xPixelUndercut).toString());
        }
        if (yPixelUndercut < 0 || yPixelUndercut > pixelMultiplier - 1) {
            throw new IllegalArgumentException("Parameter 'yPixelUndercut' must be between 0 and pixelMultiplier value. Value given was " + Integer.valueOf(yPixelUndercut).toString());
        }
        if (GS1Type.equals("E")) {
            if (!Document.matches(barCodeData, "^[a-zA-Z0-9!%&\\?'\"\\-\\./,:;<=>_ ]*$")) {
                throw new IllegalArgumentException("Parameter 'barcodeData' must contain only alphanumeric characters or the following special characters: !%&?'\"-.,;:<=>_ . Value given was " + barCodeData);
            }
        } else if (!Document.matches(barCodeData, "^[0-9]{13}$")) {
            throw new IllegalArgumentException("Parameter 'barcodeData' must be numeric and 13 digits. Value given was " + barCodeData);
        }
        if (segmentsPerRow % 2 != 0 || segmentsPerRow < 0 || segmentsPerRow > 22) {
            throw new IllegalArgumentException("Parameter 'segmentsPerRow' must be even and no greater than 22. Value given was " + Integer.valueOf(segmentsPerRow).toString());
        }
        String newTextString = textString.equals("") ? GS1Type + Integer.valueOf(pixelMultiplier).toString() + Integer.valueOf(xPixelUndercut).toString() + Integer.valueOf(yPixelUndercut).toString() + (segmentsPerRow != 0 ? String.format("%02d", segmentsPerRow) : "") + barCodeData : GS1Type + Integer.valueOf(pixelMultiplier).toString() + Integer.valueOf(xPixelUndercut).toString() + Integer.valueOf(yPixelUndercut).toString() + (segmentsPerRow != 0 ? String.format("%02d", segmentsPerRow) : "") + barCodeData + '|' + textString;
        this.writeBarCode("W1k", newTextString, row, col, parameters);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writeBarCodeAusPost4State(String textString, boolean readableText, int formatControlCode, int DPID, int row, int col, ParametersDPL parameters) {
        parameters.setNarrowBarWidth(0);
        parameters.setWideBarWidth(0);
        parameters.setSymbolHeight(0);
        if (formatControlCode != 11 && formatControlCode != 44 && formatControlCode != 45 && formatControlCode != 59 && formatControlCode != 62 && formatControlCode != 87 && formatControlCode != 92) {
            throw new IllegalArgumentException("Parameter 'formatControlCode' must be 11,44,45,59,62,87,92. Value given was " + Integer.valueOf(formatControlCode).toString());
        }
        if (DPID < 0 || DPID > 99999999) {
            throw new IllegalArgumentException("Parameter 'DPID' must be between 0-99999999. Value given was " + Integer.valueOf(DPID).toString());
        }
        if (formatControlCode == 59) {
            if (!Document.matches(textString, "^[0-9a-zA-Z]*$")) throw new IllegalArgumentException("Parameter 'textString' must contains a maximum of 5 alphanumeric characters or 8 numeric digits for BarCode 2.");
            if (Document.matches(textString, "^[0-9]*$")) {
                if (textString.length() > 8) {
                    throw new IllegalArgumentException("Parameter 'textString' contains numeric digit.Must be a maximum 8 digits for BarCode 2.");
                }
            } else if (textString.length() > 5) {
                throw new IllegalArgumentException("Parameter 'textString' contains alphanumeric characters.Must be a maximum 5 alphanumeric characters for BarCode 2.");
            }
        } else if (formatControlCode == 62) {
            if (!Document.matches(textString, "^[0-9a-zA-Z]*$")) throw new IllegalArgumentException("Parameter 'textString' must contains a maximum of 10 alphanumeric characters or 15 numeric digits for BarCode 3.");
            if (Document.matches(textString, "^[0-9]*$")) {
                if (textString.length() > 15) {
                    throw new IllegalArgumentException("Parameter 'textString' contains numeric digit.Must be a maximum 15 digits for BarCode 3.");
                }
            } else if (textString.length() > 10) {
                throw new IllegalArgumentException("Parameter 'textString' contains alphanumeric characters.Must be a maximum 10 alphanumeric characters for BarCode 3.");
            }
        }
        this.writeBarCode(readableText ? "W1M" : "W1m", Integer.valueOf(formatControlCode).toString() + String.format("%08d", DPID) + textString, row, col, parameters);
    }

    public void writeBarCodeCODABLOCK(String textString, int rowHeight, String codaBlockMode, boolean generateCheckSum, int rowsToEncode, int charPerRow, int row, int col, ParametersDPL parameters) {
        parameters.setSymbolHeight(rowHeight);
        if (!(codaBlockMode.equals("A") || codaBlockMode.equals("E") || codaBlockMode.equals("F"))) {
            throw new IllegalArgumentException("Parameter 'codaBlockMode' must be A,E, or F. Value given was " + codaBlockMode);
        }
        if (rowsToEncode < 1 || rowsToEncode > 44) {
            throw new IllegalArgumentException("Parameter 'rowsToEncode' must be between 1-44. Value given was " + Integer.valueOf(rowsToEncode).toString());
        }
        if (charPerRow < 2 || charPerRow > 62) {
            throw new IllegalArgumentException("Parameter 'charPerRow' must be between 2-62. Value given was " + Integer.valueOf(charPerRow).toString());
        }
        this.writeBarCode("W1q", codaBlockMode + (generateCheckSum ? Integer.valueOf(1).toString() : Integer.valueOf(0).toString()) + String.format("%02d", rowsToEncode) + String.format("%02d", charPerRow) + textString, row, col, parameters);
    }

    public void writeBarCodeTLC39(String serialNumber, int barCodeHeight, int ECINumber, int row, int col, ParametersDPL parameters) {
        parameters.setSymbolHeight(barCodeHeight);
        if (ECINumber < 0 || ECINumber > 999999) {
            throw new IllegalArgumentException("Parameter 'ECINumber' must be between 0-999999. Value given was " + ECINumber);
        }
        if (!Document.matches(serialNumber, "^[a-zA-Z0-9]*$") || serialNumber.length() > 25) {
            throw new IllegalArgumentException("Parameter 'serialNumber' must be 0-25 alphanumeric characters. Value given was " + serialNumber);
        }
        this.writeBarCode("W1t", Integer.valueOf(ECINumber).toString() + ';' + serialNumber, row, col, parameters);
    }

    public void writeBarCodeMicroPDF417(String textString, int dataCols, int rowIndex, boolean byteCompactMode, boolean macroCharSub, int row, int col, ParametersDPL parameters) {
        parameters.setSymbolHeight(0);
        if (rowIndex < 0 || rowIndex > 10) {
            throw new IllegalArgumentException("Parameter 'rowIndex' must be between 0-10. Value given was " + Integer.valueOf(rowIndex).toString());
        }
        if (dataCols < 1 || dataCols > 4) {
            throw new IllegalArgumentException("Parameter 'dataCols' must be between 1-4. Value given was " + Integer.valueOf(dataCols).toString());
        }
        String newTextString = Integer.valueOf(dataCols).toString() + (rowIndex == 10 ? "A" : Integer.valueOf(rowIndex).toString()) + (byteCompactMode ? Integer.valueOf(1).toString() : Integer.valueOf(0).toString()) + (macroCharSub ? Integer.valueOf(1).toString() : Integer.valueOf(0).toString()) + '0' + textString;
        this.writeBarCode("W1z", newTextString, row, col, parameters);
    }

    public void writeBarCode(String barcodeID, String textString, int row, int col, ParametersDPL parameters) {
        this.ValidatePosition(row, col);
        if (barcodeID == null || barcodeID.length() != 0 && barcodeID.length() > 3) {
            throw new IllegalArgumentException(String.format("Parameter 'barcodeID' must be at least %1$s characters in length.", 3));
        }
        if (textString == null) {
            throw new IllegalArgumentException("Parameter 'textString' was null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter 'parameters' was null.");
        }
        byte[] tempArray = this.parameterString(barcodeID, parameters, Document.PrintingType.Barcode);
        this.addToDoc(this.m_Document, tempArray);
        this.addToDoc(this.m_Document, String.format("%04d", row) + String.format("%04d", col));
        this.addToDoc(this.m_Document, textString);
        this.addToDoc(this.m_Document, EOL);
    }

    public void writeImageStored(String imageName, int row, int col, ParametersDPL parameters) {
        parameters.setRotate(ParametersDPL.Rotation.Rotate_0);
        parameters.setFont("000");
        this.addToDoc(this.m_Document, String.format("\u0002L\r\n", new Object[0]));
        this.addToDoc(this.m_Document, "A" + Integer.valueOf(this.m_LabelFormat.getValue()).toString() + "\r\n");
        if (this.getColumnOffset() > 0) {
            this.addToDoc(this.m_Document, "C" + String.format("%04d", this.getColumnOffset()) + "\r\n");
        }
        if (this.getRowOffset() > 0) {
            this.addToDoc(this.m_Document, "R" + String.format("%04d", this.getRowOffset()) + "\r\n");
        }
        this.addToDoc(this.m_Document, "D" + Integer.valueOf(this.getDotWidthMultiplier()).toString() + Integer.valueOf(this.getDotHeightMultiplier()).toString() + "\r\n");
        if (this.getHeatSettings() != 10) {
            this.addToDoc(this.m_Document, "H" + String.format("%02d", this.getHeatSettings()) + "\r\n");
        }
        byte[] tempArray = this.parameterString("Y", parameters, Document.PrintingType.Image);
        this.addToDoc(this.m_Document, tempArray);
        this.addToDoc(this.m_Document, String.format("%04d", row) + String.format("%04d", col));
        this.addToDoc(this.m_Document, imageName);
        this.addToDoc(this.m_Document, EOL);
        this.addToDoc(this.m_Document, "E\r\n");
    }

    public void writeImage(String imagePath, ImageType imageType, int row, int col, ParametersDPL parameters) throws Exception {
        BufferedImage imageBitmap = ImageIO.read(new File(imagePath));
        byte[] bitmapData = new byte[]{0};
        if (imageBitmap == null) {
            File imageFile = new File(imagePath);
            bitmapData = new byte[(int)imageFile.length()];
            BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(imageFile));
            ((InputStream)inputStream).read(bitmapData);
            ((InputStream)inputStream).close();
            this.writeImage(bitmapData, imageType, row, col, parameters);
        } else {
            this.writeImage(imageBitmap, imageType, row, col, parameters);
        }
    }

    public void writeImage(BufferedImage imageObject, ImageType imageType, int row, int col, ParametersDPL parameters) throws Exception {
        if (imageObject == null) {
            throw new IllegalArgumentException("Parameter 'imageObject' was null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter 'parameters' was null.");
        }
        imageType = ImageType.BMPFlipped_8Bit;
        MonoBitmapConverter monoBMconv = new MonoBitmapConverter();
        byte[] bitmapData = monoBMconv.convertBitmap(imageObject);
        this.writeImage(bitmapData, imageType, row, col, parameters);
    }

    public void writeImage(byte[] imageData, ImageType imageType, int row, int col, ParametersDPL parameters) throws Exception {
        this.ValidatePosition(row, col);
        if (imageData == null) {
            throw new IllegalArgumentException("Parameter 'imageData' was null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter 'parameters' was null.");
        }
        parameters.setRotate(ParametersDPL.Rotation.Rotate_0);
        parameters.setFont("000");
        this.addToDoc(this.m_Document, String.format("\u0002qE\r\n", new Object[0]));
        this.addToDoc(this.m_Document, String.format("\u0002XE\r\n", new Object[0]));
        this.addToDoc(this.m_Document, this.getInputImageDataCommand("image_downloaded", imageType));
        this.addToDoc(this.m_Document, imageData);
        this.addToDoc(this.m_Document, EOL);
        this.addToDoc(this.m_Document, String.format("\u0002L\r\n", new Object[0]));
        this.addToDoc(this.m_Document, "A" + Integer.valueOf(this.m_LabelFormat.getValue()).toString() + "\r\n");
        if (this.getColumnOffset() > 0) {
            this.addToDoc(this.m_Document, "C" + String.format("%04d", this.getColumnOffset()) + "\r\n");
        }
        if (this.getRowOffset() > 0) {
            this.addToDoc(this.m_Document, "R" + String.format("%04d", this.getRowOffset()) + "\r\n");
        }
        this.addToDoc(this.m_Document, "D" + Integer.valueOf(this.getDotWidthMultiplier()).toString() + Integer.valueOf(this.getDotHeightMultiplier()).toString() + "\r\n");
        if (this.getHeatSettings() != 10) {
            this.addToDoc(this.m_Document, "H" + String.format("%02d", this.getHeatSettings()) + "\r\n");
        }
        byte[] tempArray = this.parameterString("Y", parameters, Document.PrintingType.Image);
        this.addToDoc(this.m_Document, tempArray);
        this.addToDoc(this.m_Document, String.format("%04d", row) + String.format("%04d", col));
        this.addToDoc(this.m_Document, "image_downloaded");
        this.addToDoc(this.m_Document, EOL);
        this.addToDoc(this.m_Document, "E\r\n");
        this.addToDoc(this.m_Document, String.format("\u0002qE\r\n", new Object[0]));
    }

    public void writeLine(int row, int col, int height, int width) {
        ParametersDPL parameters = new ParametersDPL();
        parameters.setFillPattern(0);
        parameters.setRotate(ParametersDPL.Rotation.Rotate_0);
        parameters.setHorizontalMultiplier(1);
        parameters.setVerticalMultiplier(1);
        if (width < 0 || width > 9999) {
            throw new IllegalArgumentException("Parameter 'width' must be between 0 and 9999.");
        }
        if (height < 0 || height > 9999) {
            throw new IllegalArgumentException("Parameter 'height' must be between 0 and 9999.");
        }
        String lineData = "l" + String.format("%04d", width) + String.format("%04d", height);
        this.writeGraphics(lineData, row, col, parameters);
    }

    public void writeBox(int row, int col, int height, int width, int topBottomThickness, int sideThickness) {
        ParametersDPL parameters = new ParametersDPL();
        parameters.setFillPattern(0);
        parameters.setRotate(ParametersDPL.Rotation.Rotate_0);
        parameters.setHorizontalMultiplier(1);
        parameters.setVerticalMultiplier(1);
        if (width < 0 || width > 9999) {
            throw new IllegalArgumentException("Parameter 'width' must be between 0 and 9999.");
        }
        if (height < 0 || height > 9999) {
            throw new IllegalArgumentException("Parameter 'height' must be between 0 and 9999.");
        }
        if (topBottomThickness < 0 || topBottomThickness > 9999) {
            throw new IllegalArgumentException("Parameter 'topBottomThickness' must be between 0 and 9999.");
        }
        if (sideThickness < 0 || sideThickness > 9999) {
            throw new IllegalArgumentException("Parameter 'sideThickness' must be between 0 and 9999.");
        }
        String boxData = "b" + String.format("%04d", width) + String.format("%04d", height) + String.format("%04d", topBottomThickness) + String.format("%04d", sideThickness);
        this.writeGraphics(boxData, row, col, parameters);
    }

    public void writeTriangle(int fillPattern, int rowPt1, int colPt1, int rowPt2, int colPt2, int rowPt3, int colPt3) {
        ParametersDPL parameters = new ParametersDPL();
        parameters.setFillPattern(fillPattern);
        parameters.setRotate(ParametersDPL.Rotation.Rotate_0);
        parameters.setHorizontalMultiplier(1);
        parameters.setVerticalMultiplier(1);
        if (rowPt2 < 0 || rowPt2 > 9999) {
            throw new IllegalArgumentException("Parameter 'rowPt2' must be between 0 and 9999.");
        }
        if (colPt2 < 0 || colPt2 > 9999) {
            throw new IllegalArgumentException("Parameter 'colPt2' must be between 0 and 9999.");
        }
        if (rowPt3 < 0 || rowPt3 > 9999) {
            throw new IllegalArgumentException("Parameter 'rowPt3' must be between 0 and 9999.");
        }
        if (colPt3 < 0 || colPt3 > 9999) {
            throw new IllegalArgumentException("Parameter 'colPt3' must be between 0 and 9999.");
        }
        String TriangleData = "P0010001" + String.format("%04d", rowPt2) + String.format("%04d", colPt2) + String.format("%04d", rowPt3) + String.format("%04d", colPt3);
        this.writeGraphics(TriangleData, rowPt1, colPt1, parameters);
    }

    public void writeRectangle(int fillPattern, int rowPt1, int colPt1, int rowPt2, int colPt2, int rowPt3, int colPt3, int rowPt4, int colPt4) {
        ParametersDPL parameters = new ParametersDPL();
        parameters.setFillPattern(fillPattern);
        parameters.setRotate(ParametersDPL.Rotation.Rotate_0);
        parameters.setHorizontalMultiplier(1);
        parameters.setVerticalMultiplier(1);
        if (rowPt2 < 0 || rowPt2 > 9999) {
            throw new IllegalArgumentException("Parameter 'rowPt2' must be between 0 and 9999.");
        }
        if (colPt2 < 0 || colPt2 > 9999) {
            throw new IllegalArgumentException("Parameter 'colPt2' must be between 0 and 9999.");
        }
        if (rowPt3 < 0 || rowPt3 > 9999) {
            throw new IllegalArgumentException("Parameter 'rowPt3' must be between 0 and 9999.");
        }
        if (colPt3 < 0 || colPt3 > 9999) {
            throw new IllegalArgumentException("Parameter 'colPt3' must be between 0 and 9999.");
        }
        if (rowPt4 < 0 || rowPt4 > 9999) {
            throw new IllegalArgumentException("Parameter 'rowPt4' must be between 0 and 9999.");
        }
        if (colPt4 < 0 || colPt4 > 9999) {
            throw new IllegalArgumentException("Parameter 'colPt4' must be between 0 and 9999.");
        }
        String rectData = "P0010001" + String.format("%04d", rowPt2) + String.format("%04d", colPt2) + String.format("%04d", rowPt3) + String.format("%04d", colPt3) + String.format("%04d", rowPt4) + String.format("%04d", colPt4);
        this.writeGraphics(rectData, rowPt1, colPt1, parameters);
    }

    public void writeCircle(int fillPattern, int centerRow, int centerCol, int radius) {
        ParametersDPL parameters = new ParametersDPL();
        parameters.setFillPattern(fillPattern);
        parameters.setRotate(ParametersDPL.Rotation.Rotate_0);
        parameters.setHorizontalMultiplier(1);
        parameters.setVerticalMultiplier(1);
        if (radius < 0 || radius > 9999) {
            throw new IllegalArgumentException("Parameter 'radius' must be between 0 and 9999.");
        }
        String circleData = "C0010001" + String.format("%04d", radius);
        this.writeGraphics(circleData, centerRow, centerCol, parameters);
    }

    public void writeGraphics(String graphicData, int row, int col, ParametersDPL parameters) {
        this.ValidatePosition(row, col);
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter 'parameters' was null.");
        }
        if (graphicData == null) {
            throw new IllegalArgumentException("Parameter 'graphicData' was null");
        }
        byte[] tempArray = this.parameterString("X", parameters, Document.PrintingType.Graphics);
        this.addToDoc(this.m_Document, tempArray);
        this.addToDoc(this.m_Document, String.format("%04d", row) + String.format("%04d", col));
        this.addToDoc(this.m_Document, graphicData);
        this.addToDoc(this.m_Document, EOL);
    }

    private void ValidatePosition(int row, int col) {
        if (row < 0 || row > 9999) {
            throw new IllegalArgumentException(String.format("Parameter 'row' must be an integer from 0 to 9999, a value of %1$s was given.", row));
        }
        if (col < 0 || col > 9999) {
            throw new IllegalArgumentException(String.format("Parameter 'col' must be an integer from 0 to 9999, a value of %1$s was given.", col));
        }
    }

    private byte[] parameterString(String typeID, ParametersDPL parameters, Document.PrintingType printingType) {
        ByteArrayOutputStream mStream = new ByteArrayOutputStream(128);
        if (parameters.getAlignment() == ParametersDPL.Alignment.Center) {
            this.addToDoc(mStream, "JC\r\n");
        } else if (parameters.getAlignment() == ParametersDPL.Alignment.Right) {
            this.addToDoc(mStream, "JR\r\n");
        }
        if (parameters.getIsMirrored()) {
            this.addToDoc(mStream, "M\r\n");
        }
        if (parameters.getMeasurement() == ParametersDPL.MeasurementMode.Metric) {
            this.addToDoc(mStream, "m\r\n");
        }
        String encodingValue = "";
        if (parameters.getIsUnicode()) {
            if (printingType == Document.PrintingType.General || printingType == Document.PrintingType.Barcode) {
                encodingValue = parameters.SymbolSetToString(parameters.getDBSymbolSet());
                this.addToDoc(mStream, "yU" + encodingValue + "\r\n");
            }
        } else if (printingType == Document.PrintingType.General || printingType == Document.PrintingType.Barcode) {
            encodingValue = parameters.SymbolSetToString(parameters.getSBSymbolSet());
            this.addToDoc(mStream, "yS" + encodingValue + "\r\n");
        }
        this.addToDoc(mStream, Integer.toString(parameters.getRotate().getValue()));
        this.addToDoc(mStream, typeID);
        if (printingType == Document.PrintingType.Barcode) {
            String tempArray = (String)(this.valueRemap(parameters.getWideBarWidth()) < 10 ? Integer.toString(this.valueRemap(parameters.getWideBarWidth())) : Character.valueOf((char)this.valueRemap(parameters.getWideBarWidth())));
            this.addToDoc(mStream, tempArray);
            tempArray = (String)(this.valueRemap(parameters.getNarrowBarWidth()) < 10 ? Integer.toString(this.valueRemap(parameters.getNarrowBarWidth())) : Character.valueOf((char)this.valueRemap(parameters.getNarrowBarWidth())));
            this.addToDoc(mStream, tempArray);
            this.addToDoc(mStream, String.format("%03d", parameters.getSymbolHeight()));
        } else if (printingType == Document.PrintingType.Graphics) {
            String tempArray = (String)(this.valueRemap(parameters.getHorizontalMultiplier()) < 10 ? Integer.toString(this.valueRemap(parameters.getHorizontalMultiplier())) : Character.valueOf((char)this.valueRemap(parameters.getHorizontalMultiplier())));
            this.addToDoc(mStream, tempArray);
            tempArray = (String)(this.valueRemap(parameters.getVerticalMultiplier()) < 10 ? Integer.toString(this.valueRemap(parameters.getVerticalMultiplier())) : Character.valueOf((char)this.valueRemap(parameters.getVerticalMultiplier())));
            this.addToDoc(mStream, tempArray);
            this.addToDoc(mStream, String.format("%03d", parameters.getFillPattern()));
        } else {
            String tempArray = (String)(this.valueRemap(parameters.getHorizontalMultiplier()) < 10 ? Integer.toString(this.valueRemap(parameters.getHorizontalMultiplier())) : Character.valueOf((char)this.valueRemap(parameters.getHorizontalMultiplier())));
            this.addToDoc(mStream, tempArray);
            tempArray = (String)(this.valueRemap(parameters.getVerticalMultiplier()) < 10 ? Integer.toString(this.valueRemap(parameters.getVerticalMultiplier())) : Character.valueOf((char)this.valueRemap(parameters.getVerticalMultiplier())));
            this.addToDoc(mStream, tempArray);
            if (parameters.getFont().equals("000")) {
                tempArray = parameters.getFont();
                this.addToDoc(mStream, tempArray);
            } else if (parameters.getIsUnicode()) {
                tempArray = "u" + parameters.getFont();
                this.addToDoc(mStream, tempArray);
            } else {
                tempArray = "S" + parameters.getFont();
                this.addToDoc(mStream, tempArray);
            }
        }
        return mStream.toByteArray();
    }

    private int valueRemap(int value) {
        if (value > 0 && value < 10) {
            return value;
        }
        if (value >= 10 && value < 36) {
            return value + 55;
        }
        if (value >= 36 && value < 62) {
            return value + 61;
        }
        return value;
    }

    @Override
    public byte[] getDocumentData() {
        ByteArrayOutputStream mStream = new ByteArrayOutputStream();
        this.addToDoc(mStream, "\u0002L\r\n");
        this.addToDoc(mStream, "A" + this.getLabelFormat().getValue() + "\r\n");
        if (this.getColumnOffset() > 0) {
            this.addToDoc(mStream, "C" + String.format("%04d", this.getColumnOffset()) + "\r\n");
        }
        if (this.getRowOffset() > 0) {
            this.addToDoc(mStream, "R" + String.format("%04d", this.getRowOffset()) + "\r\n");
        }
        if (this.getDotWidthMultiplier() != 1 && this.getDotHeightMultiplier() != 1) {
            this.addToDoc(mStream, "D" + Integer.toString(this.getDotWidthMultiplier()) + Integer.toString(this.getDotHeightMultiplier()) + "\r\n");
        }
        if (this.getHeatSettings() != 10) {
            this.addToDoc(mStream, "H" + String.format("%02d", this.getHeatSettings()) + "\r\n");
        }
        this.addToDoc(mStream, this.m_Document.toByteArray());
        this.addToDoc(mStream, "E\r\n");
        return mStream.toByteArray();
    }

    public byte[] getDocumentImageData() {
        ByteArrayOutputStream mStream = new ByteArrayOutputStream();
        this.addToDoc(mStream, this.m_Document.toByteArray());
        return mStream.toByteArray();
    }

    public String getInputImageDataCommand(String imageName, ImageType imageType) {
        String inputImageDataCommand = "\u0002IE";
        if (imageType == ImageType.DOImage_7Bit) {
            inputImageDataCommand = inputImageDataCommand + "A";
            inputImageDataCommand = inputImageDataCommand + "F";
        } else {
            switch (imageType) {
                case BMPFlipped_8Bit: {
                    inputImageDataCommand = inputImageDataCommand + "B";
                    break;
                }
                case BMP_8Bit: {
                    inputImageDataCommand = inputImageDataCommand + "b";
                    break;
                }
                case IMGFlipped_8Bit: {
                    inputImageDataCommand = inputImageDataCommand + "I";
                    break;
                }
                case IMG_8Bit: {
                    inputImageDataCommand = inputImageDataCommand + "i";
                    break;
                }
                case PCXFlipped_8Bit: {
                    inputImageDataCommand = inputImageDataCommand + "P";
                    break;
                }
                case PCX_8Bit: {
                    inputImageDataCommand = inputImageDataCommand + "p";
                    break;
                }
                default: {
                    inputImageDataCommand = inputImageDataCommand + "B";
                }
            }
            inputImageDataCommand = inputImageDataCommand + imageName + "\r\n";
        }
        return inputImageDataCommand;
    }

    public static String rightPad(String str, int size, char padChar) {
        if (str == null) {
            return null;
        }
        int pads = size - str.length();
        if (pads <= 0) {
            return str;
        }
        if (pads > 8192) {
            return DocumentDPL.rightPad(str, size, String.valueOf(padChar));
        }
        return str.concat(DocumentDPL.padding(pads, padChar));
    }

    public static String rightPad(String str, int size, String padStr) {
        if (str == null) {
            return null;
        }
        if (padStr.equals("")) {
            padStr = " ";
        }
        int padLen = padStr.length();
        int strLen = str.length();
        int pads = size - strLen;
        if (pads <= 0) {
            return str;
        }
        if (padLen == 1 && pads <= 8192) {
            return DocumentDPL.rightPad(str, size, padStr.charAt(0));
        }
        if (pads == padLen) {
            return str.concat(padStr);
        }
        if (pads < padLen) {
            return str.concat(padStr.substring(0, pads));
        }
        char[] padding = new char[pads];
        char[] padChars = padStr.toCharArray();
        for (int i = 0; i < pads; ++i) {
            padding[i] = padChars[i % padLen];
        }
        return str.concat(new String(padding));
    }

    private static String padding(int repeat, char padChar) throws IndexOutOfBoundsException {
        if (repeat < 0) {
            throw new IndexOutOfBoundsException("Cannot pad a negative amount: " + repeat);
        }
        char[] buf = new char[repeat];
        for (int i = 0; i < buf.length; ++i) {
            buf[i] = padChar;
        }
        return new String(buf);
    }

    public static enum Font_Type {
        InternalBitmapped(0),
        Scalable(9);

        private int value;

        private Font_Type(int intValue) {
            this.value = intValue;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum ImageType {
        DOImage_7Bit,
        BMPFlipped_8Bit,
        BMP_8Bit,
        IMG_8Bit,
        IMGFlipped_8Bit,
        PCXFlipped_8Bit,
        PCX_8Bit,
        Other;

    }

    public static enum Label_Format {
        XOR_Mode(1),
        Transparent_Mode(2),
        Opaque_Mode(3),
        Inverse_Mode(5);

        private int value;

        private Label_Format(int intValue) {
            this.value = intValue;
        }

        public int getValue() {
            return this.value;
        }
    }
}

