/*
 * Decompiled with CFR 0.152.
 */
package datamaxoneil.printer;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class Document {
    public static char ESC = (char)27;
    protected static byte[] EOL = new byte[]{13, 10};
    protected ByteArrayOutputStream m_Document = new ByteArrayOutputStream(1024);
    private String m_DefaultFont = "";
    int m_FontNameLength = 0;
    private boolean m_LandscapeMode = false;

    public String getDefaultFont() {
        return this.m_DefaultFont;
    }

    public void setDefaultFont(String fontName) {
        if (fontName == null || fontName.length() != this.m_FontNameLength) {
            throw new IllegalArgumentException("Parameter 'fontName' must be " + this.m_FontNameLength + " characters in length.");
        }
        this.m_DefaultFont = fontName;
    }

    public boolean getIsLandscapeMode() {
        return this.m_LandscapeMode;
    }

    public void setIsLandscapeMode(boolean isLandscapeMode) {
        this.m_LandscapeMode = isLandscapeMode;
    }

    public void clear() {
        this.m_Document.reset();
    }

    protected void addToDoc(ByteArrayOutputStream dataStream, String text) {
        char[] charArray = text.toCharArray();
        for (int index = 0; index < charArray.length; ++index) {
            if (charArray[index] <= '\u00ff') {
                this.addToDoc(dataStream, (byte)charArray[index]);
                continue;
            }
            this.addToDoc(dataStream, (byte)(charArray[index] >> 8));
            this.addToDoc(dataStream, (byte)(charArray[index] & 0xFF));
        }
    }

    protected void addToDoc(ByteArrayOutputStream dataStream, byte[] data) {
        try {
            dataStream.write(data);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static boolean matches(CharSequence input, String regex) {
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(input);
        return m.matches();
    }

    protected void addToDoc(ByteArrayOutputStream dataStream, byte data) {
        dataStream.write(data);
    }

    public abstract byte[] getDocumentData();

    protected static enum PrintingType {
        General,
        Barcode,
        Barcode417,
        Line,
        Image,
        Graphics;

    }
}

